function ResetLayout(obj)

import siman.*;

panelID = obj.PanelID;
units = get(panelID, 'Units');
set(panelID, 'Units', 'pixels');
panelArea = get(panelID, 'Position');
set(panelID, 'Units', units);
axesMargin = 5;
margin = siman.UIHelper.PANEL_MARGIN;
inset = 7;
indicatorHeight = 18;

plots = obj.Plots;
plotCount = plots.Count;

% Inner drawing area (inset for nice figure-color border effect)
plotPanelID = obj.PlotPanelID;
drawingArea = [inset, inset + indicatorHeight, ...
    panelArea(3)-2*inset, panelArea(4)-2*inset - indicatorHeight];
drawingArea(3) = max(1, drawingArea(3));
drawingArea(4) = max(1, drawingArea(4));
set(plotPanelID, 'Position', drawingArea);

% Cursor Indicator (placed outside of drawing area on bottom (on the figure-color
% area)
indicatorID = obj.CursorIndicatorID;
indPos = [panelArea(3)/2, 1, panelArea(3)/2-inset, indicatorHeight+2];
set(indicatorID, 'Position', indPos);

% Frame Indicator (placed outside of drawing area on bottom (on the figure-color
% area)
indicatorID = obj.FrameIndicatorID;
indPos = [inset, 1, panelArea(3)/2-inset, indicatorHeight+2];
set(indicatorID, 'Position', indPos);

% Hidden axes for displaying messages (mainly "No image selected");
messagePos = [0, indicatorHeight, panelArea(3), panelArea(4) - indicatorHeight];
messagePos(3) = max(1, messagePos(3));
messagePos(4) = max(1, messagePos(4));
set(obj.MessageAxesID, 'Units', 'pixels', 'Position', messagePos);
set(obj.MessageAxesID, 'Units', 'normalized');

% Now give individual image plots their area (often only 1 image)
% Make axes have slight margin inside drawing area.
if plotCount == 0
    set(obj.ZoomControlID, 'Visible', 'off');
    return
end

% Zoom Indicator
controlID = obj.ZoomControlID;
pos = get(controlID, 'Position');
%pos(1) = panelArea(3) - pos(3) - margin;
%pos(2) = panelArea(4) - pos(4) - margin;
pos(1) = inset;
pos(2) = inset + indicatorHeight;
set(controlID, 'Position', pos, 'Visible', 'on');


if plotCount == 1 % Shortcut for common case and early development
    plot = plots.ElementAt(1);
    bounds = [axesMargin, axesMargin, drawingArea(3)-2*axesMargin, drawingArea(4)-2*axesMargin];
    bounds(3) = max(1, bounds(3));
    bounds(4) = max(1, bounds(4));
    plot.SetBounds(bounds);
else
%     freeSpace = fpos;
%     panelCount = dockedPanels.Count;
%     for i = 1:panelCount
%         panel = panels.ElementAt(i);
%         dockLoc = panel.dockedLocation;
%         switch dockLoc
%             case 'east'
%                 sz = panel.Size;
%                 panelPos = [freeSpace(3) - sz(1), 0, sz(1), freeSpace(4)];
%                 panel.SetPosition(panelPos);
%                 freeSpace(3) = panelPos(3)-1;
%             case 'south'
%                 sz = panel.Size;
%                 panelPos = [0, freeSpace(4) - sz(2), freeSpace(3), sz(2)];
%                 panel.SetPosition(panelPos);
%                 freeSpace(4) = panelPos(4)-1;
%         end
%     end
end



