function MakeControls(obj)

panelID = obj.PanelID;
color = get(panelID, 'BackgroundColor');
margin = siman.UIHelper.PANEL_MARGIN;
pos = get(panelID, 'Position');
top = pos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;

children = get(panelID, 'Children');
delete(children);


% Create panel that will hold general processing controls
subpanelWidth = 10;
subpanelHeight = 10;
mainSubpanelPos = [2 2 subpanelWidth subpanelHeight];
mainSubpanel = uipanel('Parent', panelID, ...
    'Units', 'pixels', 'Position', mainSubpanelPos, ...
    'Tag', 'Main Subpanel', 'BackgroundColor', color, ...
    'BorderType', 'none');
obj.MainSubpanelID = mainSubpanel;

% Create panel that will hold operation controls
obj.OperationSubpanelID = uipanel('Parent', panelID, ...
    'FontSize', siman.UIHelper.FONT_SIZE + 2, ...
    'Units', 'pixels', 'Position', [10 10 10 10], ...
    'Tag', 'Operation Subpanel', 'BackgroundColor', color, ...
    'BorderType', 'line', 'ForegroundColor', [0 0 0], ...
    'HighlightColor', [.4 .4 .4]);
obj.MessageAxesID = axes('Parent', panelID, 'Visible', 'off', 'Color', 'none', ...
    'XLim', [0 1], 'YLim', [0 1], 'Tag', 'Message Axes', 'Units', 'pixels');

% Add main controls that won't change
controlParams.ParentPanel = mainSubpanel;
controlParams.DataObject = obj.ProcessingDef;
controlParams.Controller = obj;

location = [margin-2 top-2]; % adjusting by 2 since subpanel is at 2 2 for some reason

controlParams.Width = 200;
controlParams.Callback = @obj.ControlChanged;
controlParams.RefreshCallback = @obj.UpdateControl;
controlParams.ListOptions = {'none'}; % refresh will fill this in
location = siman.UIHelper.MakeLabeledPopup('DefinitionList', 'Showing:', ...
    location, controlParams);

controlParams.Width = 150;
controlParams.Callback = [];
controlParams.RefreshCallback = [];
location = siman.UIHelper.MakeLabeledTextbox('Name', 'Name:', ...
    location, controlParams);

controlParams.Width = 250;
controlParams.Height = 90;
controlParams.Callback = @obj.ControlChanged;
controlParams.RefreshCallback = @obj.UpdateControl;
[location, h] = siman.UIHelper.MakeLabeledListbox('OperationList', 'Operations:', ...
    location, controlParams);

% listboxPos = [30 45 200 70];
% pos = [listboxPos(1)+5 listboxPos(2)+listboxPos(4)+2 listboxPos(3)-5 textHeight];
% uicontrol('Parent', mainSubpanel, 'Style', 'text', 'String', 'Operations:', ...
%     'Tag', 'OperationListLabel', 'Position', pos, 'HorizontalAlignment', 'left', ...
%     'BackgroundColor', color);
% uicontrol('Parent', mainSubpanel, 'Style', 'listbox', ...
%     'Tag', 'OperationList', 'Position', listboxPos, 'Callback', callback);
% 
% pos = [listboxPos(1) listboxPos(2)+listboxPos(4)+24 45 textHeight];
% h = uicontrol('Parent', mainSubpanel, 'Style', 'text', 'String', 'Name:', ...
%     'Tag', 'NameLabel', 'Position', pos, 'HorizontalAlignment', 'left', ...
%     'BackgroundColor', color);
% extent = get(h, 'Extent');
% pos = [listboxPos(1)+extent(3)+5 pos(2) 150 textHeight+2];
% uicontrol('Parent', mainSubpanel, 'Style', 'edit', ...
%     'Tag', 'Name', 'Position', pos, 'Callback', callback, 'HorizontalAlignment', 'left');
% 
% 
% pos = [listboxPos(1) listboxPos(2)+listboxPos(4)+50 50 textHeight];
% h = uicontrol('Parent', mainSubpanel, 'Style', 'text', 'String', 'Showing:', ...
%     'Tag', 'DefinitionListLabel', 'Position', pos, 'HorizontalAlignment', 'left', ...
%     'BackgroundColor', color);
% extent = get(h, 'Extent');
% pos = [listboxPos(1)+extent(3)+4 pos(2)+5 150 textHeight];
% uicontrol('Parent', mainSubpanel, 'Style', 'popupmenu', ...
%     'Tag', 'DefinitionList', 'Position', pos, 'Callback', callback, 'HorizontalAlignment', 'left', ...
%     'String', ' ');

pos = get(h, 'Position');
location = pos([1 2]);
controlParams.Callback = []; % Clear values from above
controlParams.RefreshCallback = [];
controlParams.Context = obj;

controlParams.CommandName = 'ProcessingDef.InsertOperation';
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = 'ProcessingDef.DeleteOperation';
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = 'ProcessingDef.MoveUpOperation';
location(1) = location(1) + siman.UIHelper.TOOLBAR_BUTTON_SPACER;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = 'ProcessingDef.MoveDownOperation';
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = 'ProcessingDef.SkipOperation';
controlParams.IsToggle = true;
controlParams.RefreshCallback = @obj.UpdateControl;
location(1) = location(1) + siman.UIHelper.TOOLBAR_BUTTON_SPACER;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = 'ProcessingDef.StopOperation';
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.RefreshCallback = [];
controlParams.CommandName = 'ProcessingDef.ChangeOperationType';
controlParams.IsToggle = false;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

% mask cell
% mask value (color?)
%


end