function result = ProcessSource(obj, source)

if ~isequal(source, obj.LastProcessedSource)
    obj.ClearStoredResults();
end

result = source.GetData();
obj.CancelRequested = false;

ops = obj.GetActiveOperations();
count = ops.Count;
if count == 0
    obj.IsRGB = source.IsRGB;
    return;
end

if ~isempty(obj.LastCellDefinition)
    delete(obj.LastCellDefinition);
    obj.LastCellDefinition = [];
end
if obj.ApplyMask
    cellDefinition = source.CellDefinition;
    obj.LastCellDefinition = copy(cellDefinition);
    obj.ImageMask = cellDefinition.GetMask();
    maskIndexes = find(~obj.ImageMask); %TODO: make this precalculated
end

if source.IsRGB
    map = repmat(linspace(0, 1, 64)', [1 3]);
    result = rgb2ind(result, map);
end
obj.IsRGB = false;

% Loop through and run the operations on the image
obj.BaselineOperation = [];
for i = 1:count
    if obj.CancelRequested
        break;
    end
    op = ops.ElementAt(i);
    if strcmp(op.Type, 'restore original')
        result = source.GetData();
        if source.IsRGB
            map = repmat(linspace(0, 1, 64)', [1 3]);
            result = rgb2ind(result, map);
        end
    else
        if strcmp(op.Type, 'calculate baseline')
            baselineInfo = op.GetStoredResults();
            if isempty(baselineInfo)
                baselineInfo = op.PerformOperation(result, obj);
            end
            obj.Baseline = baselineInfo{1};
            obj.BaselineStandardDeviation = baselineInfo{2};
            if length(baselineInfo) > 2
                result = baselineInfo{3}; % 3rd argument is baseline or std dev itself replacing the image
            end
        else
            stored = op.GetStoredResults();
            if ~isempty(stored)
                result = stored;
            else
                result = op.PerformOperation(result, obj);
            end
        end
    end
    if strcmp(op.Type, 'calculate baseline')
        obj.BaselineOperation = op;
    end
end

if obj.CancelRequested
    obj.ErrorMessage = 'Processing Cancelled';
    return;
end

dim = size(result);
if numel(dim) < 3
    dim(3) = 1;
end
if obj.ApplyMask && ~isempty(maskIndexes)
    if dim(3) == 1
        result(maskIndexes) = obj.MaskValue;
    else
        for i = 1:dim(3)
            frame = result(:, :, i);
            frame(maskIndexes) = obj.MaskValue;
            result(:, : , i) = frame;
        end
    end
end