function description = GetDescription(obj)

import siman.*;

type = obj.Type;
description = type;
switch lower(type)
    case 'subtract background'
        description = [type '  (' num2str(obj.BackgroundValue) ')'];
    case 'median filter'
        switch obj.MedianFilterType
            case 'equal sides'
                val = obj.MedianFilterWidth;
                description = [type '  (' num2str(val) 'x' num2str(val)];
                if val > 3
                    description = [description ' ' obj.MedianFilterShape ')'];
                else
                    description = [description ')'];
                end
            case 'independent sides'
            case 'custom'
        end
    case 'calculate baseline'
        switch obj.BaselineCalcMethod
            case 'minimum region'
                val = obj.BaselineMinimumRegionWidth;
                description = [type '  (min ' num2str(val) ')'];
            case 'manual region'
                start = obj.BaselineManualRegionStart;
                stop = obj.BaselineManualRegionStop;
                description = [type '  (manual: ' num2str(start) ' to ' num2str(stop) ')'];
            case 'sliding region'
                width = obj.BaselineSlidingRegionWidth;
                description = [type '  (sliding window: ' num2str(width) ')'];
            case 'rolling ball'
                radius = obj.BaselineRollingRadius;
                description = [type '  (rolling ball, r: ' num2str(radius) ')'];
        end
    case 'baseline normalization'
        description = [type ' (' obj.BaselineNormMethod ')'];
    case 'threshold'
        switch obj.ThresholdType
            case 'fixed value'
                val = obj.ThresholdValue;
                description = [type ' at fixed value of ' num2str(val)];
            case 'baseline st dev'
                val = obj.ThresholdValue;
                description = [type ' at ' num2str(val) ' sd units'];
            case 'baseline percent'
                val = obj.ThresholdValue;
                if val < 1
                    val = round(val*100);
                else
                    val = round(val);
                end
                description = [type ' at ' num2str(val) '% of baseline'];
        end
    case 'morph'
        switch obj.MorphType
            case {'dilate', 'erode', 'close', 'open'}
                description = ['morph: ' obj.MorphType ' (' obj.MorphKernel.GetDescription() ')'];
            case {'dilate with threshold', 'erode with threshold'}
                description = ['morph: ' obj.MorphType ' (' obj.MorphKernel.GetDescription() ...
                    ', thr=' num2str(obj.MorphThresholdActual) ')'];
        end
    case 'swap dimensions'
        dimensions = obj.SwapDimensions;
        switch (dimensions)
            case 'y,z'
                description = 'swap y and z dimensions';
        end
        
    case 'collapse dimension'
        dimension = obj.CollapseDimension;
        switch (dimension)
            case 'z'
                description = 'collapse z dimension to make an average 2-d image';
        end
        
    case 'convert to ca'
        switch obj.ConvertCaMethod
            case {'resting'}
                description = ['convert to ca (rest=' num2str(obj.ConvertCaRestingConc) ', Kd=' num2str(obj.ConvertCaKd) ')'];
            case {'fmin-fmax'}
                description = ['convert to ca (fMax=' num2str(obj.ConvertCaFMax) ', Rf=' num2str(obj.ConvertCaRf) ')'];
        end
        
    case 'restore original'
        description = 'restore original';
                
    otherwise
        description = type;
end







