function MakeControls(obj, parentPanel)

import siman.*;
margin = siman.UIHelper.PANEL_MARGIN;
pos = get(parentPanel, 'Position');
top = pos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;

location = [margin top];

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = obj;
controlParams.Controller = obj;

type = obj.Type;
switch lower(type)
    case 'subtract background'
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('BackgroundValue', 'Background Value:', ...
            location, controlParams);
                
    case 'median filter'
        controlParams.Width = 90;
        location = siman.UIHelper.MakeLabeledPopup('MedianFilterType', 'Filter configuration:', ...
            location, controlParams);
        
        switch obj.MedianFilterType
            case 'equal sides'
                controlParams.Width = 60;
                location = siman.UIHelper.MakeLabeledTextbox('MedianFilterWidth', 'Filter width:', ...
                    location, controlParams);
            case 'independent sides'
            case 'custom'
        end
        
    case 'calculate baseline'
        controlParams.Width = 150;
        location = siman.UIHelper.MakeLabeledPopup('BaselineResultAction', 'Action with result:', ...
            location, controlParams);
        
        controlParams.Width = 100;
        location = siman.UIHelper.MakeLabeledPopup('BaselineFormat', 'Baseline format:', ...
            location, controlParams);
        
        controlParams.Width = 150;
        location = siman.UIHelper.MakeLabeledPopup('BaselineCalcMethod', 'Calculation method:', ...
            location, controlParams);
        
        switch obj.BaselineCalcMethod
            case 'minimum region'
                controlParams.Width = 60;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineMinRegionFilterWidth', 'Filter width for min region:', ...
                    location, controlParams);
                
                controlParams.Width = 60;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineMinimumRegionWidth', 'Region width:', ...
                    location, controlParams);
                
            case 'manual region'
                controlParams.Width = 40;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineManualRegionStart', 'Start line:', ...
                    location, controlParams);
                
                location = siman.UIHelper.MakeLabeledTextbox('BaselineManualRegionStop', 'Stop line:', ...
                    location, controlParams);
                
            case 'sliding region'
                controlParams.Width = 40;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineSlidingRegionWidth', 'Region width:', ...
                    location, controlParams);
                
            case 'rolling ball'
                controlParams.Width = 40;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineRollingRadius', 'Ball radius:', ...
                    location, controlParams);
        end
        switch obj.BaselineFormat
            case 'linescan'
                controlParams.Width = 60;
                location = siman.UIHelper.MakeLabeledTextbox('BaselineLinescanMedianFilterWidth', 'Filter width for baseline:', ...
                    location, controlParams);
                
            case '2-d'
                obj.BaselineKernel.MakeControls(location, controlParams);
        end
        
    case 'baseline normalization'
        controlParams.Width = 160;
        location = siman.UIHelper.MakeLabeledPopup('BaselineNormMethod', 'Normalization method:', ...
            location, controlParams);
                
    case 'threshold'
        controlParams.Width = 150;
        location = siman.UIHelper.MakeLabeledPopup('ThresholdType', 'Threshold type:', ...
            location, controlParams);
        
        switch obj.ThresholdType
            case 'fixed value'
                label = 'Fixed value:';
            case 'baseline st dev'
                label = 'St. dev. cutoff:';
            case 'baseline percent'
                label = 'Baseline percent:';
        end
        controlParams.Width = 60;
        location = siman.UIHelper.MakeLabeledTextbox('ThresholdValue', label, ...
            location, controlParams);
        
    case 'morph'
        controlParams.Width = 160;
        location = siman.UIHelper.MakeLabeledPopup('MorphType', 'Morph operation:', ...
            location, controlParams);
        
        location(2) = location(2) - 10;
        switch obj.MorphType
            case {'dilate', 'erode', 'open', 'close'}
                obj.MorphKernel.MakeControls(location, controlParams);
            case {'dilate with threshold', 'erode with threshold'}
                location = obj.MorphKernel.MakeControls(location, controlParams);
                
                controlParams.Width = 90;
                location = siman.UIHelper.MakeLabeledPopup('MorphThresholdType', 'Threshold type:', ...
                    location, controlParams);
                
                switch obj.MorphThresholdType
                    case 'absolute'
                        controlParams.Width = 40;
                        location = siman.UIHelper.MakeLabeledTextbox('MorphThreshold', '   Threshold:', ...
                            location, controlParams);
                        
                    case 'percent'
                        controlParams.Width = 40;
                        sideLocation = location;
                        location = siman.UIHelper.MakeLabeledTextbox('MorphThresholdPercent', '   Threshold (%):', ...
                            location, controlParams);
                        
                        sideLocation(1) = sideLocation(1) + 150;
                        controlParams.Width = 40;
                        siman.UIHelper.MakeLabeledIndicator('MorphThresholdActual', 'Actual threshold:', ...
                            sideLocation, controlParams);
                end
        end
        
    case 'swap dimensions'
        controlParams.Width = 70;
        location = siman.UIHelper.MakeLabeledPopup('SwapDimensions', 'Dimensions to swap:', ...
            location, controlParams);
        
    case 'collapse dimension'
        controlParams.Width = 70;
        location = siman.UIHelper.MakeLabeledPopup('CollapseDimension', 'Dimension to collapse:', ...
            location, controlParams);
                
    case 'convert to ca'
        controlParams.Width = 160;
        location = siman.UIHelper.MakeLabeledPopup('ConvertCaMethod', 'Conversion method:', ...
            location, controlParams);
        
        location(2) = location(2) - 10;
        switch obj.ConvertCaMethod
            case {'resting'}
                controlParams.Width = 50;
                sideLocation = location;
                location = siman.UIHelper.MakeLabeledTextbox('ConvertCaKd', '   Kd:', ...
                    location, controlParams);

                controlParams.Width = 50;
                siman.UIHelper.MakeLabeledTextbox('ConvertCaRestingConc', '   Resting Concentration:', ...
                    location, controlParams);
                
            case {'fmin-fmax'}
                controlParams.Width = 50;
                location = siman.UIHelper.MakeLabeledTextbox('ConvertCaKd', '   Kd:', ...
                    location, controlParams);

                sideLocation = location;
                controlParams.Width = 50;
                siman.UIHelper.MakeLabeledTextbox('ConvertCaFMax', '   f max:', ...
                    location, controlParams);
                
                sideLocation(1) = sideLocation(1) + 150;
                controlParams.Width = 50;
                siman.UIHelper.MakeLabeledTextbox('ConvertCaRf', '   Rf:', ...
                    sideLocation, controlParams);
                
        end
    case 'restore original'
        % No controls
end
