function [valid, message] = Validate(obj, def)

import siman.*;
valid = true;
message = '';

type = obj.Type;
switch lower(type)
    case 'subtract background'
        valid = isnumeric(obj.BackgroundValue) && ~isnan(obj.BackgroundValue);
        if ~valid
            message = 'Value must be numeric.';
            return;
        end
    case 'median filter'
        valid = ismember(obj.MedianFilterType, obj.MedianFilterTypeOptions);
        if ~valid
            message = ['Invalid median filter format: ' obj.MedianFilterType];
            return;
        end
        switch obj.MedianFilterType
            case 'equal sides'
                valid = ~iseven(obj.MedianFilterWidth);
                if ~valid
                    message = 'Filter width must be odd.';
                    return;
                end
            case 'independent sides'
                valid = ~iseven(obj.MedianFilterXWidth);
                if ~valid
                    message = 'Filter width must be odd.';
                    return;
                end
                valid = ~iseven(obj.MedianFilterYWidth);
                if ~valid
                    message = 'Filter width must be odd.';
                    return;
                end
            case 'custom'
        end
    case 'calculate baseline'
        valid = ismember(obj.BaselineFormat, obj.BaselineFormatOptions);
        if ~valid
            message = ['Invalid baseline format: ' obj.BaselineFormat];
            return;
        end
        switch obj.BaselineFormat
            case 'linescan line'
                valid = ismember(obj.BaselineCalcMethod, obj.BaselineCalcMethodOptions);
                if ~valid
                    message = ['Invalid baseline calculation method: ' obj.BaselineCalcMethod];
                    return;
                end
                valid = ~iseven(obj.BaselineLinescanMedianFilterWidth) || obj.BaselineLinescanMedianFilterWidth == 0;
                if ~valid
                    message = 'Filter width must be odd.';
                    return;
                end
                switch obj.BaselineCalcMethod
                    case 'minimum region'
                       %%%
                    case 'manual region'
                        %%%
                end
            case '2-d'
            case 'constant'
        end
    case 'baseline normalization'
        valid = ismember(obj.BaselineNormMethod, obj.BaselineNormMethodOptions);
        if ~valid
            message = ['Invalid baseline normalization method: ' obj.BaselineNormMethod];
            return;
        end
        valid = ~isempty(def.BaselineOperation);
        if ~valid
            message = 'Operation requires previous calculation of baseline.';
            return;
        end
        
    case 'threshold'
        valid = ismember(obj.ThresholdType, obj.ThresholdTypeOptions);
        if ~valid
            message = ['Invalid thresholding type: ' obj.ThresholdType];
            return;
        end
        if ~strcmp(obj.ThresholdType, 'fixed value')
            valid = ~isempty(def.BaselineOperation);
            if ~valid
                message = 'Operation requires previous calculation of baseline.';
                return;
            end
        end
        
    case 'morph'
        valid = ismember(obj.MorphType, obj.MorphTypeOptions);
        if ~valid
            message = ['Invalid morphing operation: ' obj.MorphType];
            return;
        end
        [valid, message] = obj.MorphKernel.Validate();
        if ~valid
            return
        end
        switch obj.MorphType
            case 'dilate'
            case 'erode'
        end
        
    case 'swap dimensions'
        valid = ismember(obj.SwapDimensions, obj.SwapDimensionsOptions);
        if ~valid
            message = ['Unknown swap dimensions: ' obj.SwapDimensions];
            return;
        end
        
    case 'collapse dimension'
        valid = ismember(obj.CollapseDimension, obj.CollapseDimensionOptions);
        if ~valid
            message = ['Unknown dimension to collapse: ' obj.CollapseDimension];
            return;
        end
        
    case 'convert to ca'
        valid = true;
        
    case 'restore original'
        valid = true;
        
    otherwise
        siman.Debug.ReportProblem(['Unknown operation to validate: ' type]);

end

    function result = iseven(arg)
        result = arg/2 == round(arg/2);
    end
end