function CalculateExtraProperties(obj, method)
    rawTrace = obj.Waveform;
    waveformStartOffset = obj.WaveformStartOffset;
    peakIndex = obj.PeakIndex;
    tracePeakIndex = -waveformStartOffset + 1;
    traceBeginIndex = peakIndex + waveformStartOffset;

    % Correct for missing values at front or end
    hasNaN = ~isempty(find(isnan(rawTrace), 1));
    if hasNaN
        missingPresamples = find(isnan(rawTrace(1:tracePeakIndex)));
        if ~isempty(missingPresamples)
            traceBeginIndex = tracePeakIndex + missingPresamples(end);
            tracePeakIndex = tracePeakIndex - missingPresamples(end);
        end
        rawTrace = rawTrace(~isnan(rawTrace));
    end

    medFiltWidth = 3;
    medFiltTrace = medfilt1(rawTrace, medFiltWidth);
    
    [b, a] = butter(5, .1, 'low');
    filtFiltTrace = filtfilt(b, a, rawTrace);
    %filtFiltTrace = detrend(filtFiltTrace, 'constant');
    %filtFiltTrace = filtFiltTrace/max(filtFiltTrace);
    deriv = deriv_5point_b(filtFiltTrace, 1, 1);

    [~, maxIndex] = max(deriv(1:tracePeakIndex)); % Find peak derivative in pre-peak region
    maxVal = medFiltTrace(tracePeakIndex);
    minVal = min(medFiltTrace(1:maxIndex));
    threshold = minVal + .1 * (maxVal-minVal); % Guess an approximate onset threshold
    tempOnset = find(medFiltTrace(1:tracePeakIndex) < threshold, 1, 'last') + 1;

    standardBaselineWidth = 30;
    onsetThresholdSD = 3;
    baselineRange = [max(3,tempOnset-standardBaselineWidth-2), tempOnset-3]; % Get baseline range (based on onset guess)
      % (Baseline is sihfted a couple of pixels before onset guess to avoid catching the upslope)
    actualBaselineWidth = baselineRange(2) - baselineRange(2) + 1;
    baselineVals = medFiltTrace(baselineRange(1):baselineRange(2));
    baseline = mean(baselineVals);
    baselineSD = std(baselineVals);
    threshold = baseline + onsetThresholdSD*baselineSD; % Now get official onset based on baseline standard deviation
    onsetIndex = find(medFiltTrace(1:tracePeakIndex) < threshold, 1, 'last') + 1;

    baselineForDecay = mean(filtFiltTrace(baselineRange(1):baselineRange(2)));
    threshold = baselineForDecay + .5 * (filtFiltTrace(tracePeakIndex)-baselineForDecay);
    indexTo50 = find(filtFiltTrace(tracePeakIndex:end) <= threshold, 1, 'first') + tracePeakIndex - 1;
    
    threshold = baselineForDecay + .1 * (filtFiltTrace(tracePeakIndex)-baselineForDecay);
    indexTo90 = find(filtFiltTrace(tracePeakIndex:end) <= threshold, 1, 'first') + tracePeakIndex - 1;
    
    timeConversion = method.UnitConversion_Time;
    obj.Baseline = baseline;
    obj.BaselineRangeWidth = actualBaselineWidth;
    obj.OnsetIndex = onsetIndex + traceBeginIndex - 1;
    obj.TimeToPeak = (tracePeakIndex - onsetIndex) * timeConversion;
    obj.Index_DecayTo50 = indexTo50 + traceBeginIndex - 1;
    obj.TimeTo50Decay = (indexTo50 - tracePeakIndex) * timeConversion;
    obj.Index_DecayTo90 = indexTo90 + traceBeginIndex - 1;
    obj.TimeTo90Decay = (indexTo90 - tracePeakIndex) * timeConversion;
end







