classdef SparkDetectionPanel < siman.FeatureDefPanel
    % SparkDetectionPanel    
    
    methods
        % Constructor
        function obj = SparkDetectionPanel(parent)
            obj@siman.FeatureDefPanel(parent);
        end
    end
    
    methods
        
        function InitDefaults(obj)
            obj.Name = 'Spark Detection';
            obj.Size = [260 340];
            obj.DockedLocation = 'east';
            InitDefaults@siman.FeatureDefPanel(obj);
        end
        
        function mgr = GetManager(obj)
            mgr = siman.SparkManager.GetManager();
        end
        
        function UpdateControl(obj, id) % Handle manual refreshing
            tag = get(id, 'Tag');
            switch tag
                case 'UnitsDefinitionName'
                    obj.RefreshDefinitionList(id);
                    enabling = true;
                case 'UnitsDefinitionNameLabel'
                    enabling = true;
                otherwise
                    enabling = 'off';
                    siman.Debug.ReportProblem(['Unknown control to manual UpdateControl: ' tag]);
            end
            if ~ischar(enabling)
                if enabling
                    enabling = 'on';
                else
                    enabling = 'off';
                end
            end
            set(id, 'Enable', enabling);
        end
        
        function RefreshDefinitionList(obj, id)
            mgr = siman.ImageManager.GetManager();
            setNames = mgr.GetDefinitionNameOptions();
            set(id, 'String', setNames);
            siman.UIHelper.UpdateGenericControlValue(id, obj.FeatureDetectionMethod, 'UnitsDefinitionName');
        end
                
    end
end


