classdef SparkGraphPanel < siman.FeatureGraphPanel
    % SparkGraphPanel
    
    properties (Transient)
        ThumbnailAxesID
    end
    
    methods
        % Constructor
        function obj = SparkGraphPanel(parent)
            obj@siman.FeatureGraphPanel(parent, 'spark');
        end
        
        function mgr = GetManager(obj)
            mgr = siman.SparkManager.Instance;
        end
        
        function InitDefaults(obj)
            obj.Name = 'Spark Graph';
            obj.Size = [260 280];
            obj.DockedLocation = 'south';
            obj.Stretchable = true;
            InitDefaults@siman.FeatureGraphPanel(obj);
        end
        
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
    end
end


