function UpdateGraph(obj)

axesID = obj.GraphAxesID;
thumbnailAxesID = obj.ThumbnailAxesID;
list = obj.GetFeatureList();
count = list.Count;
cla(axesID);
cla(thumbnailAxesID);
if count == 0
    return;
end
manager = obj.GetManager();
method = manager.FeatureDetectionMethod;
thumbnail = [];
viewAll = obj.ViewAll;
drawnCount = 0;
for i = 1:count
    feature = list.ElementAt(i);
    isSelected = feature.IsSelected;
    timeConversion = method.UnitConversion_Time;
    waveform = feature.Waveform;
    if ~isempty(waveform) && (viewAll || isSelected)
        drawnCount = drawnCount + 1;
        if isSelected && viewAll
            lineWidth = 3;
            color = [1 0 0];
        else
            lineWidth = 1;
            color = [0 0 0];
        end
        if isSelected || ~viewAll
            thumbnail = feature.Thumbnail;
        end
            
        xData = [feature.WaveformStartOffset:feature.WaveformStopOffset] .* method.UnitConversion_Time;
        h = line('Parent', axesID, 'XData', xData, 'YData', waveform, 'Color', color, 'LineWidth', lineWidth);
        
        maxVal = waveform(-feature.WaveformStartOffset + 1);
        baseline = feature.Baseline;
        
        onset = feature.OnsetIndex;
        if ~isempty(onset) && ~isnan(onset)
            onset = (onset - feature.PeakIndex) * timeConversion;
            onsetTickXData = [onset onset];
            onsetTickYData = [baseline baseline - .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', onsetTickXData, 'YData', onsetTickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
        
        indexOf50 = feature.Index_DecayTo50;
        if ~isempty(indexOf50) && ~isnan(indexOf50)
            crossingVal = waveform(indexOf50 - feature.PeakIndex -feature.WaveformStartOffset + 1);
            indexOf50 = (indexOf50 - feature.PeakIndex) * timeConversion;
            tickXData = [indexOf50 indexOf50];
            tickYData = [crossingVal - .1 * (maxVal - baseline) crossingVal + .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', tickXData, 'YData', tickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
        
        indexOf90 = feature.Index_DecayTo90;
        if ~isempty(indexOf90) && ~isnan(indexOf90)
            crossingVal = waveform(indexOf90 - feature.PeakIndex -feature.WaveformStartOffset + 1);
            indexOf90 = (indexOf90 - feature.PeakIndex) * timeConversion;
            tickXData = [indexOf90 indexOf90];
            tickYData = [crossingVal - .1 * (maxVal - baseline) crossingVal + .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', tickXData, 'YData', tickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
    end
end
if drawnCount > 0
    set(axesID, 'XLim', [xData(1) xData(end)]);
end

if isempty(thumbnail)
    return;
end

imagesc('CData', thumbnail, 'Parent', thumbnailAxesID);
set(thumbnailAxesID, 'DataAspectRatio', [1 1 1]);