function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = 8;
parentPos = get(parentPanel, 'Position');
top = parentPos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.CurrentFeatureSource;
manager = obj.GetManager();

children = get(parentPanel, 'Children');
delete(children);

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = source;

location = [margin top];

if isempty(source)
    siman.UIHelper.MakeLabel(['No ' obj.FeatureType ' source'], ...
                    location, controlParams);
    return
end

% Add main controls that won't change

controlParams.Height = parentPos(4)-siman.UIHelper.TEXT_HEIGHT-siman.UIHelper.VERTICAL_SPACING-...
    2*margin-siman.UIHelper.TOOLBAR_BUTTON_HEIGHT-20;
controlParams.Width = parentPos(3)-2*margin;
controlParams.Callback = @obj.ControlChanged;
controlParams.RefreshCallback = @obj.UpdateControl;
controlParams.MultiSelect = true;
controlParams.ListOptions = ' ';  % Will be refreshed later
controlParams.Value = 1;
controlParams.Tag = 'FeatureList';
controlParams.Property = 'FeatureList';
[location, h] = siman.UIHelper.MakeLabeledListbox('FeatureList', 'Sparks:', ...
    location, controlParams);

pos = get(h, 'Position');
location = pos([1 2]);
controlParams.Callback = []; % clear setting for next controls
controlParams.RefreshCallback = [];

prefix = manager.CommandPrefix;
controlParams.CommandName = [prefix 'DeleteSelectedFeatures'];
controlParams.Context = obj;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

location(1) = location(1) + siman.UIHelper.TOOLBAR_BUTTON_SPACER;
controlParams.CommandName = [prefix 'CopyAllFeatures'];
controlParams.Context = obj;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

controlParams.CommandName = [prefix 'ExportAllFeatures'];
controlParams.Context = obj;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);

%controlParams.CommandName = [prefix 'DeleteFeatures'];
%controlParams.Context = obj;
%location = siman.UIHelper.MakeToolbarButton(location, controlParams);

%TODO
%ctxMenu = uicontextmenu('Tag', 'ContextMenu');
%set(listControl, 'UIContextMenu', ctxMenu);
%uimenu(ctxMenu, 'Label', 'Copy Selected', 'Tag', 'CopySelected', ...
%    'Callback', buttonCallback);
%uimenu(ctxMenu, 'Label', 'Copy All', 'Tag', 'CopyAllFeatures', ...
%    'Callback', buttonCallback);
