function CreateXML(obj, context, feature_node)

CreateXML@siman.Feature(obj, context, feature_node);
feature_node.setAttribute('value', num2str(obj.PeakAmplitude)); % Give primary number to use for sorting

resourcesFullpath = context.ResourcesFullPath;
systemMgr = siman.ImageManager.GetManager();
currentPlot = systemMgr.CurrentPlot;
grabber = context.ImageGrabber;
if ~isempty(currentPlot)
    hFig = context.FigureBuffer;
    colormap(hFig, currentPlot.Colormap);
end


% Create location image
name = [obj.Name '_location.tif'];
data = context.ImageData;
grabber.OutputSize = [150 150];
grabber.ColorLim = context.ImageColorRange;
if ~isempty(data)
    im = data(:,:,obj.PeakZIndex);
    filename = fullfile(resourcesFullpath, name);
    grabber.OnImageDrawnFcn = @(ax)DrawOnThumbnail(obj, ax);
    grabber.GrabAndSavePlotImage(im, filename);
end
context.FeatureManager.CreateRefReportNode(feature_node, 'location', name);

name = [obj.Name '_thumbnail.tif'];
im = obj.Thumbnail;
if ~isempty(im)
    filename = fullfile(resourcesFullpath, name);
    grabber.OnImageDrawnFcn = [];
    grabber.GrabAndSavePlotImage(im, filename);
end
context.FeatureManager.CreateRefReportNode(feature_node, 'thumbnail', name);

% Create thumbnail image
name = [obj.Name '_graph.tif'];
[xData, yData] = obj.GetGraphData();
if ~isempty(yData)
    filename = fullfile(resourcesFullpath, name);
    grabber.OutputSize = [450 150];
    grabber.GrabAndSavePlotGraph(xData, yData, filename);
end
context.FeatureManager.CreateRefReportNode(feature_node, 'graph', name);

