classdef Sparklet < siman.Feature
    % Must be a subclass of handle
    properties
        PeakAmplitude;
        PeakIndex;
        PeakXIndex;
        PeakYIndex;
        PeakZIndex;
        WaveformStartIndex;
        WaveformStopIndex;
        Area;
        FrameCount;
        
        SparkletSite;
        
        LowerXBound;
        UpperXBound;
        LowerYBound;
        UpperYBound;
        LowerZBound;
        UpperZBound;
        WaveformStartOffset;
        WaveformStopOffset;
        Waveform;
        Thumbnail;
        RegionIndexes;
        RegionXIndexes;
        RegionYIndexes;
        RegionZIndexes;
        
        Outlines;
        
        Baseline;
        BaselineRangeWidth;
    end
    
    methods
        % Constructor
        function obj = Sparklet()
            obj.Type = 'sparklet';
        end
        
        function h = Draw(obj, ax, plot)
            h = [];
            z = plot.FrameIndex;
            index = find(z == obj.LowerZBound:obj.UpperZBound);
            for i = 1:length(obj.Outlines)
                if (i == index)
                    outline = obj.Outlines{i};
                    y = outline(:,1);
                    x = outline(:,2);
                    [x, y] = plot.ConvertPointsToPlot(x, y);
                    if obj.IsSelected
                        lineWidth = 2;
                        color = [1 .7 1];
                    else
                        lineWidth = 1;
                        color = [1 .4 1];
                    end
                    z = ones(numel(x),1) * 2;
                    h = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
                    break;
                end
            end
        end
        
        function h = DrawOnThumbnail(obj, ax)
            outline = obj.Outlines{obj.PeakZIndex- obj.LowerZBound + 1};
            y = outline(:,1);
            x = outline(:,2);
            z = ones(numel(x),1) * 2;
            lineWidth = 2;
            color = [.5 1 1];
            h = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
        end
        
        function [x, y] = GetGraphData(obj)
            y = obj.Waveform;
            x = obj.WaveformStartOffset:obj.WaveformStopOffset;
        end
        
        function str = GetListString(obj)
            str = [obj.Name ' (' num2str(obj.PeakAmplitude) ', z = '  num2str(obj.PeakZIndex)];
            if (obj.LowerZBound ~= obj.UpperZBound)
                str = [str ': '  num2str(obj.LowerZBound) ' to '  num2str(obj.UpperZBound)];
            end
            str = [str ')'];
                    
        end
        
        function list = GetExportPropList(obj)
            list = {'PeakAmplitude', 'PeakXIndex', 'PeakYIndex', 'PeakZIndex', 'Area', 'FrameCount'};
        end
        
        function data = GetExportData(obj)
            data = obj.Waveform;
        end
        
        function hit = HitTest(obj, area, ~) % obj, area, plot
            z = area(1, 3);
            frameRegion = (z == obj.RegionZIndexes);
            x = obj.RegionXIndexes(frameRegion);
            y = obj.RegionYIndexes(frameRegion);
            point1 = floor(area(1, [1 2]));
            point2 = ceil(area(2, [1 2]));
            hit = any(point1(2) <= y & point2(2) >= y & point1(1) <= x & point2(1) >= x);
        end
        
        function tf = IsInView(obj, area)
            z = area(1, 3);
            if z < obj.LowerZBound || z > obj.UpperZBound
                tf = false;
                return
            end
            tf = true; % skipping x-y dimension for now
        end
        
        function point = CenteredPoint(obj)
            point = [obj.PeakXIndex, obj.PeakYIndex, obj.PeakZIndex];
        end
    end
end







