function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = siman.UIHelper.PANEL_MARGIN;
parentPos = get(parentPanel, 'Position');
top = parentPos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.FeatureDetectionMethod;
manager = obj.GetManager();

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = source;
controlParams.Controller = source;

children = get(parentPanel, 'Children');
delete(children);

location = [margin top];

% Show notice of no definition
if isempty(source)
    siman.UIHelper.MakeLabel(['No ' obj.FeatureType ' definition'], ...
                    location, controlParams);
    return
end

% Add main controls that won't change

controlParams.Width = 120;
location = siman.UIHelper.MakeLabeledPopup('DetectionMethod', 'Method:', ...
    location, controlParams);

location(2) = location(2) - 10;
controlParams.Width = 120;
controlParams.RefreshCallback = @obj.UpdateControl;
controlParams.Controller = obj;
controlParams.ListOptions = {'none'}; % refresh will fill this in
location = siman.UIHelper.MakeLabeledPopup('UnitsDefinitionName', 'Units image:', ...
    location, controlParams);

controlParams.Controller = source;
controlParams.RefreshCallback = [];
controlParams.ListOptions = [];
location(2) = location(2) - 10;

switch source.DetectionMethod
    case 'detection image'
end

controlParams.Width = 40;
[nextLevelLocation, h] = siman.UIHelper.MakeLabeledTextbox('MinSize', 'Size limits:  Min', ...
    location, controlParams);

pos = get(h, 'Position');
controlParams.Width = 40;
location(1) = pos(1) + pos(3) + 10;
siman.UIHelper.MakeLabeledTextbox('MaxSize', 'Max', ...
    location, controlParams);

controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledTextbox('MaxCount', 'Max sparklet count:', ...
    nextLevelLocation, controlParams);

controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledPopup('ConnectivityType', 'Connectivity type:', ...
    location, controlParams);

location(2) = location(2) - 10;
controlParams.Width = 30;
[nextLevelLocation, h] = siman.UIHelper.MakeLabeledTextbox('ThumbnailStartOffset', 'Window around peak: ', ...
    location, controlParams);

pos = get(h, 'Position');
controlParams.Width = 30;
location(1) = pos(1) + pos(3);
siman.UIHelper.MakeLabeledTextbox('ThumbnailStopOffset', ' to ', ...
    location, controlParams);

controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledTextbox('ThumbnailWidth', '   Window width:', ...
    nextLevelLocation, controlParams);

controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledTextbox('TraceWidth', '   Trace radius:', ...
    location, controlParams);

location(2) = location(2) - 10;
controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledTextbox('UnitConversion_Space', 'Spatial conversion factor:', ...
    location, controlParams);

controlParams.Width = 60;
location = siman.UIHelper.MakeLabeledTextbox('UnitConversion_Time', 'Time conversion factor:', ...
    location, controlParams);
        
prefix = manager.CommandPrefix;
controlParams.CommandName = [prefix 'Detect'];
controlParams.LocationType = 'lower right';
controlParams.ButtonWidth = 50;
controlParams.Context = obj;
location = [parentPos(3)-margin margin];
location = siman.UIHelper.MakeButton(location, 'Detect', controlParams);

controlParams.CommandName = [prefix 'GenerateReport'];
controlParams.LocationType = 'lower right';
controlParams.ButtonWidth = 65;
controlParams.Context = obj;
location = [location(1)-margin-50 margin];
location = siman.UIHelper.MakeButton(location, 'Report...', controlParams);

