classdef SparkletGraphPanel < siman.FeatureGraphPanel
    % SparkletGraphPanel
    
    properties (Transient)
        ThumbnailAxesID
    end
    
    methods
        % Constructor
        function obj = SparkletGraphPanel(parent)
            obj@siman.FeatureGraphPanel(parent, 'sparklet');
        end
        
        function mgr = GetManager(obj)
            mgr = siman.SparkletManager.Instance;
        end
        
        function InitDefaults(obj)
            obj.Name = 'Sparklet Graph';
            obj.Size = [260 280];
            obj.DockedLocation = 'south';
            obj.Stretchable = true;
            InitDefaults@siman.FeatureGraphPanel(obj);
        end
        
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
    end
end


