function CreateXMLCustomParts(obj, context)

docNode = context.DocNode;
method = context.Method;
source = context.Source;
resourcesDir = context.ResourcesDir;
resourcesFullpath = context.ResourcesFullPath;
list = docNode.getElementsByTagName('resources');
resourcesNode = list.item(0);
hFig = context.FigureBuffer;
grabber = context.ImageGrabber;
mgr = siman.ImageManager.GetManager();
currentPlot = mgr.CurrentPlot;
if ~isempty(currentPlot)
    colormap(hFig, currentPlot.Colormap);
end


% Create thumbnail image
name = 'main_thumbnail.tif';
filename = fullfile(resourcesFullpath, name);
data = source.GetData();
if ~isempty(data)
    dim = size3d(data);
    middleFrame = ceil(dim(3)/2); % take middle frame in case first frame is bad
    im = data(:,:,middleFrame);
    grabber.OutputSize = [200 200];
    grabber.OnImageDrawnFcn = [];
    grabber.ColorLim = [];
    grabber.GrabAndSavePlotImage(im, filename);
end
context.FeatureManager.CreateRefReportNode(resourcesNode, 'mainthumbnail', name);

% Get unit data for use by individual features to draw images
unitsDef = method.GetUnitsDefinition();
data = unitsDef.ProcessSource(source);
context.ImageData = data;
% If current plot is showing the units image, use the plot color range.  Else use the min/max.
if isempty(currentPlot) || ~strcmp(currentPlot.CurrentProcessingDefName, unitsDef.Name)
    [minVal, maxVal] = minmax(data);
else
    minVal = currentPlot.ColorLimActual_Lower;
    maxVal = currentPlot.ColorLimActual_Upper;
end
context.ImageColorRange = [minVal, maxVal];


% Add a node for the summary
root = docNode.getDocumentElement();
summaryNode = docNode.createElement('summary');
summaryNode.setAttribute('id', 'summary');
root.appendChild(summaryNode);

% Create summary image
name = 'summary_image';
filename = [name '.tif'];
data = context.ImageData;
if ~isempty(data)
    middleFrame = ceil(dim(3)/2); % take middle frame in case first frame is bad
    im = data(:,:,middleFrame);
    fullFilename = fullfile(resourcesFullpath, filename);
    grabber.OutputSize = [500 500];
    grabber.ColorLim = context.ImageColorRange;
    grabber.OnImageDrawnFcn = @(ax)DrawReportSummaryAccessories(obj, ax);
    grabber.GrabAndSavePlotImage(im, fullFilename);
end
context.FeatureManager.CreateRefReportNode(summaryNode, name, filename);
