classdef SparkletManager < siman.FeatureManager
    % SparkletManager.
    properties (Constant)
        Instance = siman.SparkletManager; % Singleton object
        
        CommandPrefix = 'Sparklet.';
        FeatureType = 'sparklet';
    end
    
    methods (Access = private)
        % Constructor
        function obj = SparkletManager()
            obj@siman.FeatureManager();
            
            % For development case where file was edited and the instance was deleted
            mgr = siman.ImageManager.GetManager();
            if isempty(mgr)
                return
            end
            
            obj.SourceArchivingProperty = 'LastSparkletDetectionMethod';
            if isempty(obj.FeatureDetectionMethod)
                obj.FeatureDetectionMethod = siman.SparkletsMethod;
            end
        end
        
    end
    
    methods (Static = true)
        function mgr = GetManager()
            mgr = siman.SparkletManager.Instance;
        end
    end
end





