function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = 8;
parentPos = get(parentPanel, 'Position');
top = parentPos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.CurrentFeatureSource;
manager = obj.GetManager();

children = get(parentPanel, 'Children');
delete(children);

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = obj;
controlParams.Controller = obj;

location = [margin top];

if isempty(source)
    siman.UIHelper.MakeLabel(['No ' obj.FeatureType ' source'], ...
                    location, controlParams);
    return
end

% Add main controls that won't change

thumbnailWidth = 200;

bottomOffset = margin + siman.UIHelper.TOOLBAR_BUTTON_HEIGHT + 5;
width = parentPos(3)-3*margin-thumbnailWidth;
height = parentPos(4)-siman.UIHelper.TEXT_HEIGHT-siman.UIHelper.VERTICAL_SPACING-margin-bottomOffset;
graphPos = [margin bottomOffset width height]; 
obj.GraphAxesID = axes('Parent', parentPanel, 'Units', 'pixels', ...
    'Tag', 'FeatureGraph', 'OuterPosition', graphPos);
graphPos = get(obj.GraphAxesID, 'Position'); % get inner position

thumbnailPos = [parentPos(3)-margin-thumbnailWidth bottomOffset thumbnailWidth height]; 
obj.ThumbnailAxesID = axes('Parent', parentPanel, 'Units', 'pixels', ...
    'Tag', 'ThumbnailGraph', 'Position', thumbnailPos, 'Visible', 'off', 'Color', 'none', ...
    'YDir', 'reverse');
thumbnailPos = get(obj.ThumbnailAxesID, 'Position'); % get inner position

% location = [graphPos(1) graphPos(2)+graphPos(4)+siman.UIHelper.VERTICAL_SPACING];
% controlParams.Width = 60;
% controlParams.Orientation = 'horizontal';
% controlParams.LocationType = 'lower right';
% location = siman.UIHelper.MakeRadioButtonList('TraceType', {'Windowed cutouts', 'Full profile'}, ...
%     location, controlParams);

location = [graphPos(1) graphPos(2)+graphPos(4)+siman.UIHelper.VERTICAL_SPACING];
controlParams.LocationType = 'lower left';
controlParams.Width = 80;
[~, h] = siman.UIHelper.MakeCheckbox('ViewAll', 'Show all', ...
    location, controlParams);
pos = get(h, 'Position');

location = [graphPos(1)+graphPos(3) graphPos(2)+graphPos(4)];
controlParams.Callback = []; % clear setting for next controls
controlParams.RefreshCallback = [];
controlParams.LocationType = 'lower right';

prefix = manager.CommandPrefix;
controlParams.CommandName = [prefix 'CopyAllFeatureData'];
controlParams.Context = obj;
location = siman.UIHelper.MakeToolbarButton(location, controlParams);


% ctxMenu = uicontextmenu('Tag', 'ContextMenu');
% set(obj.GraphAxesID, 'UIContextMenu', ctxMenu);
% uimenu(ctxMenu, 'Label', 'Copy Selected', 'Tag', 'CopySelected', ...
%     'Callback', buttonCallback);
% uimenu(ctxMenu, 'Label', 'Copy All', 'Tag', 'CopyAllFeatureTraces', ...
%     'Callback', buttonCallback);
