function UpdateGraph(obj)

axesID = obj.GraphAxesID;
thumbnailAxesID = obj.ThumbnailAxesID;
list = obj.GetFeatureList();
count = list.Count;
cla(axesID);
cla(thumbnailAxesID);
if count == 0
    return;
end
manager = obj.GetManager();
method = manager.FeatureDetectionMethod;
thumbnail = [];
viewAll = obj.ViewAll;
drawnCount = 0;
xMin = 0;
xMax = 1;
timeConversion = method.UnitConversion_Time;
for i = 1:count
    feature = list.ElementAt(i);
    isSelected = feature.IsSelected;
    if (viewAll || isSelected)
        [xData, yData] = feature.GetGraphData();
        if ~isempty(xData)
            xData = xData * timeConversion;
            xMax = max(xMax, max(xData));
            xMin = min(xMin, min(xData));
            drawnCount = drawnCount + 1;
            if isSelected && viewAll
                lineWidth = 3;
                color = [1 0 0];
            else
                lineWidth = 1;
                color = [0 0 0];
            end
            if isSelected || ~viewAll
                thumbnail = feature.Thumbnail;
            end

            line('Parent', axesID, 'XData', xData, 'YData', yData, 'Color', color, 'LineWidth', lineWidth);

            if ~viewAll
                frames = feature.GetSparkletFrames();
                xData2 = (frames) * timeConversion;
                yData2 = ones(length(xData2), 1) * max(yData) * 1.1;
                line('Parent', axesID, 'XData', xData2, 'YData', yData2, ...
                    'LineStyle', 'none', 'Marker', 'o');
            end
        end
    end
end
if drawnCount > 0
    set(axesID, 'XLim', [xMin xMax]);
end

if isempty(thumbnail)
    return;
end

imagesc('CData', thumbnail, 'Parent', thumbnailAxesID);
set(thumbnailAxesID, 'DataAspectRatio', [1 1 1]);