classdef (ConstructOnLoad) SparkletSitesMethod < siman.FeatureDetectionMethod
    % SparksMethod.
    properties
        AreaKernel
    end
    properties (Transient)
        AreaKernelListener
    end
    properties (GetObservable, SetObservable) % Registered properties
        ThumbnailWidth = 50;
        ClusterTolerance = 3;
    end
    
    methods % Properties
        function set.AreaKernel(obj, value)
            if isempty(value) % internal code for nulling the property during a copy
                obj.AreaKernel = [];
                obj.AreaKernelListener = [];
                return
            end
            if ~isempty(obj.AreaKernel)
                delete(obj.AreaKernel);
                if ~isempty(obj.AreaKernelListener)
                    delete(obj.AreaKernelListener)
                end
            end
            obj.AreaKernel = value;
            if ~isempty(value)
                obj.AreaKernelListener = addlistener(obj.AreaKernel, 'PropertyChanged', @obj.OnAreaKernelChanged);
                obj.AreaKernelListener(2) = addlistener(obj.AreaKernel, 'LayoutChanged', @obj.OnAreaKernelLayoutChanged);
            end
        end
    end
    
    methods
        % Constructor
        function obj = SparkletSitesMethod()
            obj@siman.FeatureDetectionMethod();
            
            if isempty(obj.AreaKernel)
                obj.AreaKernel = siman.FilterKernel;
            end
        end
        
        function InitMethod(obj)
            obj.FeatureType = 'sparklet site';
            obj.UnitsDefName = 'sparklet site units';
            obj.DetectionMethodOptions = {'mean position'};
        end
        
        
        function OnPropertyChanged(obj, ~, evnt) % obj, src, evnt
            switch evnt.PropertyName
                otherwise
                    notify(obj, 'MethodChange');
            end
            % Indicate need for layout change
            switch evnt.PropertyName
                case 'DetectionMethod'
                    notify(obj, 'MethodLayoutChange');
            end
        end
        
        function OnAreaKernelChanged(obj, ~, ~) % src, evnt
            notify(obj, 'MethodChange');
        end
        
        function OnAreaKernelLayoutChanged(obj, ~, ~) % src, evnt
            notify(obj, 'MethodLayoutChange');
        end
        
        function def = GetDefaultUnitsDefinition(obj)
            def = GetDefaultUnitsDefinition@siman.FeatureDetectionMethod(obj);
            op = def.AddOperation('subtract background');
            op = def.AddOperation('median filter');
            op = def.AddOperation('calculate baseline');
            op.BaselineFormat = '2-d';
            op = def.AddOperation('baseline normalization');
            op.BaselineFormat = '2-d';
        end
        
        function delete(obj)
            if ~isempty(obj.AreaKernel)
                delete(obj.AreaKernel);
                delete(obj.AreaKernelListener);
                obj.AreaKernel = [];
            end
        end
        
    end
    
    methods(Access = protected)
        % Override copyElement method:
        function cpObj = copyElement(obj)
            % Make a shallow copy of all properties
            cpObj = copyElement@siman.SimanObject(obj);
            cpObj.InitListeners();
            % Make a deep copy of the definitions
            if ~isempty(obj.UnitsDefinition)
                cpObj.UnitsDefinition = [];
                cpObj.UnitsDefinition = copy(obj.UnitsDefinition);
            end
            cpObj.AreaKernel = [];
            cpObj.AreaKernel = copy(obj.AreaKernel);
        end
    end
end





