classdef (ConstructOnLoad) SparkletsMethod < siman.FeatureDetectionMethod
    % SparksMethod.
    properties (Constant)
        ConnectivityTypeOptions = {'4', '8', '6', '18', '26'};
    end
    properties (GetObservable, SetObservable) % Registered properties
        ConnectivityType = '18';
        MinSize = 0;
        MaxSize = Inf;
        MaxCount = 200;
        ThumbnailStartOffset = -5;
        ThumbnailStopOffset = 20;
        ThumbnailWidth = 20;
        TraceWidth = 1;
    end
    
    methods
        % Constructor
        function obj = SparkletsMethod()
        end
        
        function InitMethod(obj)
            obj.FeatureType = 'sparklet';
            obj.DetectionDefName = 'sparklet detection';
            obj.UnitsDefName = 'sparklet units';

            obj.DetectionMethodOptions = {'detection image'};
       end
        
        function def = GetDefaultDetectionDefinition(obj)
            def = GetDefaultDetectionDefinition@siman.FeatureDetectionMethod(obj);
            op = def.AddOperation('subtract background');
            op = def.AddOperation('calculate baseline');
            op.BaselineFormat = '2-d';
            op.BaselineKernel.Width = 3;
            op = def.AddOperation('threshold');
            op.ThresholdType = 'baseline st dev';
            op.ThresholdValue = 3;
            op = def.AddOperation('morph');
            op.MorphType = 'dilate with threshold';
            op.MorphKernel.Width = 5;
            op = def.AddOperation('morph');
            op.MorphType = 'open';
        end
              
        function def = GetDefaultUnitsDefinition(obj)
            def = GetDefaultUnitsDefinition@siman.FeatureDetectionMethod(obj);
            op = def.AddOperation('subtract background');
            op = def.AddOperation('median filter');
            op = def.AddOperation('calculate baseline');
            op.BaselineFormat = '2-d';
            op = def.AddOperation('baseline normalization');
            op.BaselineFormat = '2-d';
        end        
    end
end





