classdef Transient < siman.Feature
    % Must be a subclass of handle
    properties
        PeakAmplitude;
        PeakIndex;
        LowerEdge;
        UpperEdge;
        WaveformStartOffset;
        WaveformStopOffset;
        Waveform;
        
        Baseline;
        BaselineRangeWidth;
        OnsetIndex;
        TimeToPeak;
        Index_DecayTo50;
        TimeTo50Decay;
        Index_DecayTo90;
        TimeTo90Decay;
    end
    
    methods
        % Constructor
        function obj = Transient()
            obj.Type = 'transient';
        end
        
        function h = Draw(obj, ax, plot)
            x = [obj.LowerEdge+1, obj.UpperEdge-1];
            y = [obj.PeakIndex, obj.PeakIndex];
            [x, y] = plot.ConvertPointsToPlot(x, y);
            if obj.IsSelected
                lineWidth = 2;
                color = [1 .7 1];
            else
                lineWidth = 1;
                color = [1 .4 1];
            end
            h = line(x, y, [2 2], 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
        end
        
        function str = GetListString(obj)
            str = [obj.Name ' (' num2str(obj.PeakAmplitude, 3) ...
                ', rise=' num2str(obj.TimeToPeak, 3) ', t50=' num2str(obj.TimeTo50Decay, 3) ')'];
        end
        
        function list = GetExportPropList(obj)
            list = {'PeakAmplitude', 'PeakIndex', 'TimeToPeak', 'TimeTo50Decay', 'TimeTo90Decay'};
        end
        
        function data = GetExportData(obj)
            data = obj.Waveform;
        end
        
        function hit = HitTest(obj, area, plot)
            index = obj.PeakIndex;
            tolerance = 3;
            hit = (area(1,2) < index+tolerance && area(2,2) > index-tolerance);
        end
        
        function tf = IsInView(obj, area)
            index = obj.PeakIndex;
            tf = (area(1,2) < index && area(2,2) > index);
        end
        
        function point = CenteredPoint(obj, point)
            point = [0, 0];
            point(1) = (obj.LowerEdge + obj.UpperEdge)/2;
            point(2) = obj.peakIndex;
        end
    end
end







