classdef TransientGraphPanel < siman.FeatureGraphPanel
    % ImagePropPanel
    properties (SetObservable, GetObservable)
        TraceType = 'window'; % 'window' or 'time profile'
    end
    properties (Constant)
        TraceTypeOptions = {'window', 'time profile'}
    end
    
    methods
        % Constructor
        function obj = TransientGraphPanel(parent)
            obj@siman.FeatureGraphPanel(parent, 'transient');
        end
        
        function mgr = GetManager(obj)
            mgr = siman.TransientManager.Instance;
        end
        
        function OnPropertyChanged(obj, src, evnt)
            switch evnt.PropertyName
                case {'TraceType'}
                    obj.QueueRedraw();
            end
            OnPropertyChanged@siman.FeatureGraphPanel(obj, src, evnt);
        end
        
        function InitDefaults(obj)
            obj.Name = 'Transient Graph';
            obj.Size = [260 280];
            obj.DockedLocation = 'south';
            obj.Stretchable = true;
            InitDefaults@siman.FeatureGraphPanel(obj);
        end
        
        function list = GetFeatureList(obj)
            source = obj.CurrentFeatureSource;
            if isempty(source)
                list = siman.List;
            else
                if strcmp(obj.TraceType, 'window')
                    list = source.GetFeatureType(obj.FeatureType);
                else
                    list = source.GetFeatureType(obj.TraceType);
                end
            end            
        end
        function list = GetSelectedFeatureList(obj)
            source = obj.CurrentFeatureSource;
            if isempty(source)
                list = siman.List;
            else
                if strcmp(obj.TraceType, 'window')
                    list = source.GetSelectedFeatureType(obj.FeatureType);
                else
                    list = source.GetSelectedType(obj.TraceType);
                end
            end            
        end
        
        % Handle enabling of controls tied to a local property
        function enabling = GetEnabling(obj, id, prop, context)
            enabling = true;
        end
        
    end
end


