function UpdateGraph(obj)

axesID = obj.GraphAxesID;
list = obj.GetFeatureList();
count = list.Count;
cla(axesID);
if count == 0
    return;
end
manager = obj.GetManager();
method = manager.FeatureDetectionMethod;
viewAll = obj.ViewAll;
drawnCount = 0;
for i = 1:count
    feature = list.ElementAt(i);
    isSelected = feature.IsSelected;
    if ~viewAll && ~isSelected
        continue;
    end
    drawnCount = drawnCount + 1;
    if strcmp(obj.TraceType, 'window')
        waveform = feature.Waveform;
        xData = [method.WaveformStartOffset:method.WaveformStopOffset];
    else
        waveform = feature.Profile;
        xData = [1:length(waveform)];
    end
    if feature.IsSelected && viewAll
        color = [1 0 0];
        lineWidth = 2;
    else
        color = [0 0 0];
        lineWidth = 1;
    end
    
    timeConversion = method.UnitConversion_Time;
    if ~isempty(waveform)
        xData = xData .* timeConversion;
        h = line('Parent', axesID, 'XData', xData, 'YData', waveform, 'Color', color, 'LineWidth', lineWidth);
        set(axesID, 'NextPlot', 'add');
    end
    
    if strcmp(obj.TraceType, 'window')
        maxVal = waveform(-feature.WaveformStartOffset + 1);
        baseline = feature.Baseline;
        
        onset = feature.OnsetIndex;
        if ~isempty(onset) && ~isnan(onset)
            onset = (onset - feature.PeakIndex) * timeConversion;
            onsetTickXData = [onset onset];
            onsetTickYData = [baseline baseline - .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', onsetTickXData, 'YData', onsetTickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
        
        indexOf50 = feature.Index_DecayTo50;
        if ~isempty(indexOf50) && ~isnan(indexOf50)
            crossingVal = waveform(indexOf50 - feature.PeakIndex -feature.WaveformStartOffset + 1);
            indexOf50 = (indexOf50 - feature.PeakIndex) * timeConversion;
            tickXData = [indexOf50 indexOf50];
            tickYData = [crossingVal - .1 * (maxVal - baseline) crossingVal + .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', tickXData, 'YData', tickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
        
        indexOf90 = feature.Index_DecayTo90;
        if ~isempty(indexOf90) && ~isnan(indexOf90)
            crossingVal = waveform(indexOf90 - feature.PeakIndex -feature.WaveformStartOffset + 1);
            indexOf90 = (indexOf90 - feature.PeakIndex) * timeConversion;
            tickXData = [indexOf90 indexOf90];
            tickYData = [crossingVal - .1 * (maxVal - baseline) crossingVal + .1 * (maxVal - baseline)];
            h = line('Parent', axesID, 'XData', tickXData, 'YData', tickYData, 'Color', [.5 .5 1], 'LineWidth', lineWidth);
        end
    end
end
if drawnCount > 0
    set(axesID, 'XLim', [xData(1) xData(end)]);
end