classdef Command < handle
    % Must be a subclass of handle
    properties
        Name
        Controller
        Enabled = 'on';
        IsCheckable = false;
        Checked = 'off';
        
        Tooltip
        Label
        
        Param1
        Param2
    end
    
    methods
    end
    
    methods
        % Constructor
        function obj = Command(name, controller)
            obj.Name = name;
            obj.Controller = controller;
        end
        
        function RefreshEnabling(obj, context)
            obj.Enabled = obj.Controller.ResetCommandEnabling(obj, context);
        end
        
        function RefreshMenuCheck(obj, context)
            if ~obj.IsCheckable
                return;
            end
            obj.Checked = obj.Controller.ResetCommandChecked(obj, context);
        end
        
        function Run(obj, id, context, param1, param2)
            if nargin > 3
                obj.Param1 = param1;
            end
            if nargin > 4
                obj.Param2 = param2;
            end
            obj.Controller.OnCommand(obj, id, context);
        end
    end
end







