classdef ImageGrabber < handle
    %UNTITLED Summary of this class goes here
    %   Detailed explanation goes here
    
    properties
        FigureID
        OutputSize = [200 200]
        PlotMargin = 100
        OnImageDrawnFcn = []
        ColorLim = []
    end
    
    methods
        function GrabAndSavePlotImage(obj, im, filename)
            im = obj.GrabPlotImage(im);
            imwrite(im, filename, 'tiff');            
        end
        function result = GrabPlotImage(obj, im)
            figID = obj.FigureID;
            figure(figID);
            clf(figID);
            figPos = get(figID, 'Position');
            figPos([3 4]) = obj.OutputSize + obj.PlotMargin;
            set(figID, 'Position', figPos);
            
            axesHandle = axes('Parent', figID);
            cla(axesHandle);
            set(axesHandle, 'Units', 'pixels');
            axesPos = get(axesHandle, 'Position');
            axesPos([3 4]) = obj.OutputSize;
            set(axesHandle, 'Position', axesPos);
            
            imagesc(im);
            if ~isempty(obj.ColorLim)
                set(axesHandle, 'CLim', obj.ColorLim);
            end
            if ~isempty(obj.OnImageDrawnFcn)
                f = obj.OnImageDrawnFcn;
                f(axesHandle);
            end
            
            drawnow;
            frame = getframe(axesHandle);
            % This following is a fix of a bug on Mac where images turn out gray randomly on first getframe
            if ismac && all(frame.cdata(:) == 232)
                frame = getframe(axesHandle);
            end
            result = frame2im(frame);
        end
        
        function GrabAndSavePlotGraph(obj, xdata, ydata, filename)
            im = obj.GrabPlotGraph(xdata, ydata);
            imwrite(im, filename, 'tiff');            
        end
        function result = GrabPlotGraph(obj, xdata, ydata)
            figID = obj.FigureID;
            figure(figID);
            clf(figID);
            figPos = get(figID, 'Position');
            figPos([3 4]) = obj.OutputSize;
            set(figID, 'Position', figPos);
            
            axesID = axes('Parent', figID);
            plot(xdata, ydata, 'Parent', axesID);
            set(axesID, 'XLim', [xdata(1) xdata(end)]);

            drawnow;
            frame = getframe(figID);
            % This following is a fix of a bug on Mac where images turn out gray randomly on first getframe
            if ismac && all(frame.cdata(:) == 232)
                frame = getframe(figID);
            end
            result = frame2im(frame);
        end
        
    end
    
end

