function deriv = deriv_5point(yvalues, h, deltaT)
% deriv_5point - Uses a 5-point stencil method to calculate the derivative of
% the given sampled function.
%
% yvalues - function to take the derivative of (i.e. f(t))
% h - distance between samples of each of the 5 stencil points (1 would be
% neighboring samples)
% deltaT - the actual time difference between samples (1/sample rate)
%
% Note that 2*h samples at the beginning and end of the trace will be zero

if nargin < 3
    deltaT = 1;
end

count = length(yvalues);

start = h*2+1;
stop = count - h*2;

deriv = zeros(size(yvalues));
denom = 12 * deltaT * h;
for x = start:stop
    deriv(x) = (yvalues(x - 2*h) - 8*yvalues(x - h) + ...
        8*yvalues(x + h) - yvalues(x + 2*h))/ denom;
end