function result = dilate_threshold( input, struct_el, threshold )
%dilate_threshold Do the morphological operation of dilation but with a threshold applied 

dim = size(input);
if numel(dim) == 2  % input is 2-d, output is 1-d in x (traces in rows)
    kernel = double(struct_el.getnhood);
    if ~isa(input, 'double')
        input = double(input);
    end
    result = min(input + (conv2(input, kernel, 'same') > threshold), ones(size(input)));
else
    error('Not implemented');
end