function makeavi( filename, data, params )
%makeavi Create a movie from a stack of images

if nargin < 3
    params = [];
end
%Profiles : 'Archival','Motion JPEG AVI','Motion JPEG 2000','Uncompressed AVI', 'MPEG-4' (windows only)
if isfield(params, 'Format')
    format = params.Format;
else
    format = 'Motion JPEG AVI';
end
if isfield(params, 'FrameRate')
    framerate = params.FrameRate;
else
    framerate = 30;
end
if isfield(params, 'Colormap')
    cMap = params.Colormap;
else
    cMap = colormap();
end
cMapLength = length(cMap);
if isfield(params, 'CLim')
    cLim = params.CLim;
else
    cLim = [0 255];
end
dim = size(data);
if length(dim) < 3
    dim(3) = 1;
end
frameCount = dim(3);

aviobj = VideoWriter(filename, format);
aviobj.FrameRate = framerate;

open(aviobj);
for i = 1:frameCount
    img = data(:,:,i);
    scaledImage = mat2gray(img, cLim)*(cMapLength-1) + 1;
    frame = im2frame(scaledImage, cMap);
    writeVideo(aviobj, frame);
end
close(aviobj);
disp('Movie completed');
