function output = map2range( input, new_limits, old_limits )
%map2range: convert an image into a new indexed range

if nargin < 3
    old_limits = [min(input(:)) max(input(:))];
end
old_range = old_limits(2)-old_limits(1);
new_range = new_limits(2)-new_limits(1);
range_conversion = new_range / old_range;
output = (input - old_limits(1))* range_conversion + new_limits(1);
output = min(new_limits(2), max(new_limits(1), output));
