function [baseline, stdevs] = min_region_baseline( input, region_size, med_filt, mask )
%min_region Find the baseline of the given input using an algorithm that
%   finds the minimum 

dim = size(input);
if numel(dim) == 2  % input is 2-d, output is 1-d in x (traces in rows)
    output_size = dim(2);
    trace_length = dim(1);
    baseline = zeros(1, output_size);
    stdevs = zeros(1, output_size);
    region_count = trace_length-region_size+1;
    region_totals = zeros(region_count, 1);
    for i = 1:output_size
        rawTrace = input(:,i);
        if med_filt > 1
            trace = medfilt1(rawTrace, med_filt);
        else
            trace = rawTrace;
        end      
        region_totals(1) = sum(trace(1:region_size));
        for j = 1:region_count-1
            region_totals(j+1) = region_totals(j) - trace(j) + trace(j + region_size);
        end
        [~, index] = min(region_totals);
        baseline(i) = mean(rawTrace(index:index+region_size-1));
        stdevs(i) = std(rawTrace(index:index+region_size-1));
    end
else  % input is 3-d, output is 2-d in x and y (traces in z-dim)
    output_size = dim(1:2);
    trace_length = dim(3);
    baseline = zeros(output_size);
    stdevs = zeros(output_size);
    region_count = trace_length-region_size+1;
    region_totals = zeros(region_count, 1);
    for x = 1:output_size(1)
        for y = 1:output_size(2)
            if mask(x, y)
                rawTrace = input(x, y, :);
                if med_filt > 1
                    trace = medfilt1(rawTrace, med_filt);
                else
                    trace = rawTrace;
                end      
                region_totals(1) = sum(trace(1:region_size));
                for j = 1:region_count-1
                    region_totals(j+1) = region_totals(j) - trace(j) + trace(j + region_size);
                end
                [~, index] = min(region_totals);
                baseline(x, y) = mean(rawTrace(index:index+region_size-1));
                stdevs(x, y) = std(rawTrace(index:index+region_size-1));
            end
        end
    end
end