function [x, y, z] = xyindexes( indexes, dim )
%xyindexes Find the x and y indexes given absolute index and image dim 

height = dim(1);
if numel(dim) == 2  % input is 2-d, output is 1-d
    y = mod(indexes, height);
    y(y == 0) = height;
    x = floor((indexes-1)/height) + 1;
    if nargout > 2
        z = ones(size(indexes));
    end
else % input is 3-d, output is 1-d
    frameSize = height*dim(2);
    z = floor((indexes-1)/frameSize) + 1;
    indexes = indexes - (z-1)*frameSize;
    y = mod(indexes, height);
    y(y == 0) = height;
    x = floor((indexes-1)/height) + 1;
end


