clearvars
file2=uigetdir;
file=dir([file2 '/*.tif']);
NF=length(file);
segt=0.99;

for i = 1:NF
images(:,:,:,i)=imread(fullfile([file2 filesep file(i).name]));
end

BW=roipoly(max(images,[],4));
close all
ny=size(images,1);
nx=size(images,2);

im3d1R=zeros(ny,nx,NF);
im3d1G=zeros(ny,nx,NF);

dogIB=cell(NF,1);
im3d1B=zeros(ny,nx,NF);
im3d2B=zeros(ny,nx,NF);
im3d3B=zeros(ny,nx,NF);

for i=1:NF
imR=im2double(images(:,:,1,i)).*BW;
imB=im2double(images(:,:,3,i)).*BW;
imG=im2double(images(:,:,2,i)).*BW;
im3d1R(:,:,i)=imR;
im3d1G(:,:,i)=imG;
im3d1B(:,:,i)=imB;
dogIB{i}=diff_gauss(imB,20,2,40,4);
im3d2B(:,:,i)=dogIB{i};
end

for i=1:NF
    im3d3B(:,:,i)=im2bw(imadjust(im3d2B(:,:,i)),0.99);
end

im3d3B=bwareaopen(im3d3B,30);
ccB=bwconncomp(im3d3B);
num_nucleiB=ccB.NumObjects;

r=regionprops(ccB,'Area','Centroid');
areas=zeros(num_nucleiB,1);
c=zeros(num_nucleiB,3);
for i=1:num_nucleiB
    areas(i)=r(i).Area;
    c(i,:)=r(i).Centroid;
end
ar=round(sqrt(mean(areas))/pi*1.5);

temp2=zeros(num_nucleiB,1);
temp3=zeros(num_nucleiB,1);
for i=1:num_nucleiB
    temp=im3d1R(round(c(i,2))-ar:round(c(i,2))+ar,round(c(i,1))-ar:round(c(i,1))+ar,:);
    temp2(i)=sum(temp(:));
    clear temp
    temp=im3d1G(round(c(i,2))-ar:round(c(i,2))+ar,round(c(i,1))-ar:round(c(i,1))+ar,:);
    temp3(i)=sum(temp(:));
    clear temp
end
num_nucleiR=0;
num_nucleiG=0;

temp2=temp2./max(temp2(:));cR=[];
for i=1:num_nucleiB
    if temp2(i)>0.2
        num_nucleiR=num_nucleiR+1;
        cR=[cR;c(i,:)];
    end
end
temp3=temp3./max(temp3(:));cG=[];
for i=1:num_nucleiB
    if temp3(i)>0.2
        num_nucleiG=num_nucleiG+1;
        cG=[cG;c(i,:)];
    end
end
d=[];
for i=1:length(cR)
    for j=1:length(cG)
        d=[d; sqrt((cR(i,1)-cG(j,1))^2+(cR(i,2)-cG(j,2))^2+(cR(i,3)-cG(j,3))^2)];
    end
end
