%% First, a figure for the non-normalized steady state. 
%All units are in nM and s 

c = 1e-9; % divide everything by this value to get nM. See line 31 for starting Vg1 conc

l_N = 2e-13; %Nodal production rate 
l_N = l_N/c; 

B_N = log(2)/(6e3);  %Nodal degradation rate
B_V = log(2)/(6e3); %Vg1 degradation rate 

l_D = 1e6; %dimerization rate 
l_D = l_D*c; 

sTime1 = 4*60*60 %1.4e4; 
sTime2 = 6*60*60 %2.2e4; 

p(1) = l_N; 
p(2) = B_N; 
p(3) = B_V; 
p(4) = l_D; 
p(5) = sTime1; 
p(6) = sTime2; 

figure('Color','w'); 
hold all; 
    
tSpan = [0 3e4];

%y = [N,V,D] 
y0 = [0,(1e-07)/c,0];  % starting vg1 conc =100nM
options = odeset('AbsTol',1e-20); 
[t,y] = ode23t(@(t,y) vg1ODE_TM(t,y,p),tSpan,y0);
plot(t,y(:,3),'-b','LineWidth',2);
xlabel('Time (hours)','FontSize',16); 
ylabel('Dimer Concentration (nM)','FontSize',16); 
%title('Absolute Concentration','FontSize',18); 
set(gca,'FontSize',13);
tMat = [0 2*60*60 4*60*60 6*60*60 8*60*60] %[0 0.5e4 1e4 1.5e4 2e4 3e4];
set(gca,'XTick',tMat);
set(gca,'XTickLabel',tMat/60/60);


%Next, the Nodal-only model. 
p(1) = l_N; 
p(2) = B_N; 
p(3) = l_D;  
p(4) = sTime1; 
p(5) = sTime2; 
    
tSpan = [0,3e4];
y0 = [0,0];
[t,y] = ode23t(@(t,y) NodODE_TM(t,y,p),tSpan,y0);
plot(t,y(:,2),'-r','LineWidth',2);

legend({'Vg1-Nodal','Nodal-Nodal'},'FontSize',14); 

y1 = [0:1e-07:1e-06]/c; 
x1 = sTime1 + 0*y1; 
x2 = sTime2 + 0*y1; 
plot(x1,y1,'--k'); 
plot(x2,y1,'--k'); 
ylim([0,1.5*max(y(:,2))]); 
saveas(gcf,'Compare_vg1_Nodal_literatureParams'); 

%%  

c = 1e-09; 
l_N = 2e-13; %Nodal production rate 
l_N = l_N/c; 

B_N = log(2)/(6e3);  %Nodal degradation rate
B_V = log(2)/(6e3); %Vg1 degradation rate 

l_D = 1e6; %dimerization rate 
l_D = l_D*c; 

sTime1 = 1.4e4; 
sTime2 = 2.2e4; 

p(1) = l_N; 
p(2) = B_N; 
p(3) = B_V; 
p(4) = l_D; 
p(5) = sTime1; 
p(6) = sTime2; 

figure('Color','w'); 
hold all; 
    
tSpan = [0 3e4];

%y = [N,V,D] 
y0 = [0,(1e-06)/c,0];
options = odeset('AbsTol',1e-20); 
[t,y] = ode23t(@(t,y) vg1ODE_TM(t,y,p),tSpan,y0);
plot(t,y(:,3),'-b','LineWidth',2);
xlabel('Time','FontSize',14); 
ylabel('Dimer Concentration','FontSize',14); 
title('Absolute Concentration'); 

%Next, the Nodal-only model. 
p(1) = l_N; 
p(2) = B_N; 
p(3) = l_D;  
p(4) = sTime1; 
p(5) = sTime2; 
    
tSpan = [0,3e4];
y0 = [0,0];

lMat = [1 1.5 2]; 

for i=1:length(lMat)
    p(1) = l_N*lMat(i); 
    [t,y] = ode23t(@(t,y) NodODE_TM(t,y,p),tSpan,y0);
    plot(t,y(:,2),'-r','LineWidth',2);
end


legend({'Vg1-Nodal','Nodal-Nodal'},'FontSize',14); 

y1 = [0:1e-07:1e-06]/c; 
x1 = sTime1 + 0*y1; 
x2 = sTime2 + 0*y1; 
plot(x1,y1,'--k'); 
plot(x2,y1,'--k'); 
ylim([0,1.5*max(y(:,2))]); 

