function dydt = vg1ODE_TM(t,y,p)

l_N = p(1); %Nodal synthesis rate
B_N = p(2); %Nodal degradation rate

B_V = p(3); %vg1 degradation rate

l_D = p(4); %dimerization rate

sTime1 = p(5); %Nodal synthesis start time
sTime2 = p(6); %Nodal synthesis end time 

dydt(1) = (t > sTime1 && t < sTime2)*l_N - B_N*y(1) - l_D*y(1)*y(2); 
%Nodal synthesis occurs with constant rate for sTime1 < t < sTime2, first
%order degradation, bimolecular complexing with Vg1. 

dydt(2) =  -B_V*y(2) - l_D*y(1)*y(2); 
%Vg1 is not synthesized (present from maternal deposition, represented by
%initial conditions), removed by first-order degradation and dimerization. 

dydt(3) = l_D*y(1)*y(2); 
%Dimer is stable, only snthesized. 

dydt = dydt'; 

