## R_Script written by Ilian Atanassov

setwd(dir = "") # to file location

library(ggplot2) # for plotting

list.files()

### Read evidence in
evidence <- read.table(file = "evidence.txt",header = TRUE,sep = "\t",stringsAsFactors = FALSE,comment.char = "")
names(evidence)
###  Remove Reverse and Potential contaminants
evidence.filtered <- evidence[evidence$Potential.contaminant != "+",]
#### Remove all evidences with pep > 0.0001
evidence.filtered <- evidence.filtered[evidence.filtered$PEP <= 0.001,]
### How are experiments named
unique(evidence.filtered$Experiment)

## Example for plotting "Control" experiment from Figure 2D, but it also applies for Figure 1-figure supplement 1B
ggplot(data = subset(x = evidence.filtered,subset = Experiment == "Control" & evidence.filtered$ADPR.S..site.IDs != ""), # subset data for plotting all evidences from the "Control" experiment that do not match with any ADPr site
       mapping = aes(x = log2(Ratio.H.L.normalized), y = log2(Intensity)))+ # Ratio vs Intensity; log2 transform both value
        geom_point(shape = 19,alpha = 0.25,size = 0.8)+ # points are round and very transparent (0.25%)
        geom_point(data = subset(x = evidence.filtered,subset = Experiment == "Control" & evidence.filtered$ADPR.S..site.IDs != ""),
                   shape = 21,fill = "red",color = "black",size = 1.3)+ # add all data points that map to and ADPR site, larger and red.
        labs(x = "log2 Ratio H/L", y = "log2 intensity",title = "Control")+ 
        theme_bw()+ # remove background from the plot
        coord_cartesian(xlim = c(-11,11), ylim = c(22,28))+ # x axis limits
        theme(axis.text.x = element_text(size = 10), # set font size to 10
              axis.text.y = element_text(size = 10),
              axis.title.x = element_text(size = 10),
              axis.title.y = element_text(size = 10))+
        #theme(legend.position="none")+
        ggsave(filename = "Ratio vs Intensity Control.pdf",  # export
               width = 8, 
               height = 8, 
               units = "cm",useDingbats = FALSE)