function CalciumFacet_2017

evalin('base','clear all')
global mygui;

%% Create GUI
figure('MenuBar','none','Toolbar','figure','Name','BullPlot','NumberTitle','off','Position',[100,100,1250,640]);
RGB=get(gcf,'Color');
pp = uipanel('BackgroundColor',RGB,'Position',[.1 .0 .9 1],'BorderType','none');
hp = uipanel('BackgroundColor',RGB,'Position',[.005 .07 .19 .85]);

uicontrol('Parent',hp,'Style','PushButton','String','Open','Position',[15,460,200,20],...
    'CallBack',@OpenButtonChange);
uicontrol('Parent',hp,'Style','PushButton','String','Draw ROI','Position',[15,430,200,20],...
    'CallBack',@ROIButtonChange);
uicontrol('Parent',hp,'Style','PushButton','String','Save ROI','Position',[15,400,100,20],...
    'CallBack',@ROISave);
uicontrol('Parent',hp,'Style','PushButton','String','Open ROI','Position',[115,400,100,20],...
    'CallBack',@ROIOpen);
uicontrol('Parent',hp,'Style','PushButton','String','3 Peaks','Position',[15,370,100,20],...
    'CallBack',@SinglePointButtonChange);
uicontrol('Parent',hp,'Style','PushButton','String','AverageRow','Position',[115,370,100,20],...
    'CallBack',@AverageRowButtonChange);
uicontrol('Parent',hp,'Style','PushButton','String','Load new','Position',[15,340,100,20],...
    'CallBack',@OverlayButtonChange);
uicontrol('Parent',hp,'Style','PushButton','String','Save Figure','Position',[115,340,100,20],...
    'CallBack',@FigureButtonChange);
PeakButton=uicontrol('Parent',hp,'Style','PushButton','String','Calc Peaks','Position',[15,310,100,20],...
    'Enable','off','CallBack',@PeakButtonChange);
LSButton=uicontrol('Parent',hp,'Style','PushButton','String','Line Scan','Position',[115,310,100,20],...
    'CallBack',@LSButtonChange);
NewROIButton=uicontrol('Parent',hp,'Style','PushButton','String','New ROI','Position',[15,280,100,20],...
    'Enable','on','CallBack',@NewROIButtonChange);
CorrButton=uicontrol('Parent',hp,'Style','PushButton','String','Corr','Position',[130,280,80,20],...
    'Enable','on','CallBack',@CorrButtonChange);
SelStimEdit=uicontrol('Parent',hp,'Style','Edit','String','1','Position',[125,280,20,20]);
InfoButton=uicontrol('Parent',hp,'Style','PushButton','String','Info','Position',[15,250,60,20],...
    'CallBack',@InfoButtonChange);
ShowStimButton=uicontrol('Parent',hp,'Style','PushButton','String','Show Stimuli','Position',[120,250,80,20],...
    'CallBack',@ShowStimButtonChange);

ROIDFFcheckbox = uicontrol('Parent',hp,'Style','CheckBox','String','DFF ROI?','Position',[20,230,80,20],'BackgroundColor',RGB);
set(ROIDFFcheckbox,'Value',0);
DFFcheckbox = uicontrol('Parent',hp,'Style','CheckBox','String','Plot DFF ?','Position',[20,210,80,20],'BackgroundColor',RGB,...
    'CallBack',@DFFcheckboxChange);
set(DFFcheckbox,'Value',1);
Registercheckbox = uicontrol('Parent',hp,'Style','CheckBox','String','Register Imag?','Position',[20,190,90,20],'BackgroundColor',RGB);
set(Registercheckbox,'Value',0);
Smoothcheckbox = uicontrol('Parent',hp,'Style','CheckBox','String','Subtr Base?','Position',[20,170,90,20],'BackgroundColor',RGB);
LastFramescheckbox = uicontrol('Parent',hp,'Style','CheckBox','String','Last Frames?','Position',[20,150,100,20],'BackgroundColor',RGB);
MultiPlot = uicontrol('Parent',hp,'Style','CheckBox','String','multi ROI?','Position',[120,230,80,20],'BackgroundColor',RGB);
DFFAutoScale = uicontrol('Parent',hp,'Style','CheckBox','String','AutoScale?','Position',[120,210,80,20],'BackgroundColor',RGB);
NewRet = uicontrol('Parent',hp,'Style','CheckBox','String','new Retina?','Position',[120,190,80,20],'BackgroundColor',RGB);
set(NewRet,'Value',1);
Heat = uicontrol('Parent',hp,'Style','CheckBox','String','Heatmap?','Position',[120,170,80,20],'BackgroundColor',RGB);
set(Heat,'Value',1);
Rotate = uicontrol('Parent',hp,'Style','CheckBox','String','Rotate?','Position',[120,150,80,20],'BackgroundColor',RGB);
set(Rotate,'Value',0);
willGraphs = uicontrol('Parent',hp,'Style','CheckBox','String','Graphs?','Position',[20,130,100,20],'BackgroundColor',RGB);
OFF = uicontrol('Parent',hp,'Style','CheckBox','String','OFF?','Position',[120,130,100,20],'BackgroundColor',RGB);

mySlider =  uicontrol('Style', 'slider',...
    'Min',1,'Max',181,'Value',1,...
    'SliderStep',[1/180 1/18],...
    'Position', [300 20 300 20],...
    'Callback', {@RawSliderChange});
mySliderText = uicontrol('Style','text',...
    'Position',[620 20 30 20],...
    'String','1');
mymax = uicontrol('Style','edit',...
    'String','700',...
    'Position',[900 50 50 20],...
    'Callback', {@edittext_Callback});
mymin = uicontrol('Style','edit',...
    'String','100',...
    'Position',[900 20 50 20],...
    'Callback', {@edittext_Callback});


mygui.plfig = 0;
mygui.StimFig = 0;
mygui.DeltaMax=7;mygui.DeltaMin=4;
PlotA=    subplot(1,2,1,'Parent',pp );
PlotB=  subplot(1,2,2 );
mygui.habePuls = 0;

%% Open Tif-File

    function OpenButtonChange(h, eventdata) %#ok<INUSD>
        
        allfilename = uipickfiles('FilterSpec' ,'*.tif','out','ch');
        [numberFiles,b]=size(allfilename);
        if numberFiles == 0
            h=msgbox('Please select File ...');
            return
        end
        mygui.numFiles=numberFiles;
        neufilename=allfilename(1,:);
        mygui.MatFilename = strrep(neufilename, '.tif', '.mat');
        MatFileDa = exist(mygui.MatFilename,'file');
        mygui.copydata=[];
        if numberFiles == 1
            
            [pathstr,name,ext] = fileparts(neufilename) ;
            
            currentFolder = pwd;
            if ~strcmp(currentFolder,pathstr(1:end-1))
                cd (num2str(pathstr));
            end
            mygui.filename=neufilename;
            habeDatei=0;
            tic;
            if MatFileDa
                StimInfo=open(mygui.MatFilename);
                mygui.GlobStimInfo=StimInfo;
            end
            %                               profile on
            %          if isfield(StimInfo,'movie3')
            if isfield(StimInfo,'movie1')
                habeDatei=1;
                mygui.movie1 = StimInfo.movie1;
                mygui.movie2 = StimInfo.movie2;
                mygui.header = StimInfo.header;
                mygui.info   = StimInfo.info;
                num_images = numel(mygui.info);
                headerString = mygui.info(1).ImageDescription;
                mygui.header=parseHeader(headerString);
                NoChannel=mygui.header.acq.numberOfChannelsAcquire;
                mygui.MaxImage=floor(num_images/NoChannel);
                %             set(Registercheckbox,'Value',0);
            else
                h=msgbox('Loading File ...');
                %                    profile on
                mygui.info = imfinfo(neufilename,'tif');
                num_images = numel(mygui.info);
                headerString = mygui.info(1).ImageDescription;
                mygui.header=parseHeader(headerString);
                NoChannel=mygui.header.acq.numberOfChannelsAcquire;
                mygui.MaxImage=floor(num_images/NoChannel);
                %         num_images=1110;
                %         mygui.MaxImage=555;
                mygui.movie1=zeros(mygui.info(1,1).Height,mygui.info(1,1).Width,mygui.MaxImage,'uint16');
                mygui.movie2=zeros(mygui.info(1,1).Height,mygui.info(1,1).Width,mygui.MaxImage,'uint16');
                mygui.movie3=zeros(mygui.info(1,1).Height,mygui.info(1,1).Width,mygui.MaxImage,'uint16');
                i=1;
                %                  profile on
                switch NoChannel
                    
                    case 1
                        for k = 1:num_images
                            mygui.movie1(:,:,i) = imread(neufilename,'tif','Index', k, 'Info', mygui.info);
                            %                     progressbar(i/num_images) % Update progress bar
                            i=i+1;
                        end
                    case 2
                        for k = 1:2:num_images
                            mygui.movie1(:,:,i) = imread(neufilename,'tif','Index', k, 'Info', mygui.info);
                            mygui.movie2(:,:,i) = imread(neufilename,'tif','Index', k+1, 'Info', mygui.info);
                            %                     progressbar(i*2/num_images) % Update progress bar
                            i=i+1;
                        end
                    case 3
                        for k = 1:3:num_images
                            mygui.movie1(:,:,i) = imread(neufilename,'tif','Index', k, 'Info', mygui.info);
                            mygui.movie2(:,:,i) = imread(neufilename,'tif','Index', k+1, 'Info', mygui.info);
                            mygui.movie3(:,:,i) = imread(neufilename,'tif','Index', k+2, 'Info', mygui.info);
                            progressbar(i*3/num_images) % Update progress bar
                            i=i+1;
                        end
                end
                %                   profile off
                %                   profile viewer
                
                close(h);
            end
        else
            erstesmal = 1; i = 1;
            for j=1 : numberFiles
                neufilename=allfilename(j,:);
                mygui.MatFilename = strrep(neufilename, '.tif', '.mat');
                MatFileDa = exist(mygui.MatFilename,'file');
                [pathstr,name,ext] = fileparts(neufilename) ;
                currentFolder = pwd;
                if ~strcmp(currentFolder,pathstr(1:end-1))
                    cd (num2str(pathstr));
                end
                Ausgabe=strcat('Loading File ...  ',name);
                h=msgbox(Ausgabe);
                %                 h=msgbox('Loading File ...');
                mygui.info = imfinfo(neufilename,'tif');
                num_images = numel(mygui.info);
                headerString = mygui.info(1).ImageDescription;
                mygui.header=parseHeader(headerString);
                NoChannel=mygui.header.acq.numberOfChannelsAcquire;
                mygui.MaxImage=floor(num_images/NoChannel);
                if erstesmal
                    mygui.movie1=zeros(mygui.info(1,1).Height,mygui.info(1,1).Width,mygui.MaxImage*numberFiles,'uint16');
                    mygui.movie2=zeros(mygui.info(1,1).Height,mygui.info(1,1).Width,mygui.MaxImage*numberFiles,'uint16');
                    erstesmal = 0;             habeDatei=0;
                    
                end
                if MatFileDa
                    StimInfo=open(mygui.MatFilename);
                    mygui.GlobStimInfo=StimInfo;
                    mygui.Brightness(j) = StimInfo.params.dot(2).dot1Bright;
                end
                for k = 1:2:num_images
                    mygui.movie1(:,:,i) = imread(neufilename,'tif','Index', k, 'Info', mygui.info);
                    mygui.movie2(:,:,i) = imread(neufilename,'tif','Index', k+1, 'Info', mygui.info);
                    i=i+1;
                end
                close(h);
            end;
            mygui.MaxImage = i-1;
        end
        set(InfoButton,'Enable', 'off');
        set(ShowStimButton,'Enable', 'on');
        mygui.myColor=1; mygui.StimuCourse=0; mygui.TimeCourse=0; mygui.peak=[];
        mygui.TPAnfang=0; mygui.TPEnde=0;
        
        %          profile viewer
        if get(Rotate,'Value')==1
            for i=1: mygui.MaxImage
                mygui.movie1(:,:,i) = imrotate(flipdim(mygui.movie1(:,:,i) ,2),-90,'bilinear');
            end
        end
        mygui.movie1(:,:,1) = mygui.movie1(:,:,3);
        mygui.movie1(:,:,2) = mygui.movie1(:,:,3);
        GetStartStop;
        Mittel=mean(mean(mygui.movie2,2))/100;
        mygui.Stimu2Course= Mittel(:)';
        mygui.movie3 =[];
        axes(PlotA);
        imshow(mygui.movie1(:,:,2),[0 2000],'Border','tight');  %imagesc(mygui.movie1(1,5).data);        colormap(gray);  axis off; freezeColors;
        mytextout(name, [15 5 150 20])
        Zoom= num2str(mygui.header.acq.zoomFactor);
        mytextout( strcat('Zoom Factor=',Zoom), [15 67 200 20]);
        if isfield(StimInfo.params,'dot')
            Bright=num2str(mygui.GlobStimInfo.params.dot(1).dot1Bright);
            mytextout( strcat('Bright=',Bright), [15 48 200 20]);
        end
        if isfield(StimInfo.params,'background')
            BG=num2str(mygui.GlobStimInfo.params.background);
            mytextout( strcat('  ',BG), [75 48 200 20]);
        end
        mygui.framerate=(mygui.header.acq.frameRate);
        mytextout( strcat('frameRate=',num2str(mygui.framerate)), [15 85 200 20])
        if mygui.MaxImage < 1000
            test=mean(mygui.movie1(:,:,:),3);
        else
            test=mean(mygui.movie1(:,:,1:1000),3);
        end
        test=mean(mygui.movie1(:,:,:),3);
        
        testfft=fft2(test);
        if get(Registercheckbox,'Value')==1
            for i=3: mygui.MaxImage
                
                [output Greg] = dftregistration(testfft,fft2(mygui.movie1(:,:,i)),1);
                if max(abs(output)) < 30
                    mygui.movie1(:,:,i)=abs(ifft2(Greg));
                else
                    i
                    (output)
                    
                end
                
            end;
        end;
        % TEST ENDE
        mygui.Offset=0;
        mygui.MeanImg=mean(mygui.movie1,3);
        mygui.MeanImg=mygui.MeanImg-mygui.Offset;
        mmax=round(max(max(mygui.MeanImg)));  set(mymax,'string',num2str(mmax));
        mmin=round(min(min(mygui.MeanImg)));  set(mymin,'string',num2str(mmin));
        axes(PlotB); imshow(mygui.MeanImg,[mmin mmax],'Border','tight')       %imagesc(MeanImg);
        colormap(gray); axis tight;  freezeColors;
        axis off;
        set(mySlider,'Value',1); set(mySlider,'Callback', {@RawSliderChange});   set(mySliderText,'String',num2str(1));
        mygui.willFlicker=1;
        mygui.Repet=1;
        set(PeakButton,'Enable', 'on');
        if MatFileDa > 0
            set(InfoButton,'Enable', 'on');
            if habeDatei== 0
                StimInfo=open(mygui.MatFilename);
            end
            mytextout('type:', [15 145 40 20]); mytextout(StimInfo.type, [55 145 120 20]) ;
            mygui.will3Dot =  strcmp(StimInfo.type,'sfnew');
            mygui.willAxel =  strcmp(StimInfo.type,'Axel dot flicker');
            mygui.willSquare =  strcmp(StimInfo.type,'moving square');
            mygui.willDotFlicker = strcmp(StimInfo.type,'single dot flicker');
            if mygui.will3Dot
                mygui.diffStimuli=max(StimInfo.params.stimSequence)-min(StimInfo.params.stimSequence)+1;
            end
            mytextout('size:', [15 125 40 20]);
            if isfield(StimInfo.params,'flashingHSize')
                mytextout(StimInfo.params.flashingHSize, [55 125 40 20]) ; mytextout(StimInfo.params.flashingVSize, [85 125 40 20]) ;
            elseif isfield(StimInfo.params,'dot')
                mytextout('     ', [55 125 40 20]) ; mytextout(StimInfo.params.dot(1).s(1), [85 125 40 20]) ;
            else
                mytextout('     ', [55 125 40 20]) ; mytextout('     ', [85 125 40 20]) ;
            end
            mytextout('seq:', [15 105 40 20]);
            
            if isfield(StimInfo.params,'stimSequence')
                mytextout(num2str(StimInfo.params.stimSequence),[55 105 180 20]);
                mygui.Sequence = StimInfo.params.stimSequence;
            end
        else
            mytextout('     ', [55 145 40 20]) ;
            mytextout('     ', [55 125 40 20]) ; mytextout('     ', [85 125 40 20]) ;
            mytextout('     ', [55 105 40 20]) ; mytextout('     ', [85 105 40 20]) ;
            
            
            
        end
        if habeDatei== 0
            info=mygui.info;
            movie1=mygui.movie1;
            movie2=mygui.movie2;
            header=mygui.header;
            save(mygui.MatFilename,'movie1','movie2','info','header','-append');
        end
        calcDFF;
        %                                        profile off
        %                                profile viewer
        %
    end


    function header=parseHeader(input)
        % PARSEHEADER   - Read ScanImage Header String and return structure.
        %   PARSEHEADER will output the value of the header fields as a structure.
        %   Input is the header from ScanImage TIF File (char array).
        out={};
        header = struct();
        tempcell=strread(input,'%q');
        for lineCounter=1:length(tempcell)
            data=tempcell{lineCounter};
            if ~strncmp(data,'state.',6)
                out{end}=[out{end} ' ' data(1:end-1)];
                continue
            end
            equal=findstr('=',data);
            param=data(7:equal-1);
            val=data(equal+1:end);
            if isempty(val)
                val=[];
            elseif ~strcmp(val(1),'''')
                val=str2num(val);
            else
                if strcmp(val(end),'''')
                    val=val(2:end-1);
                else
                    val=val(2:end);
                end
            end
            out=[out {param} {val}];
        end
        
        while length(out)
            eval(['header.' out{1} '=out{2};']);
            %out=out(3:end); %VI092209A
            out(1:2)=[]; %VI092209A
        end
    end





%% Calculate DFF

    function calcDFF
        a=size(mygui.movie1);
        if a(1) > 100
            myfilter = fspecial3('gaussian',[5 5 1]);
        else
            myfilter = fspecial3('gaussian',[5 5 3]);
        end;
        mygui.DFF=single(imfilter(mygui.movie1,myfilter))+50;
        if get(LastFramescheckbox,'Value')==1
            DiffBild=mean(mygui.DFF(:,:,mygui.MaxImage-6:mygui.MaxImage),3);
        else
            DiffBild=mean(mygui.DFF(:,:,15:20),3);
        end;
        
        for i=1: mygui.MaxImage
            B = imsubtract(mygui.DFF(:,:,i),DiffBild);
            C = (imdivide(B,DiffBild));
            mygui.DFF(:,:,i) =C;
        end;
        % subtract baseline
        if get(Smoothcheckbox,'Value')==1
            myfilter = fspecial3('gaussian',[1 1 20]);
            BaseImage=single(imfilter(mygui.DFF,myfilter));
            for i=1: mygui.MaxImage
                B = imsubtract(mygui.DFF(:,:,i),BaseImage(:,:,i));
                mygui.DFF(:,:,i) = B;
            end;
        end;
        if get(DFFAutoScale,'Value')==1
            mygui.DFFmax=max(max(max(mygui.DFF)))/4;
            mygui.DFFmin=-(mygui.DFFmax/8);
        else
            mygui.DFFmax=3;
            mygui.DFFmin=-0.5;
            %             mygui.DFFmax=5;
            %             mygui.DFFmin=-1;
        end;
        mytextout(num2str(mygui.DFFmin), [420 50 50 20]);
        mytextout(num2str(mygui.DFFmax), [520 50 50 20]);
        val=get(mySlider,'Value');
        mygui.ImageNo=round(val);
        axes(PlotA); imshow( mygui.DFF(:,:,mygui.ImageNo),[mygui.DFFmin mygui.DFFmax],'Colormap',jet);
        if get(DFFcheckbox,'Value')==1
            set(mySlider,'Callback', {@DFFSliderChange});
        else
            set(mySlider,'Callback', {@RawSliderChange});
        end
    end





%% Extract Stimuli-Timing

    function GetStartStop(hWidget)
        Mittel=mean(mean(mygui.movie2,2))/100;
        mygui.StimuCourse= Mittel(:)';
        tmp=mygui.StimuCourse;
        D=diff(tmp);
        mygui.TPAnfang=find(D>50);
        mygui.TPEnde=find(D<-50);
        xx=find(diff(mygui.TPAnfang)<2);
        mygui.TPAnfang(xx+1)=[];
        xx=find(diff(mygui.TPEnde)<2);
        mygui.TPEnde(xx+1)=[];
        
    end
%% Utils

    function mytextout(mytext, myPos)
        uicontrol('Style','text',...
            'Position',myPos,...
            'String',mytext,'BackgroundColor', [0.95 0.95 0.95],'HorizontalAlignment','left');
    end
    function subplottight(n,m,i)
        [c,r] = ind2sub([m n], i);
        subplot('Position', [(c-1)/m, 1-(r)/n, 1/m-0.01, 1/n])
    end
%% Calculate ROI Statisitics
    function CalcROI(mymask)
        MyBGColor=hsv(12);
        if get(DFFcheckbox,'Value')==1
            for i=1: mygui.MaxImage
                AA=mygui.DFF(:,:,i);
                AA=AA(mymask);
                mygui.TimeCourse(i) = mean(AA);
            end;
        else
            for i=1: mygui.MaxImage
                AA=mygui.movie1(:,:,i);
                AA=AA(mymask);
                mygui.TimeCourse(i) = mean(AA);
            end;
        end;
        if mygui.willFlicker
            if get(MultiPlot,'Value')==1
                if mygui.plfig ==0
                    mygui.plfig=figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:,:))
                end
            else
                mygui.plfig=figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:,:))
            end
            %             figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:))
            figure(mygui.plfig);
            MaxResp=max(mygui.TimeCourse);
            MaxStimu=max(mygui.Stimu2Course);
            Stim=(mygui.Stimu2Course/MaxStimu)*MaxResp;
            x = linspace(0,length(mygui.TimeCourse)/mygui.framerate,length(mygui.TimeCourse));
            if get(MultiPlot,'Value')==1
                plot(mygui.TimeCourse,'k','LineWidth',3)
            else
                plot(mygui.TimeCourse,'r', 'LineWidth',3)
            end
            hold on;
            plot(Stim,'g')
            [mygui.xmax,mygui.imax,mygui.xmin,mygui.imin] = extrema(mygui.TimeCourse);
            copydata(:,1)=mygui.TimeCourse';
            copydata(:,2)=Stim';
            num2clip(copydata);
            mygui.myColor = mygui.myColor+1;
            if mygui.myColor == 13
                mygui.myColor = 2;
            end
            set(PeakButton,'Enable','on');
            
        else
            if get(MultiPlot,'Value')==1
                if mygui.plfig ==0
                    mygui.plfig=figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:,:))
                end
            else
                mygui.plfig=figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:,:))
            end
            %             figure('Name','Time Course');set(gcf,'color',MyBGColor(mygui.myColor,:))
            figure(mygui.plfig);
            [a b] = size(mygui.TPAnfang);
            Stimuli=b/mygui.Repet;
            MyColor=[ 'k';'r'; 'c'; 'm'; 'c'; 'm'; 'y'];
            anmin=mygui.TPAnfang(1)-2;
            zwmin=mygui.TPAnfang(2)-mygui.TPEnde(1)-2;
            anmin=min(anmin,zwmin);
            enmax=mygui.MaxImage-max(mygui.TPEnde)-1;
            enmax=min(enmax,zwmin);
            %                 mygui.Repet=1;
            for lauf = 1 : mygui.Repet
                mygui.xxx(lauf)=mygui.TPAnfang((lauf-1)*Stimuli+1)-anmin;
                mygui.yyy(lauf)=mygui.TPEnde(lauf*Stimuli)+enmax;
                Resp= mygui.TimeCourse(mygui.xxx(lauf):mygui.yyy(lauf));
                Stim= mygui.StimuCourse(mygui.xxx(lauf):mygui.yyy(lauf));
                MaxResp=max(mygui.TimeCourse);
                exc= Stim<10; Stim(exc)=0;
                exc= Stim>10; Stim(exc)=MaxResp;
                if lauf == 1
                    copylange=length(Resp)-1;
                end
                plot(Resp,MyColor(lauf,:))
                hold on;
                plot(Stim,'g')
                MeanResp(:,lauf)= Resp(1:copylange);
            end
            Resp=mean(MeanResp,2);
            plot(Resp,MyBGColor(mygui.myColor,:,:), 'LineWidth',3)
            mygui.myColor = mygui.myColor+1;
            if mygui.myColor == 8
                mygui.myColor = 1;
            end
            copydata(:,1)=Resp(1:copylange)';
            copydata(:,2)=Stim(1:copylange)';
            num2clip(copydata);
        end;
    end
%% DrawRoi

    function ROIButtonChange(h, eventdata) %#ok<INUSD>
        MyBGColor=hsv(12);
        if get(ROIDFFcheckbox,'Value')==1
            axes(PlotA);
        else
            axes(PlotB);
        end;
        h=imfreehand;
        setColor(h,MyBGColor(mygui.myColor,:,:));
        %         setColor(h,'w');
        mygui.Roipos = getPosition(h);
        axes(PlotB);
        line(mygui.Roipos(:,1),mygui.Roipos(:,2),'Color',MyBGColor(mygui.myColor,:,:),'LineWidth',2);
        %         line(mygui.Roipos(:,1),mygui.Roipos(:,2),'Color','w','LineWidth',2);
        mask = createMask(h);
        CalcROI(mask);
    end

%% ROIPOS

    function ROISave(h, eventdata) %#ok<INUSD>
        ROI=mygui.Roipos;
        [pathstr, name, ext] = fileparts(mygui.filename);
        SaveName = fullfile(pathstr,[name '_roi' '.mat']);
        save(SaveName,'ROI','-mat');
    end

    function ROIOpen(h, eventdata) %#ok<INUSD>
        [ROIfilename, ROIpathname] = uigetfile({'*.mat*'},'File Selector');
        Roipos = load(ROIfilename,'ROI');
        axes(PlotA);
        line(Roipos.ROI(:,1),Roipos.ROI(:,2),'Color','white','LineWidth',2);
        axes(PlotB);
        line(Roipos.ROI(:,1),Roipos.ROI(:,2),'Color','white','LineWidth',2);
        mask = poly2mask(Roipos.ROI(:,1), Roipos.ROI(:,2), mygui.info(1,1).Height,mygui.info(1,1).Width);
        CalcROI(mask);
    end

    function SinglePointButtonChange(h, eventdata) %#ok<INUSD>
        mygui.PulseMax1 = [];
        mygui.PulseMax2 = [];
        for i=1:mygui.numFiles
            CalcMyPeaks(i);
            mygui.PulseMax1(i) =mygui.PulseLocalMax(1);
            mygui.PulseMax2(i) =mygui.PulseLocalMax(2);
        end
        figure;
        plot(mygui.PulseMax1,'k');
        hold on
        plot(mygui.PulseMax2,'r');
    end

%% Z-Profiler

    function CalcMyPeaks(Segment)
        mygui.TPAnfang =0;mygui.TPEnde=0;result=0;
        mygui.Stimuli=2;
        dif=diff(mygui.Stimu2Course);
        Maxdif=max(dif);
        Maxdif=Maxdif-(Maxdif*0.5);
        [mxmax,mimax,mxmin,mimin] = extrema(dif);
        realindmax=find(mxmax>Maxdif);
        realindmin=find(mxmin<-Maxdif);
        mygui.repeats=3;
        NoPulse =0;
        nomberofpresentation=3;
        if mimin(realindmin(1))<mimax(realindmax(1))
            for i = 1: nomberofpresentation
                index=((i-1)*mygui.Stimuli )+1;
                mygui.TPAnfang(i)=mimin(realindmin(index));
                mygui.TPEnde(i)=mimax(realindmax(i*mygui.Stimuli));
            end
            
        else
            for i = 1: nomberofpresentation
                index=((i-1)*mygui.Stimuli )+1;
                mygui.TPAnfang(i)=mimax(realindmax(index));
                mygui.TPEnde(i)=mimin(realindmin(i*mygui.Stimuli));
            end
        end
        NoPulse = (length(realindmax)-(6*mygui.numFiles))/(3*mygui.numFiles);
        lauf=1;
        mygui.TPAnfang=mimax(realindmax);
        mygui.TPEnde=mimin(realindmin);
        groesse=round(mygui.TPEnde(1)- mygui.TPAnfang(1)+(mygui.TPAnfang(2)-mygui.TPEnde(1))/2)+30;
        arrlaenge=groesse;
        %          figure('Name',int2str(mygui.Brightness(Segment)));
        figure;
        MyColor=[ 'b';'r'; 'g'];
        for i = 1: mygui.Stimuli
            result=[];
            Stimuresult=[];
            for k = 1: nomberofpresentation
                index=((k-1)*mygui.Stimuli );
                welcher = i+index+(Segment-1)*12;
                if isempty(result)
                    result=mygui.TimeCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    Stimuresult=mygui.StimuCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                else
                    Teilarray=mygui.TimeCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    result=result + Teilarray(1:arrlaenge+1);
                    Teilarray=mygui.StimuCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    Stimuresult=Stimuresult + Teilarray(1:arrlaenge+1);
                end
                hold on
                
            end
            result=result/nomberofpresentation;
            Offset=mean(result(1:3));
            result=result-Offset;
            Stimuresult=Stimuresult/nomberofpresentation;
            plot (result,MyColor(i,:),'LineWidth',2);
            plot (Stimuresult/500);
            mygui.copydata(:,((Segment-1)*4)+i)=result;
            %             copydata(:,i)=result;
            % % % % % % % % %              copydata(:,i)=Stimuresult/500;
            %              num2clip(copydata);
            peak(i)=max(result)- min(result)
            %             peak(i)=(max(result(1:6))- min(result(1:6)))/5;
        end
        pulslaenge=length(result);
        for p = 1: NoPulse
            result=[];
            Stimuresult=[];
            %             figure;
            for k = 1: nomberofpresentation
                welcher = ((p-1)*3)+k+6+(Segment-1)*12;
                if isempty(result)
                    result=mygui.TimeCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    Stimuresult=mygui.StimuCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    %                      plot (result);
                    %                     plot (Stimuresult);
                    hold on
                else
                    Teilarray=mygui.TimeCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    result=result + Teilarray(1:arrlaenge+1);
                    %                       plot (Teilarray(1:arrlaenge+1));
                    Teilarray=mygui.StimuCourse(mygui.TPAnfang(welcher)-2:mygui.TPAnfang(welcher)-2+groesse);
                    %                      plot (Teilarray(1:arrlaenge+1));
                    Stimuresult=Stimuresult + Teilarray(1:arrlaenge+1);
                end
                %                 hold on
                
                
            end
            Puls(p,:)=result/nomberofpresentation;
            %                     plot (result/nomberofpresentation,'LineWidth',3);
            Offset=mean(Puls(p,1:3));
            Puls(p,:)=Puls(p,:)-Offset;
            peak(p+6)=max(Puls(p,:))- min(Puls(p,:));
            mygui.PulseLocalMax(p)=peak(p+6);
            
        end
        if NoPulse > 0
            newExpSeq = zeros(1,85);
            finalIdx=1 + size(Puls(1,:),2) - 1;
            newExpSeq(1:finalIdx)=Puls(1,:);
            for g = 2 : length(mygui.Sequence)
                delta=(g-1)*7;
                for lauf = 1 : 40
                    newExpSeq(lauf+delta)=newExpSeq(lauf+delta)+Puls(g,lauf);
                end;
            end;
            peak(3)=max(newExpSeq)- min(newExpSeq);
            plot(newExpSeq(:),'b');
            mygui.copydata(:,((Segment-1)*4)+3)=mygui.copydata(:,((Segment-1)*4)+1) - newExpSeq(1:pulslaenge)';
            %             copydata(:,3)=copydata(:,1) - newExpSeq(1:pulslaenge)';
            ax=length(mygui.Sequence);
            newExpSeq = zeros(1,85);
            finalIdx=1 + size(Puls(ax,:),2) - 1;
            newExpSeq(1:finalIdx)=Puls(ax,:);
            index=1;
            for g = (ax-1): -1 : 1
                delta=index*7;
                %                 delta=index*4;
                for lauf = 1 : 40
                    newExpSeq(lauf+delta)=newExpSeq(lauf+delta)+Puls(g,lauf);
                end;
                index = index +1;
            end;
            peak(4)=max(newExpSeq)- min(newExpSeq);
            plot(newExpSeq(:),'r');
            peak(5)=peak(1)/peak(3);
            peak(6)=peak(2)/peak(4);
        end
        mygui.copydata(:,((Segment-1)*4)+4)=mygui.copydata(:,((Segment-1)*4)+2) - newExpSeq(1:pulslaenge)';
        %             copydata(:,4)=copydata(:,2) - newExpSeq(1:pulslaenge)';
        %         for i = 1:4
        %            MeanWerte(i)= mean(((Segment-1)*4)+copydata(15:30,i));
        %         end
        %         num2clip(MeanWerte);
        num2clip(mygui.copydata);
        % % % % % % % % %          num2clip(peak');
        mygui.peak=peak;
        %         figure;
        %         mycolor=['k','r','k','r','k','r'];
        %         %         bar(peak);
        %         subplot(2,1,1)
        %         coloredbar(peak(1:6),mycolor);
        %         subplot(2,1,2)
        %         bar(peak(7:end));
    end

%% Average Frames
    function AverageRowButtonChange(h, eventdata) %#ok<INUSD>
        Img(:,:,1)=mygui.DFF(:,:,1);
        mygui.repeats=3;
        if mygui.will3Dot
            stimuli = mygui.diffStimuli;
            nomberofpresentation = length(mygui.TPAnfang)/(stimuli*mygui.stimseq);
            nomberofpresentation =3;
            Spalten=mygui.stimseq;
            Zeilen=stimuli;
            figure
            set(gcf, 'color', 'w');
            picindex=0;
            for yy = 1: stimuli
                for jj = 1: mygui.stimseq
                    k=0;
                    for i = 1: nomberofpresentation
                        Anfang=((i-1)*stimuli*mygui.stimseq)+((yy-1)*mygui.stimseq  )+jj;
                        pos1=mygui.TPAnfang(Anfang)+mygui.DeltaMax-1;
                        pos2=mygui.TPAnfang(Anfang)+mygui.DeltaMin-1;
                        k=k+1;
                        Img(:,:,k)=imsubtract(mygui.DFF(:,:,pos1),mygui.DFF(:,:,pos2));
                    end
                    picindex=picindex+1;
                    BB=mean(Img(:,:,1:k),3);
                    subplottight(Zeilen,Spalten,picindex);
                    imshow(BB,[-0.5 3]);
                    colormap(jet);
                    CC(:,:,picindex)=BB;
                    
                end
            end
            DD=mean(CC(:,:,:),3);
            figure;
            imshow(DD,[-0.2 1]);
            colormap(jet);
        elseif mygui.willDotFlicker
            nomberofpresentation=length(mygui.TPAnfang)/mygui.repeats;
            figure
            set(gcf, 'color', 'w');
            Spalten=5;
            Zeilen=ceil(nomberofpresentation/Spalten);
            niedrigStim = min( mygui.Sequence);
            hochStim = max( mygui.Sequence);
            barindex=0;
            for yy = niedrigStim: hochStim
                k=0; barindex=barindex+1;
                StimPos=find(mygui.Sequence==yy);
                index=((StimPos-1)*mygui.repeats );
                Anfang=((yy-1)*mygui.repeats+1);
                Ende=((yy-1)*mygui.repeats+1);
                Groesse= mygui.TPAnfang(2)-mygui.TPEnde(1);
                Halb=round(Groesse/2);
                for n=1:mygui.repeats
                    aktPos=((StimPos-1)*3)+n;
                    pos1=mygui.TPAnfang(aktPos);
                    pos2=mygui.TPEnde(aktPos);
                    pos3=mygui.TPEnde(aktPos)+Halb;
                    pos4=mygui.TPEnde(aktPos)+Groesse;
                    x=size(mygui.DFF);
                    if pos4 > x(3)
                        pos4=x(3);
                    end;
                    Bild1= mean(mygui.DFF(:,:,pos1:pos2),3);
                    Bild2= mean(mygui.DFF(:,:,pos3:pos4),3);
                    k=k+1;
                    Img(:,:,k)=imsubtract(Bild1,Bild2);
                    %                                            Img(:,:,k)=Bild1;
                    
                end;
                BB=mean(Img(:,:,1:k),3);
                subplottight(Zeilen,Spalten,barindex);
                %             figure('Name',num2str(i))
                imshow(BB,[-0.5 3]);
                colormap(jet);
                CC(:,:,barindex)=BB;
            end;
        else
            mygui.repeats = 3;
            nomberofpresentation=length(mygui.TPAnfang)/mygui.repeats;
            figure
            set(gcf, 'color', 'w');
            Spalten=5;
            Zeilen=ceil(nomberofpresentation/Spalten);
            barindex=0;
            for yy = 1: 2
                %                 if get(willGraphs,'Value')==1
                %                     figure;
                %                 end
                k=0; barindex=barindex+1;
                Groesse= mygui.TPAnfang(2)-mygui.TPEnde(1);
                Halb=round(Groesse/2);
                for n=1:3
                    aktPos=(n-1)*2+yy;
                    pos1=mygui.TPAnfang(aktPos);
                    pos2=mygui.TPEnde(aktPos);
                    pos3=mygui.TPEnde(aktPos)+Halb;
                    pos4=mygui.TPEnde(aktPos)+Groesse;
                    x=size(mygui.DFF);
                    if pos4 > x(3)
                        pos4=x(3);
                    end;
                    Bild1= mean(mygui.DFF(:,:,pos1:pos2+5),3);
                    %                      Bild2= mean(mygui.DFF(:,:,pos3:pos4),3);
                    Bild2= mean(mygui.DFF(:,:,pos4-3:pos4),3);
                    k=k+1;
                    Img(:,:,k)=imsubtract(Bild1,Bild2);
                    %                                            Img(:,:,k)=Bild1;
                    
                end;
                BB=mean(Img(:,:,1:k),3);
                mygui.BB(:,:,yy)= BB;
                subplottight(Zeilen,Spalten,barindex);
                %             figure('Name',num2str(i))
                imshow(BB,[-0.5 3]);
                colormap(jet);
                CC(:,:,barindex)=mygui.BB(yy);
            end;
            for yy = 3: 4
                k=0; barindex=barindex+1;
                Groesse= mygui.TPAnfang(2)-mygui.TPEnde(1);
                Halb=round(Groesse/2);
                for n=1:3
                    aktPos=(n)+yy*2;
                    pos1=mygui.TPAnfang(aktPos);
                    pos2=mygui.TPEnde(aktPos);
                    pos3=mygui.TPEnde(aktPos)+Halb;
                    pos4=mygui.TPEnde(aktPos)+Groesse;
                    x=size(mygui.DFF);
                    if pos4 > x(3)
                        pos4=x(3);
                    end;
                    Bild1= mean(mygui.DFF(:,:,pos1:pos2),3);
                    %                     Bild2= mean(mygui.DFF(:,:,pos3:pos4),3);
                    Bild2= mygui.DFF(:,:,pos4);
                    k=k+1;
                    Img(:,:,k)=imsubtract(Bild1,Bild2);
                    %                                            Img(:,:,k)=Bild1;
                    
                end;
                BB=mean(Img(:,:,1:k),3);
                mygui.BB(:,:,yy)= BB;
                subplottight(Zeilen,Spalten,barindex);
                %             figure('Name',num2str(i))
                imshow(BB,[-0.5 3]);
                colormap(jet);
                CC(:,:,barindex)=mygui.BB(yy);
            end;
            figure('Position',[400 300 400 400])
            Diff=imsubtract(mygui.BB(:,:,1),mygui.BB(:,:,2));
            imshow(Diff,[-0.5 3],'InitialMagnification','fit');
            colormap(jet);
            mygui.BB(:,:,5)= Diff;
            figure('Position',[850 300 400 400])
            Diff=imsubtract(mygui.BB(:,:,2),mygui.BB(:,:,1));
            imshow(Diff,[-0.5 3],'InitialMagnification','fit');
            colormap(jet);
            mygui.BB(:,:,6)= Diff;
        end
    end

%% NEWROI
    function NewROIButtonChange(h, eventdata) %#ok<INUSD>
        StimNo = get(SelStimEdit,'String');
        StimNo=str2num(StimNo);
        BB=mygui.BB(:,:,StimNo);
        figure('Position',[400 300 400 400])
        
        imshow(BB,[-0.5 3],'InitialMagnification','fit');
        colormap(jet);
        MyBGColor=hsv(12);
        h=imfreehand;
        setColor(h,'r');
        mygui.Roipos = getPosition(h);
        axes(PlotB);
        line(mygui.Roipos(:,1),mygui.Roipos(:,2),'Color',MyBGColor(mygui.myColor,:,:),'LineWidth',2);
        mask = createMask(h);
        CalcROI(mask);
    end


%% CalcPeaks
    function PeakButtonChange(h, eventdata) %#ok<INUSD>
        if get(OFF,'Value')==1
            willOFF = 1;
        else
            willOFF = 0;
        end;
        mygui.copydata=[];
        mygui.TPAnfang =0;mygui.TPEnde=0;result=0;
        mygui.repeats=5;
        dif=diff(mygui.Stimu2Course);
        [mxmax,mimax,mxmin,mimin] = extrema(dif);
        difmax=0.2*max(dif);
        realindmax=find(mxmax>difmax);
        realindmin=find(mxmin<-difmax);
        if mod(length(realindmax),5) == 0
            mygui.repeats=5;
        else
            mygui.repeats=3;
            
        end
        mygui.repeats=5;
        if mygui.willAxel || mygui.willSquare
            mygui.repeats=1;
        end
        nomberofpresentation=(length(realindmax)/mygui.repeats);
        %               nomberofpresentation=45;
        if  mygui.willSquare
            nomberofpresentation=nomberofpresentation-1;
        end
        if mimin(realindmin(1))<mimax(realindmax(1))
            for i = 1: nomberofpresentation
                index=((i-1)*mygui.repeats )+1;
                mygui.TPAnfang(i)=mimin(realindmin(index));
                mygui.TPEnde(i)=mimax(realindmax(i*mygui.repeats));
            end
            
        else
            for i = 1: nomberofpresentation
                index=((i-1)*mygui.repeats )+1;
                mygui.TPAnfang(i)=mimax(realindmax(index));
                mygui.TPEnde(i)=mimin(realindmin(i*mygui.repeats));
                %                 mygui.TPEnde(i)=mimin(realindmin(index));
            end
        end
        
        lauf=1;
        mygui.TPAnfang=mimax(realindmax);
        mygui.TPEnde=mimin(realindmin);
        stimuli=nomberofpresentation/3;
        if mygui.framerate < 10
            groesse=( (mygui.TPAnfang(1)-2:mygui.TPEnde(1)))+2;
        else
            a= mygui.TPAnfang(2)-2;
            b=mygui.TPEnde(1);
            groesse=a-b+20;
        end
        oldmax=0;
        if mygui.will3Dot
            a=mygui.TPEnde(1);
            b=mygui.TPAnfang(1);
            %              groesse=a-b+20;
            groesse=50;
            
            mygui.stimseq=3;
            %                 mygui.stimseq=5;
            stimuli = mygui.diffStimuli;
            nomberofpresentation = floor(length(mygui.TPAnfang)/(stimuli*mygui.stimseq))
            peakindex = 0; MeanPeak=0;copyindex = 1;
            niedrigStim = min( mygui.Sequence);
            hochStim = max( mygui.Sequence);
            Puls1result=0;
            for yy = niedrigStim: hochStim
                if mygui.GlobStimInfo.params.dot(yy).bothdotsDuration < 0
                    AddDuration = abs(mygui.GlobStimInfo.params.dot(yy).bothdotsDuration);
                else
                    AddDuration = 0;
                end    ;
                StimDur=mygui.GlobStimInfo.params.dot(yy).dot1Duration+AddDuration;
                shift=round((StimDur*11.6)/66.6);
                StimPos=find(mygui.Sequence==yy);
                for jj = 1: mygui.stimseq
                    result=0; Stimuresult=0;MittelLanege=0;
                    
                    for i = 1: nomberofpresentation
                        index=(StimPos(i)*mygui.stimseq)-mygui.stimseq+jj;
                        LokResult=mygui.TimeCourse(mygui.TPAnfang(index)-2:mygui.TPAnfang(index)+groesse);
                        result=result + mygui.TimeCourse(mygui.TPAnfang(index)-2:mygui.TPAnfang(index)+groesse);
                        Stimuresult=Stimuresult + mygui.StimuCourse(mygui.TPAnfang(index)-2:mygui.TPAnfang(index)+groesse);
                        Maxpeak=max(LokResult)- min(LokResult);
                        Laenge=mygui.TPEnde(index)-mygui.TPAnfang(index);
                        MeanPeak=MeanPeak+Maxpeak;
                        MittelLanege=MittelLanege+Laenge;
                    end
                    if willOFF
                        offset=mean(result(10:20)); % OFF
                    else
                        offset=mean(result(1:4)); %ON
                    end;
                    MittelLanege=MittelLanege/nomberofpresentation;
                    pulsdauer(yy,jj)=(MittelLanege/15)*1000;
                    result=result-offset;
                    result=result/nomberofpresentation;
                    if jj == 2
                        Puls1result = Puls1result+result;
                    end
                    myresult(jj,:)=result;
                    myresult(6,:)=Stimuresult/1000;
                    peakindex = peakindex + 1;
                    if (max(result)- min(result)) > oldmax
                        peaklocmax=find(result == max(result))-2;
                        mygui.DeltaMax=peaklocmax;
                        peaklocmin=find(result == min(result))-2;
                        mygui.DeltaMin=peaklocmin;
                        oldmax = max(result)- min(result);
                    end
                    peak(peakindex)=max(result);%- min(result);
                    MyPeak(peakindex)=MeanPeak/nomberofpresentation;
                    MeanPeak=0;
                end
                newExpSeqPD = zeros(1,85);
                finalIdx=size(myresult(4,:),2) ;
                newExpSeqPD(1:finalIdx)=myresult(4,:);
                for lauf = 1 : finalIdx
                    newExpSeqPD(lauf+shift)=newExpSeqPD(lauf+shift)+myresult(5,lauf);
                    NLPD(lauf)=myresult(1,lauf)-newExpSeqPD(lauf);
                end;
                newExpSeqND = zeros(1,85);
                finalIdx=size(myresult(5,:),2) ;
                newExpSeqND(1:finalIdx)=myresult(5,:);
                for lauf = 1 : finalIdx
                    newExpSeqND(lauf+shift)=newExpSeqND(lauf+shift)+myresult(4,lauf);
                    NLND(lauf)=myresult(2,lauf)-newExpSeqND(lauf);
                end;
                newExpSeqSim = zeros(1,85);
                finalIdx=size(myresult(5,:),2) ;
                newExpSeqSim(1:finalIdx)=myresult(5,:);
                for lauf = 1 : finalIdx
                    newExpSeqSim(lauf)=newExpSeqSim(lauf)+myresult(4,lauf);
                    NLSim(lauf)=myresult(3,lauf)-newExpSeqSim(lauf);
                end;
                if get(willGraphs,'Value')==1
                    figure;
                    %                     plot (myresult(1,:),'b','LineWidth',1);
                    %                     hold on
                    %                     plot (myresult(2,:),'r','LineWidth',1);
                    %                     ylim([-2 2])
                    %                     plot (myresult(4,:),'g','LineWidth',1);
                    %                     hold on
                    %                     plot (myresult(5,:),'c','LineWidth',1);
                    %                     hold on
                    plot (NLPD(:),'b','LineWidth',2);
                    hold on
                    plot (NLND(:),'r','LineWidth',2);
                    hold on
                    plot (NLSim(:),'g','LineWidth',2);
                    hold on
                    %                     plot (myresult(4,:),'k','LineWidth',2);
                    %                     hold on
                    %                     plot (myresult(5,:),'c','LineWidth',1);
                    %                     hold on
                    %                     plot (myresult(6,:),'k','LineWidth',1);
                    %                     hold on
                    %                     plot (myresult(1,:)-myresult(5,:),'k','LineWidth',3);
                    %                     hold on
                    %                     plot (myresult(4,:),'k','LineWidth',2);
                    %                     plot (summedresponse,'b','LineWidth',4);
                    %                     plot (summedresponse2,'r','LineWidth',4);
                    %                      plot (myresult(7,:),'b','LineWidth',1);
                    %                      plot (myresult(9,:),'k','LineWidth',1);
                    %             plot (summedresponse,'r');
                    ylim([-1 1])
                    %                     legend('PD','ND','simu','Puls1');
                    legend('PD','ND');
                    %                                         legend('simu','Puls1','Puls2');
                    %                     legend('ND','simu','PD','Puls');
                    %                     legend('ND','simu','PD','Puls','Sum54','Sum45');
                    title(num2str(yy));
                    
                    %                     figure;
                    %                     myDiffResult1=myresult(2,1:50)-summedresponse(1:50);
                    %                     myDiffResult2=myresult(1,1:50)-summedresponse2(1:50);
                    %                     MyDiffInt(yy,1)=sum(myDiffResult1);
                    %                     MyDiffInt(yy,2)=sum(myDiffResult2);
                    %                     plot (myDiffResult1,'b','LineWidth',2);
                    %                     hold on
                    %                     plot (myDiffResult2,'r','LineWidth',2);
                    %                     ylim([-1 1])
                    %                     title(num2str(yy));
                    
                end
                NLPDAverage=mean(NLPD(15:40));
                NLNDAverage=mean(NLND(15:40));
                %                 mygui.copydata(:,copyindex)=NLPD;
                %                 mygui.copydata(:,copyindex+1)=NLND;
                %                copyindex = copyindex +2;
                mygui.copydata(1,copyindex)=NLPDAverage;
                mygui.copydata(1,copyindex+1)=NLNDAverage;
                copyindex = copyindex +2;
                %                  mygui.copydata(:,copyindex)=NLSim;
                %                  copyindex = copyindex +1;
            end
            Puls1result = Puls1result/stimuli;
            pulsdauer
            
            
            
            
            
            
            
            
            
        elseif    mygui.willAxel
            if get(willGraphs,'Value')==1
                figure;
            end
            a= mygui.TPAnfang(1);
            b=mygui.TPEnde(1);
            groesse=b-a+10;
            niedrigStim = min( mygui.Sequence);
            hochStim = max( mygui.Sequence);
            %             for yy = 1: stimuli
            for i = niedrigStim: hochStim
                
                StimPos=find(mygui.Sequence==i);
                index=(StimPos) ;
                % % % % % % % % % % % % %                 figure;
                
                result= mygui.TimeCourse(mygui.TPAnfang(index)-2:mygui.TPAnfang(index)+groesse);
                result2=mygui.StimuCourse(mygui.TPAnfang(index)-2:mygui.TPAnfang(index)+groesse);
                % % % % % % % % % % % % %                      plot(mygui.TimeCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse));
                % % % % % % % % % % % % %                       hold on;
                % % % % % % % % % % % % %                     plot(mygui.StimuCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse)/500);
                offset=mean(result(1:3));
                result=result-offset;
                result2=result2/5000;
                if get(willGraphs,'Value')==1
                    plot(result);
                    hold on;
                end
                peak(i)=max(result);
                mygui.logfile(i,:)=result2;
            end
            mygui.peak=peak;
            if (hochStim-niedrigStim) < 100
                sens(1)=peak(8);
                sens(2)=peak(4);
                sens(3)=peak(2);
                sens(4)=peak(1);
                figure;
                bar(sens);
            else
                sens(1)=peak(8);
                sens(2)=(peak(64)+peak(4))/2;
                sens(3)=(peak(32)+peak(2))/2;
                sens(4)=(peak(16)+peak(1))/2;
                figure;
                bar(sens);
                
                xx=1;
                for ii=1:7
                    sens(xx)=peak(ii);
                    sens(xx+1)=peak(ii*16);
                    sens(xx+2)=0;
                    xx=xx+3;
                end
                figure;
                bar(sens);
            end
        elseif mygui.willSquare
            a= mygui.TPAnfang(1);
            b=mygui.TPEnde(1);
            groesse=b-a+10;
            nomberofpresentation = length(mygui.TPAnfang)
            for i = 1: nomberofpresentation-1
                
                % % % % % % % % % % % % %                 figure;
                
                result= mygui.TimeCourse(mygui.TPAnfang(i)-2:mygui.TPAnfang(i)+groesse);
                result2=mygui.StimuCourse(mygui.TPAnfang(i)-2:mygui.TPAnfang(i)+groesse);
                % % % % % % % % % % % % %                      plot(mygui.TimeCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse));
                % % % % % % % % % % % % %                       hold on;
                % % % % % % % % % % % % %                     plot(mygui.StimuCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse)/500);
                offset=mean(result(1:3));
                result=result-offset;
                result2=result2/5000;
                peak(i)=max(result);
            end
            for i = 1: floor(length(peak)/2)
                j=i*2;
                quot(i) = peak(j-1)/peak(j);
            end
            %             peak=quot;
            mygui.peak=peak;
            
            
        elseif mygui.willDotFlicker
            a= mygui.TPAnfang(1)-2;
            b=mygui.TPEnde(1);
            groesse=(b-a)+40;
            mygui.repeats=3;
            nomberofpresentation=round((length(realindmax)/mygui.repeats))
            niedrigStim = min( mygui.Sequence);
            hochStim = max( mygui.Sequence);
            MyBGColor=jet(30);
            myColor=1;
            mygui.myColor=1;
            barindex=0;
            if get(willGraphs,'Value')==1
                figure;
                %                     mygui.myColor=1;
            end
            for yy = niedrigStim: hochStim
                barindex=barindex+1;
                StimPos=find(mygui.Sequence==yy);
                index=((StimPos-1)*mygui.repeats );
                result=0;
                result2=0;
                indpeak=0;
                % % % % % % % % % % % % %                 figure;
                for k = 1: mygui.repeats
                    test=mygui.TimeCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse);
                    %                      offset=mean(test(10:20));  %OFF
                    offset=mean(test(1:3)); %ON
                    test=test-offset;
                    indpeak=indpeak+max(test);
                    result=result + test;
                    result2=mygui.StimuCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse);
                end
                if willOFF
                    offset=mean(result(10:20)); % OFF
                else
                    offset=mean(result(1:4)); %ON
                end;
                result=result-offset;
                result=result/mygui.repeats;
                result2=result2/200;
                logfile(yy,:)=result;
                indpeak=indpeak/3;
                if get(willGraphs,'Value')==1
                    plot(result,'Color',MyBGColor(myColor,:,:));
                    hold on;
                    plot(result2,'Color',MyBGColor(myColor,:,:));
                    myColor=myColor+1;
                    
                end
                if (max(result)- min(result)) > oldmax
                    xx=  mygui.TPAnfang(1+index)-2;
                    peaklocmax=find(result == max(result))-2
                    mygui.DeltaMax=peaklocmax;
                    peaklocmin=find(result == min(result))-2
                    mygui.DeltaMin=peaklocmin;
                    oldmax = max(result)- min(result);
                end
                peak(barindex)=max(result);
            end
        else
            a= mygui.TPAnfang(1)-2;
            b=mygui.TPEnde(1);
            groesse=b-a+50;
            mygui.repeats=3;
            nomberofpresentation=round((length(realindmax)/mygui.repeats))
            if get(willGraphs,'Value')==1
                figure;
            end
            for i = 1:nomberofpresentation
                
                index=((i-1)*mygui.repeats );
                result=0;
                result2=0;
                indpeak=0;
                % % % % % % % % % % % % %                 figure;
                for k = 1: mygui.repeats
                    test=mygui.TimeCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse);
                    %                     offset=mean(test(10:20));  %OFF
                    offset=mean(test(1:3)); %ON
                    test=test-offset;
                    indpeak=indpeak+max(test);
                    result=result + test;
                    result2=mygui.StimuCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse);
                    %                     plot(test);
                    %                     hold on;
                    %                     plot(mygui.StimuCourse(mygui.TPAnfang(k+index)-2:mygui.TPAnfang(k+index)+groesse)/500);
                end
                if willOFF
                    offset=mean(result(10:20)); % OFF
                else
                    offset=mean(result(1:4)); %ON
                end;
                result=result-offset;
                result=result/mygui.repeats;
                result2=result2/200;
                logfile(i,:)=result;
                indpeak=indpeak/3;
                if get(willGraphs,'Value')==1
                    plot(result);
                    hold on;
                    plot(result2);
                    
                end
                if (max(result)- min(result)) > oldmax
                    xx=  mygui.TPAnfang(1+index)-2;
                    peaklocmax=find(result == max(result))-2
                    mygui.DeltaMax=peaklocmax;
                    peaklocmin=find(result == min(result))-2
                    mygui.DeltaMin=peaklocmin;
                    oldmax = max(result)- min(result);
                end
                peak(i)=max(result);
            end
        end
        minmax(1)=max(result);
        minmax(2)=min(result);
        % % % % % % % % % % % % % % % % % % % % % %         num2clip(peak);
        %         num2clip(minmax');
        mygui.peak=peak;
        %             figure;
        %             bar(peak2);
        figure;
        %         bar(peak);
        if mygui.will3Dot
            colorpeak=reshape(peak,[mygui.stimseq,stimuli])';
            %             colorpeak=reshape(MyPeak,[mygui.stimseq,stimuli])';
            bar(colorpeak);
            %             num2clip(colorpeak);
            if get(willGraphs,'Value')==1
                num2clip(mygui.copydata);
                
            else
                num2clip(colorpeak);
            end
        elseif mygui.willSquare
            for i = 1: floor(length(peak)/2)
                j=i*2;
                copydata(i,1)=peak(j-1);
                copydata(i,2)=peak(j);
                bar(j-1,peak(j-1),'r');
                hold on
                bar(j,peak(j),'k');
                hold on
                
            end
            num2clip(copydata);
        else
            bar(peak);
            %                           num2clip(peak');
            if get(willGraphs,'Value')==1
                num2clip(logfile);
            else
                num2clip(peak');
            end
        end
        
    end


%% GUI-Changes

    function FigureButtonChange(h, eventdata) %#ok<INUSD>
        f1=figure;
        s = copyobj(PlotA,f1);
        %         axis off; box off; axis equal;
        get(s,'Position')
        set(s,'Position',[0 0 1 1]);
        set(gcf, 'color', 'w');
        f2=figure;
        s = copyobj(PlotB,f2);
        get(s,'Position')
        set(s,'Position',[0.01 0.01 1 1]);
        set(gcf, 'color', 'w');
        
    end

    function OverlayButtonChange(h, eventdata) %#ok<INUSD>
    end

    function RawSliderChange(h, eventdata)
        val=get(h,'Value');
        set(mySliderText,'String',num2str(val));
        set(mySlider,'Max',mygui.MaxImage);
        set(mySlider,'SliderStep',[1/(mygui.MaxImage-1) 10/(mygui.MaxImage-1)]);
        mygui.ImageNo=round(val);
        imshow(mygui.movie1(:,:,mygui.ImageNo),[0 2000]);
        colormap(gray);  axis off;
    end

    function DFFSliderChange(h, eventdata)
        val=get(h,'Value');
        set(mySliderText,'String',num2str(val));
        set(mySlider,'Max',mygui.MaxImage);
        set(mySlider,'SliderStep',[1/(mygui.MaxImage-1) 10/(mygui.MaxImage-1)]);
        mygui.ImageNo=round(val);
        axes(PlotA); imshow( mygui.DFF(:,:,mygui.ImageNo),[mygui.DFFmin mygui.DFFmax],'Colormap',jet);
    end

    function LSButtonChange(h, eventdata) %#ok<INUSD>
        mygui.LStimeCourse=[];
        mygui.LSStimuCourse=[];
        Xan=round( min(mygui.Roipos(:,1)));
        Xen=round(max(mygui.Roipos(:,1)));
        Yan= round(min(mygui.Roipos(:,2)));
        Yen=round(max(mygui.Roipos(:,2)));
        for j = 1: mygui.MaxImage
            %                 b=mean(mygui.DFF(:,Yan:Yen,j),2)*100;
            b=mean(mygui.movie1(:,:,j),2);
            mygui.LStimeCourse=vertcat(mygui.LStimeCourse,b);
            c=mean(mygui.movie2(:,:,j),2);
            mygui.LSStimuCourse=vertcat(mygui.LSStimuCourse,c);
        end
        figure;
        plot(mygui.LStimeCourse);
        hold on;
        plot(mygui.LSStimuCourse/100,'r')
        mydiff=diff(mygui.LSStimuCourse);
        hold off
        %         copydata(:,1)=mygui.LSStimuCourse';
        %         copydata(:,2)=mygui.LStimeCourse';
        %         num2clip(copydata);
        if mygui.will3Dot
            mygui.TPAnfang =0;mygui.TPEnde=0;
            mygui.repeats=5;
            dif=diff(mygui.LSStimuCourse);
            [mxmax,mimax,mxmin,mimin] = extrema(dif);
            realindmax=find(mxmax>10000);
            realindmin=find(mxmin<-10000);
            if mod(length(realindmax),5) == 0
                mygui.repeats=5;
            else
                mygui.repeats=3;
            end
            mygui.repeats=3;
            nomberofpresentation=(length(realindmax)/mygui.repeats);
            %             nomberofpresentation=24;
            if mimin(realindmin(1))<mimax(realindmax(1))
                for i = 1: nomberofpresentation
                    index=((i-1)*mygui.repeats )+1;
                    mygui.TPAnfang(i)=mimin(realindmin(index));
                    mygui.TPEnde(i)=mimax(realindmax(i*mygui.repeats));
                end
                
            else
                for i = 1: nomberofpresentation
                    index=((i-1)*mygui.repeats )+1;
                    mygui.TPAnfang(i)=mimax(realindmax(index));
                    mygui.TPEnde(i)=mimin(realindmin(i*mygui.repeats));
                end
            end
            
            mygui.TPAnfang=mimax(realindmax);
            mygui.TPEnde=mimin(realindmin);
            groesse=1500;
            stimseq=3;
            stimuli = mygui.diffStimuli;
            nomberofpresentation = length(mygui.TPAnfang)/(stimuli*stimseq);
            nomberofpresentation =1;
            result=0;
            for yy = 1: stimuli
                figure;
                for jj = 1: stimseq
                    for i = 1: nomberofpresentation
                        index=((i-1)*stimuli*stimseq)+((yy-1)*stimseq  )+jj;
                        a=mygui.TPAnfang(index);
                        result=result + mygui.LStimeCourse(mygui.TPAnfang(index)-100:mygui.TPAnfang(index)+groesse);
                    end
                    result=result/nomberofpresentation;
                    plot (result);
                    hold on
                    result=0;
                end
            end
        else
            if mygui.LSStimuCourse(1) < 100
                Anfang=find(mydiff<-10000);
            else
                Anfang=find(mydiff>10000);
            end
            r=mygui.LStimeCourse(Anfang(1)-100:Anfang(1)+1900);
            for i=2:10
                r=r+mygui.LStimeCourse(Anfang(i)-100:Anfang(i)+1900);
            end;
            figure;
            plot(r);
            copydata(:,1)=r;
            num2clip(copydata);
        end
    end



    function edittext_Callback(h, eventdata)
        
        max = str2num(get(mymax,'string'));
        min = str2num(get(mymin,'string'));
        axes(PlotB); imshow(mygui.MeanImg,[min max],'Colormap',gray);
    end

    function DFFcheckboxChange(h, eventdata)
        if get(DFFcheckbox,'Value')==1
            set(mySlider,'Callback', {@DFFSliderChange});
        else
            set(mySlider,'Callback', {@RawSliderChange});
        end
    end

    function InfoButtonChange(h, eventdata) %#ok<INUSD>
        StimInfo=open(mygui.MatFilename);
        names=fieldnames(StimInfo.params);
        mystr = {};
        if isfield(StimInfo.params,'dot')
            names=fieldnames(StimInfo.params.dot);
            for k=1:length(names)
                mystr{end+1} = sprintf([names{k} ':   '  num2str(StimInfo.params.dot.(names{k}))]);
            end
            msgbox(mystr,'Dot-Info');
            
        else
            for k=4:length(names)
                mystr{end+1} = sprintf([names{k} ':   '  num2str(StimInfo.params.(names{k}))]);
            end
            msgbox(mystr,'Stim-Info');
        end
    end




    function ShowStimButtonChange(h, eventdata) %#ok<INUSD>
        
        MyBGColor=hsv(12);
        %         StimInfo=open(mygui.MatFilename);
        StimInfo=mygui.GlobStimInfo;
        myFileDate=dir(mygui.MatFilename);
        myFileDate=myFileDate.datenum;
        A=dir('R:\SingleFacet\Calibration\grid\*.mat');
        [~,idx] = sort([A.datenum]);
        for i =1 : length(A)
            if myFileDate >  A(idx(i)).datenum
                CalibFile = A(idx(i)).name;
            end
        end
        CalibFile
        Stim=load(fullfile('R:\SingleFacet\Calibration\grid',CalibFile));
        xgrid = Stim.xgrid;
        ygrid = Stim.ygrid;
        xvals = Stim.xvals;
        yvals = Stim.yvals;
        if exist(StimInfo.params.retinaFileName,'file')
            StimInfo.params.retinaFileName
            SfFig = imread(StimInfo.params.retinaFileName,'BMP');
            info=imfinfo(StimInfo.params.retinaFileName);
            if info.BitDepth > 8
                SfFig=rgb2gray(SfFig);
            end
            if  isfield(mygui,'StimFig') && ishandle(mygui.StimFig) && get(NewRet,'Value')==0
                figure(mygui.StimFig)
            else
                mygui.StimFig=figure;
                pout_adapthisteq = adapthisteq(SfFig,'NumTiles',[16 16]);
                pout_adapthisteq = wiener2(pout_adapthisteq,[10 10]);
                %                 pout_adapthisteq=imtophat(pout_adapthisteq,strel('disk',200));
                pout_adapthisteq = imadjust(pout_adapthisteq);
                imshow(pout_adapthisteq,'Border','tight','InitialMagnification','fit');
                colormap(gray);
            end
            axis equal
            axis off;
            axis image
            set(gcf, 'color', 'w');
            
            
            %prepare circle plot
            ang = 0:0.01:2*pi;
            xcirc = cos(ang);
            ycirc = sin(ang);
            
            
            dot1_p_hdl = [];
            dot1_c_hdl = [];
            
            dot2_p_hdl = [];
            dot2_c_hdl = [];
            
            
            if isfield(StimInfo.params,'groupSequence')
                Repet = length(StimInfo.params.dot);
                NumGroups=0;
                for x = 1:length(StimInfo.params.groupSequence)
                    if ~isempty(StimInfo.params.groupSequence{x})
                        %                         StimInfo.params.groupSequence{x}'
                        NumGroups=NumGroups+1;
                    end
                end
                figure;
                for PlotGroups = 1 : NumGroups
                    Stimuli=StimInfo.params.groupSequence{PlotGroups}';
                    subplottight(3,3,PlotGroups);
                    imshow(pout_adapthisteq,'Border','tight','InitialMagnification','fit');
                    colormap(gray);
                    for dotNo=1: length(Stimuli)
                        AktDot=Stimuli(dotNo);
                        point1 = [StimInfo.params.dot(AktDot).x(1) StimInfo.params.dot(AktDot).y(1)];
                        size1 = StimInfo.params.dot(AktDot).s(1);    %Original dot size
                        hotmap = colormap(jet);  colormap(gray)
                        if AktDot ==1
                            color1 = 'g';
                        else
                            color1 = 'r';
                            
                        end
                        size1=15;
                        willtext = 1;
                        radius1 = size1/2;
                        sf1_x = interp1(Stim.xvals,Stim.xgrid,point1(1,1),'linear','extrap');
                        sf1_y = interp1(Stim.yvals,Stim.ygrid,point1(1,2),'linear','extrap');
                        r1_x = (interp1(Stim.xvals,Stim.xgrid,point1(1,1)+radius1,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point1(1,1)-radius1,'linear','extrap'))/2;
                        r1_y = (interp1(Stim.yvals,Stim.ygrid,point1(1,2)+radius1,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point1(1,2)-radius1,'linear','extrap'))/2;
                        r1 = (r1_x + r1_y)/2;
                        text(sf1_x,sf1_y,num2str(dotNo),'Color',color1)
                        dot1_c_hdl = line(sf1_x + xcirc*r1,sf1_y + ycirc*r1,'LineWidth',3,...
                            'Color',color1);
                        
                    end
                end
            else
                if isfield(StimInfo.params,'dot')
                    ersterdot=min(StimInfo.params.stimSequence);
                    letzterdot=max(StimInfo.params.stimSequence);
                    for dotNo=ersterdot: letzterdot
                        AktDot= dotNo;
                        point1 = [StimInfo.params.dot(AktDot).x(1) StimInfo.params.dot(AktDot).y(1)];
                        size1 = StimInfo.params.dot(AktDot).s(1);    %Original dot size
                        size1 = 40;    %Original dot size
                        point2 = [StimInfo.params.dot(AktDot).x(2) StimInfo.params.dot(AktDot).y(2)];
                        size2 = StimInfo.params.dot(AktDot).s(2);    %Original dot size
                        hotmap = colormap(jet);  colormap(gray)
                        if isempty (mygui.peak)
                            color1 = 'r';
                            size1=15;
                            size2=0;
                            willtext = 0;
                        else
                            if get(Heat,'Value')==1
                                color1 = hotmap(round((mygui.peak(dotNo)/max(mygui.peak))*size(hotmap,1)),:);
                            else
                                size1=mygui.peak(dotNo)*50;
                                willtext = 1;
                                color1 = MyBGColor(mygui.myColor-1,:,:);
                            end
                        end
                        if size2 >0
                            willPt2=1;
                        else
                            willPt2=0;
                        end
                        willPt2=1;
                        
                        
                        radius1 = size1/2;
                        
                        sf1_x = interp1(Stim.xvals,Stim.xgrid,point1(1,1),'linear','extrap');
                        sf1_y = interp1(Stim.yvals,Stim.ygrid,point1(1,2),'linear','extrap');
                        r1_x = (interp1(Stim.xvals,Stim.xgrid,point1(1,1)+radius1,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point1(1,1)-radius1,'linear','extrap'))/2;
                        r1_y = (interp1(Stim.yvals,Stim.ygrid,point1(1,2)+radius1,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point1(1,2)-radius1,'linear','extrap'))/2;
                        r1 = (r1_x + r1_y)/2;
                        if willPt2
                            radius2 = size2/2;
                            sf2_x = interp1(Stim.xvals,Stim.xgrid,point2(1,1),'linear','extrap');
                            sf2_y = interp1(Stim.yvals,Stim.ygrid,point2(1,2),'linear','extrap');
                            
                            %computed in the x-direction, y-direction, then averaged
                            r2_x = (interp1(Stim.xvals,Stim.xgrid,point2(1,1)+radius2,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point2(1,1)-radius2,'linear','extrap'))/2;
                            r2_y = (interp1(Stim.yvals,Stim.ygrid,point2(1,2)+radius2,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point2(1,2)-radius2,'linear','extrap'))/2;
                            r2 = (r2_x + r2_y)/2;
                        end
                        text(sf1_x-5,sf1_y,num2str(dotNo),'Color',color1)
                        if size1 > 4
                            dot1_c_hdl = line(sf1_x + xcirc*r1,sf1_y + ycirc*r1,'LineWidth',3,...
                                'Color',color1);
                            
                            if willPt2
                                dot2_c_hdl = line(sf2_x + xcirc*r2,sf2_y + ycirc*r2,'LineWidth',3,...
                                    'Color',color1);
                                %                                 if dotNo < 7
                                text(sf2_x,sf2_y,num2str(dotNo),'Color',color1)
                                %                                 end
                            end
                        end
                        
                    end
                else
                    point1 = [StimInfo.params.flashingHPos StimInfo.params.flashingVPos];
                    size1 = StimInfo.params.flashingHSize;
                    radius1 = size1/2;
                    sf1_x = interp1(Stim.xvals,Stim.xgrid,point1(1,1),'linear','extrap');
                    sf1_y = interp1(Stim.yvals,Stim.ygrid,point1(1,2),'linear','extrap');
                    r1_x = (interp1(Stim.xvals,Stim.xgrid,point1(1,1)+radius1,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point1(1,1)-radius1,'linear','extrap'))/2;
                    r1_y = (interp1(Stim.yvals,Stim.ygrid,point1(1,2)+radius1,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point1(1,2)-radius1,'linear','extrap'))/2;
                    r1 = (r1_x + r1_y)/2;
                    dot1_p_hdl = line(sf1_x,sf1_y,'Marker','+','Color','r');
                    dot1_c_hdl = line(sf1_x + xcirc*r1,sf1_y + ycirc*r1,...
                        'Color','r');
                    
                end
            end
        end
    end

    function ShowMaxButtonChange(h, eventdata) %#ok<INUSD>
        MyBGColor=hsv(12);
        StimInfo=open(mygui.MatFilename);
        myFileDate=dir(mygui.MatFilename);
        myFileDate=myFileDate.datenum;
        A=dir('R:\SingleFacet\Calibration\grid\*.mat');
        [~,idx] = sort([A.datenum]);
        for i =1 : length(A)
            if myFileDate >  A(idx(i)).datenum
                CalibFile = A(idx(i)).name;
            end
        end
        Stim=load(fullfile('R:\SingleFacet\Calibration\grid',CalibFile));
        if exist(StimInfo.params.retinaFileName,'file')
            StimInfo.params.retinaFileName
            SfFig = imread(StimInfo.params.retinaFileName,'BMP');
            %             if  isfield(mygui,'StimFig') && ishandle(mygui.StimFig) && get(NewRet,'Value')==0
            info=imfinfo(StimInfo.params.retinaFileName);
            if info.BitDepth > 8
                SfFig=rgb2gray(SfFig);
            end
            if  isfield(mygui,'StimFig') && ishandle(mygui.StimFig)
                figure(mygui.StimFig)
            else
                mygui.StimFig=figure;
                pout_adapthisteq = adapthisteq(SfFig,'NumTiles',[16 16]);
                pout_adapthisteq = wiener2(pout_adapthisteq,[10 10]);
                pout_adapthisteq=imtophat(pout_adapthisteq,strel('disk',200));
                pout_adapthisteq = imadjust(pout_adapthisteq);
                imshow(pout_adapthisteq,'Border','tight','InitialMagnification','fit');
                colormap(gray);
            end
            axis equal
            axis off;
            axis image
            set(gcf, 'color', 'w');
            
            
            %prepare circle plot
            ang = 0:0.01:2*pi;
            xcirc = cos(ang);
            ycirc = sin(ang);
            
            
            dot1_p_hdl = [];
            dot1_c_hdl = [];
            
            dot2_p_hdl = [];
            dot2_c_hdl = [];
            if isfield(StimInfo.params,'dot')
                HighestPeak=max(mygui.peak);
                for dotNo=1: length(StimInfo.params.stimSequence)
                    if mygui.peak(dotNo)== HighestPeak
                        AktDot=StimInfo.params.stimSequence(dotNo);
                        point1 = [StimInfo.params.dot(AktDot).x(1) StimInfo.params.dot(AktDot).y(1)];
                        size1 = StimInfo.params.dot(AktDot).s(1);    %Original dot size
                        hotmap = colormap(jet);  colormap(gray)
                        if get(Heat,'Value')==1
                            color1 = MyBGColor(mygui.myColor-1,:,:);
                        else
                            size1=mygui.peak(dotNo)*50;
                            willtext = 1;
                            %                           color1 = 'r';
                            color1 = MyBGColor(mygui.myColor-1,:,:);
                        end
                        radius1 = size1/2;
                        sf1_x = interp1(Stim.xvals,Stim.xgrid,point1(1,1),'linear','extrap');
                        sf1_y = interp1(Stim.yvals,Stim.ygrid,point1(1,2),'linear','extrap');
                        
                        %computed in the x-direction, y-direction, then averaged
                        r1_x = (interp1(Stim.xvals,Stim.xgrid,point1(1,1)+radius1,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point1(1,1)-radius1,'linear','extrap'))/2;
                        r1_y = (interp1(Stim.yvals,Stim.ygrid,point1(1,2)+radius1,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point1(1,2)-radius1,'linear','extrap'))/2;
                        r1 = (r1_x + r1_y)/2;
                        
                        dot1_c_hdl = line(sf1_x + xcirc*r1,sf1_y + ycirc*r1,'LineWidth',5,...
                            'Color',color1);
                        
                    end
                end
            else
                point1 = [StimInfo.params.flashingHPos StimInfo.params.flashingVPos];
                size1 = StimInfo.params.flashingHSize;
                radius1 = size1/2;
                sf1_x = interp1(Stim.xvals,Stim.xgrid,point1(1,1),'linear','extrap');
                sf1_y = interp1(Stim.yvals,Stim.ygrid,point1(1,2),'linear','extrap');
                
                %computed in the x-direction, y-direction, then averaged
                r1_x = (interp1(Stim.xvals,Stim.xgrid,point1(1,1)+radius1,'linear','extrap')-interp1(Stim.xvals,Stim.xgrid,point1(1,1)-radius1,'linear','extrap'))/2;
                r1_y = (interp1(Stim.yvals,Stim.ygrid,point1(1,2)+radius1,'linear','extrap')-interp1(Stim.yvals,Stim.ygrid,point1(1,2)-radius1,'linear','extrap'))/2;
                r1 = (r1_x + r1_y)/2;
                
                dot1_p_hdl = line(sf1_x,sf1_y,'Marker','+','Color','r');
                dot1_c_hdl = line(sf1_x + xcirc*r1,sf1_y + ycirc*r1,...
                    'Color','r');
                
            end
        end
    end
    function CorrButtonChange(h, eventdata) %#ok<INUSD>
        figure
        hold on
        a=mygui.TimeCourse';
        %          plot(a);
        corrLength=length(a)+length(a)-1;
        ffta=fft(a,corrLength);
        ii=1;
        
        for i=1 : 2 : 63
            jj=1;
            for j=1:2:63
                b(:,1)=squeeze(mygui.DFF(i,j,:));
                b(:,2)=squeeze(mygui.DFF(i+1,j,:));
                b(:,3)=squeeze(mygui.DFF(i,j+1,:));
                b(:,4)=squeeze(mygui.DFF(i+1,j+1,:));
                bm=mean(b,2);
                c=fftshift(ifft(ffta.*conj(fft(bm,corrLength))));
                corrimage(ii,jj)=c(length(a));
                jj=jj+1;
            end
            ii=ii+1;
        end
        imagesc(flipud(corrimage));
        %          colormap(gray);
        colorbar;
        mygui.corrimage=corrimage;
    end
end

