## Figure 6 multipanel ---------------------------------------------------------
source("ggplot2-themes.R")
source("custom_fun.R")
library(ggplot2)
library(gridExtra)

## EdU staining
figure3b_ <- png2ggplot("../data/figure3/EdU_figure_cropped.png") +
    img.theme + coord_fixed(ratio = 1/1.5) + ggtitle("A")

## Sox9 staining
figure3c_ <- png2ggplot("../data/figure3/sox9_figure.png") +
    img.theme + coord_fixed(ratio = 1/1.5) + ggtitle("C")

## dppIV staining
figure3d_ <- png2ggplot("../data/figure3/dppiv_figure.png") +
    img.theme + coord_fixed(ratio = 1/1.75) + ggtitle("D")

layout <- rbind(c(1,1,1,2,2),
                c(1,1,1,2,2),
                c(3,3,3,2,2),
                c(3,3,3,5,5),
                c(4,4,4,5,5),
		c(4,4,4,5,5))

## PDF output
pdf(file = "../figures/figure3/figure3_multipanel.pdf", width = 8000/300, height = 8250/300, onefile = FALSE)
gridExtra::grid.arrange(figure3b, figure3a, figure3c, figure3d, figure3e, layoutmatrix = layout)
dev.off()

## EPS output
ggsave(filename = "../figures/figure3/eps/figure3multipanel.eps", 
       plot = gridExtra::grid.arrange(figure3b, figure3a, figure3c, figure3d, figure3e, layoutmatrix = layout), 
       width = 20, height = 20)

## PNG output
png(filename = "../figures/figure3/figure3multipanel.png", width = 1865, height = 2000)
gridExtra::grid.arrange(figure3b, figure3a, figure3c, figure3d, figure3e, layoutmatrix = layout)
dev.off()
