## plot
library(ggplot2)
source("ggplot2-themes.R")

## hierarchical clustering
dat <- dplyr::select(data.scaled, hr, mean_zscore) %>% tidyr::spread(hr, mean_zscore)
ord <- hclust(dist(dat[,2:5], method = "euclidean"), method = "ward.D")$order

data.scaled$SYMBOL <- factor(data.scaled$SYMBOL, levels = unique(data.scaled$SYMBOL)[ord])

figure3e <- ggplot(data.scaled,
              aes(y = SYMBOL, x = hr)) +
    geom_tile(stat = "identity", aes(fill = mean_zscore)) +
    facet_grid(category ~ ., scales = "free_y", space = "free", switch = "y") +
    scale_fill_distiller(name = "Z-score ", palette = "RdYlBu", direction = -1) +
    scale_y_discrete(position = "right") +
    ylab("") + xlab("") + 
    theme1 + 
    theme(strip.text.y =  element_text(size = 36,
                                       angle = 180, hjust = 1),
          strip.background = element_rect(color = "white", fill = "white", size = 1),
          legend.position = "bottom",
	  legend.title = element_text(size = 32),
	  legend.key.size = unit(2,"cm"),
	  panel.spacing = unit(2, "lines"),
	  panel.border = element_blank()) +
	  
    coord_fixed(ratio = 2) +
    ggtitle("E")

png(filename = "../figures/figure3/figure3e.png", width = 500, height = 1000)
print(figure3e)
dev.off()
ggsave(filename = "../figures/figure3/eps/figure3e.eps", 
plot = figure3e, 
width = 16, height = 16)
