clear all

close all

%%%purpose: determine num DNA copies based on how many fall into all 4
%%%wells

%%%%correction factor based on ACH-2 detection

%corrFactor = 19/72; %%%num int detected/ACH-2 cells used
corrFactor =0.23;
maxCopies = 30;

%%%%prob that DNA copy will go into a well AND be detected
well1 = [0*corrFactor, 0.1*corrFactor]; %%%boundaries

well2 = [0.101*corrFactor, 0.2*corrFactor]; %%%boundaries

well3 = [0.201*corrFactor, 0.3*corrFactor]; %%%boundaries

well4 = [0.301*corrFactor, 0.4*corrFactor]; %%%boundaries

well5 = [0.401*corrFactor, 0.5*corrFactor]; %%%boundaries

well6 = [0.501*corrFactor, 0.6*corrFactor]; %%%boundaries

well7 = [0.601*corrFactor, 0.7*corrFactor]; %%%boundaries

well8 = [0.701*corrFactor, 0.8*corrFactor]; %%%boundaries

well9 = [0.801*corrFactor, 0.9*corrFactor]; %%%boundaries

well10 = [0.901*corrFactor, 1*corrFactor]; %%%boundaries



meanNumberOfViruses = 1:maxCopies;

numCellsDone = 34;

numIterations =numCellsDone;



%index = 3

for numSimulations = 1:100;
    
    

for iteration = 1:numIterations

for index = meanNumberOfViruses
    
    numViruses = poissrnd(index);
    
% %     stdNorm = sqrt(index);
% %     
% %     meanNorm = index;
% %     
% %     
% %     numViruses = round(stdNorm.*randn(1,1) + meanNorm);
    
    
    
    randVect = rand(1, numViruses);
    
   indexes = find(randVect< max(well1));
   
   if numel(indexes)>0
       

       well1virus(index) =1;
       
       randVect(indexes)=[]; %%%%take out indexes so not counted twice
       
   else
       
       well1virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well2));%%%%note any randVect< max(well1)taken out
   
   if numel(indexes)>0
       
      well2virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well2virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well3));
   
   if numel(indexes)>0
       
       well3virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well3virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well4));
   
   if numel(indexes)>0
       
      well4virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well4virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well5));
   
   if numel(indexes)>0
       
      well5virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well5virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well6));
   
   if numel(indexes)>0
       
      well6virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well6virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well7));
   
   if numel(indexes)>0
       
      well7virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well7virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well8));
   
   if numel(indexes)>0
       
      well8virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well8virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well9));
   
   if numel(indexes)>0
       
      well9virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well9virus(index) =0;
       
       
   end
   
   indexes = find(randVect< max(well10));
   
   if numel(indexes)>0
       
      well10virus(index) =1;
       
       %randVect(indexes)=[];
       
   else
       
       well10virus(index) =0;
       
       
   end
   
end


wellMatrix = [well1virus; well2virus; well3virus;...
    well4virus; well5virus; well6virus; well7virus;...
    well8virus; well9virus ;well10virus]; %%%each column is for different mean virus number

sumWells = sum(wellMatrix); %%%%sums all wells for each index, where index = meanNumberOfViruses

sumWellsMatrix(iteration, :)=  sumWells; %%%numIterations =numCellsDone;

end

for count = 1:maxCopies
    
    column = sumWellsMatrix(:, count);
    
    %%%makes hist by finding numbers (later divided by iterations to get
    %%%frequencies, for each outcome, ie 0 wells detected to 10 wells
    %%%detected
    
    indexes10 = find(column ==10);
    indexes9 = find(column ==9);
    indexes8 = find(column ==8);
    indexes7 = find(column ==7);
    indexes6 = find(column ==6);
    indexes5 = find(column ==5);
    indexes4 = find(column ==4);
    indexes3 = find(column ==3);
    indexes2 = find(column ==2);
    indexes1 = find(column ==1);
     indexes0 = find(column ==0);
    
     indexes10vector(count) = numel(indexes10);
     indexes9vector(count) = numel(indexes9);
     indexes8vector(count) = numel(indexes8);
     indexes7vector(count) = numel(indexes7);
     indexes6vector(count) = numel(indexes6);
     indexes5vector(count) = numel(indexes5);
    indexes4vector(count) = numel(indexes4);
    indexes3vector(count) = numel(indexes3);
    indexes2vector(count) = numel(indexes2);
    indexes1vector(count) = numel(indexes1);
     indexes0vector(count) = numel(indexes0);
    
end
    
    matrixNumFilledWells = [indexes0vector; indexes1vector;...
        indexes2vector; indexes3vector; indexes4vector; indexes5vector;...
        indexes6vector; indexes7vector; indexes8vector; indexes9vector; indexes10vector];
    
    matrixFreqFilledWells = matrixNumFilledWells./numIterations;
    
   %%%%Actual results:
   
   noDrugCopies = [2	5	4	4	1	2	1	4	2	5	1	2	5	5	5	1	3	5	3	7	4	1	0	5	5	3	2	0	8	2	2	2	1	7	3	1	5	8	1	5	3	9	2	1	2	3	1	2	4	2	4	4	2	2	3	5	0	2	4	0];
   
   

 noDrugCopiesHist=hist(noDrugCopies, 0:10); %%%11 bins, 0 to10
 


    
    noDrugCopiesFreq=noDrugCopiesHist/numel(noDrugCopies);
 
 
 
 
 for columnData = 1:maxCopies;
     
     columnSim = matrixFreqFilledWells(:, columnData);
     
     colNoDrugCopiesFreq = noDrugCopiesFreq';
     
     
     
     sumResNoDrug = sum((columnSim-colNoDrugCopiesFreq).^2);
     
     
     
     resVectNoDrug(columnData) = sumResNoDrug;
     
      
     
 end
 
 indexMinResNoDrug = find(resVectNoDrug ==min(resVectNoDrug));
 
 
 
 meanNoDrugBestfit = indexMinResNoDrug(1);%%%%note can find two or more minimum values if sum residuals exactly the same
 
 
 
noDrugBestfitVect(numSimulations) = meanNoDrugBestfit;





end
    
 
meanNoDrugAllSim = mean(noDrugBestfitVect) %%%over 100 simulations, 34 cells each

stdNoDrugAllSim = std(noDrugBestfitVect)

% % % meanEFVallSim = mean(EFVBestfitVect)
% % % 
% % % stdEFVallSim = std(EFVBestfitVect)
% % % 
% % % combinedMeans = [meanNoDrugAllSim, meanEFVallSim];
% % % 
% % % combinedStd = [stdNoDrugAllSim, stdEFVallSim];
% % % 
% % % X1 =1:2;
% % % yvector1 = combinedMeans;
% % % E1 = combinedStd;
% % %    
% % %   
% % % 
% % % % Create figure
% % % figure1 = figure;
% % % 
% % % % Create axes
% % % axes1 = axes('Parent',figure1,'XTickLabel',{'',''},'XTick',[1 2],...
% % %     'FontSize',28, 'LineWidth',3);
% % %  axis('square')
% % % xlim(axes1,[0.4 2.6]);
% % % ylim(axes1,[0 27]);
% % % 
% % % box(axes1,'off');
% % % hold(axes1,'all');
% % % 
% % % % Create bar
% % % bar(yvector1,'FaceColor',[1 1 1],'LineWidth',4);
% % % 
% % % % Create errorbar
% % % ha= errorbar(X1,yvector1,E1,'LineStyle','none','LineWidth',3,...
% % %     'Color',[0 0 0]);
% % % %%%%modify error bar caps
% % % hb = get(ha,'children'); 
% % % Xdata = get(hb(2),'Xdata');
% % % temp = 4:3:length(Xdata);
% % % temp(3:3:end) = [];
% % % % xleft and xright contain the indices of the left and right
% % % %  endpoints of the horizontal lines
% % % xleft = temp; xright = temp+1;
% % % % Increase line length by 0.2 units
% % % Xdata(xleft) = Xdata(xleft) - .1;
% % % Xdata(xright) = Xdata(xright) + .1;
% % % set(hb(2),'Xdata',Xdata)
% % % 
% % % cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\optimumLaurelle\fig5-LNwithL100I')
% % % 
% % % xhandle=xlabel('')
% % % yhandle=ylabel('')
% % % 
% % % set(xhandle,'Fontname','Calibri')
% % % set(yhandle,'Fontname','Calibri')
% % % 
% % % saveas(gcf,'barCorrRevCEMInt','meta')
% % % 
% % % [h, p] = ttest2(noDrugBestfitVect,EFVBestfitVect)
