close all;

clear all;

%%%%model with WT NL43 in RevCEM

cd('C:\Alex\SAforBackup\REVISION\rev2Backup6jan18\revisionLJsubFeb18\rawFigEps')

colorTable = [0.2980392156862745 0.4470588235294118 0.6901960784313725;...
 0.3333333333333333 0.6588235294117647 0.40784313725490196;...
 0.7686274509803922 0.3058823529411765 0.3215686274509804;...
 0.5058823529411764 0.447058823529411 0.6980392156862745;...
 0.8 0.7254901960784313 0.4549019607843137;...
 0.39215686274509803 0.7098039215686275 0.803921568627451]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_CellFree_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%each row is one experiment
EFVconcCellFree = [0 2.5 5 10 20 40];

liveInfectedCellFree = [166680	79608	40776	13632	1296	648;...
160080	81816	44928	12528	1368	648;...
133152	71784	32376	10104	792	552];

meanCellFree = mean(liveInfectedCellFree);

stdCellFree = std(liveInfectedCellFree);



for index = 1:numel(liveInfectedCellFree(:, 1))
    
    
TxCellFreeRow = liveInfectedCellFree(index, :)./liveInfectedCellFree(index, 1);

TxCellFree(index, :) = TxCellFreeRow;

end

meanTxCellFree = mean(TxCellFree);

%seTxCellFree = std(TxCellFree)./sqrt(3);

stdTx = std(TxCellFree);

%%%first value always 1, take out of std

TxNoFirst = TxCellFree(:, 2:end);

stdTxNoFirst = std(TxNoFirst);

%%fit to get d
D = EFVconcCellFree;
Tx = meanTxCellFree;

for hIndex = 1:50;
    
    for IC50Index = 1:100;
        
        hill = hIndex/10; %%%varies 0.1 to 5
        IC50 = IC50Index/10; %%%varies 0.1 to 10
        
        for drugConc = 1:numel(D);
        

dParam = 1-(1/(1+(IC50/D(drugConc))^hill));

dParamVect(drugConc) = dParam;

        end
        
        %%%calculate residuals for h, IC50 pair
        
        

%sumResiduals = sum((Tx-dParamVect).^2./(Tx.^2));%%%residuals normalized by experimental value to give deviations similar weight independent of value size 

resVect = Tx(2:end)-dParamVect(2:end);

%sumResiduals = sum((sqrt(((Tx(2:end)-dParamVect(2:end)).^2))).*(1./stdTx(2:end).^2));

sumResiduals = sum((((Tx(2:end)-dParamVect(2:end)).^2)).*(1./stdTx(2:end).^2));

resMatrix(hIndex, IC50Index) = sumResiduals;

resArray{hIndex, IC50Index}=resVect;

    end
    
end


%find minimum residuals
minSumResiduals = min(min(resMatrix));

%%% Find which h and IC50 give minimum residuals 

[rowNum, colNum] = find(resMatrix==minSumResiduals);

bestfitHill = rowNum/10

bestfitIC50 = colNum/10


D2= linspace(0, 40);

TxBestfit = 1-(1./(1+(bestfitIC50./D2).^bestfitHill));

figure1 = figure,
        
         axes1 = axes('Parent',figure1,'XMinorTick','off',...
    'FontSize',22, 'YScale','log', 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000])
   
   axis('square')
   
xlim([-0.5 42])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha= errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

% % % % % % % %%%%modify error bar caps
% % % % % % % hb = get(ha,'children'); 
% % % % % % % Xdata = get(hb(2),'Xdata');
% % % % % % % temp = 4:3:length(Xdata);
% % % % % % % temp(3:3:end) = [];
% % % % % % % % xleft and xright contain the indices of the left and right
% % % % % % % %  endpoints of the horizontal lines
% % % % % % % xleft = temp; xright = temp+1;
% % % % % % % % Increase line length by 0.5 units (absolute x-axis values, will change if x axis scale changes!!!)  
% % % % % % % Xdata(xleft) = Xdata(xleft) - 0.25;
% % % % % % % Xdata(xright) = Xdata(xright) + 0.25;
% % % % % % % set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

 

%cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\revisionLJsubFeb18\rawFigEps')

%print(figure1,'-dpdf','cellFreeRevWtLog.pdf')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeRevWtLog','meta')

hold off

%%%%linear y scale

figure2 = figure,
        
         axes2 = axes('Parent',figure2,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 42])

ylim([0, 1.1])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha= errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 0.5 units
Xdata(xleft) = Xdata(xleft) - 0.25;
Xdata(xright) = Xdata(xright) + 0.25;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%print(figure2,'-dpdf','cellFreeRevWtLin.pdf')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeRevWtLin','meta')

hold off


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Cell-Cell Rev Wt%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



EfvConcCellCell = [0 2 4 8 12 20 40];


liveInfectedCellCell = [69819	174806	214435	216789	147771	62526 44316;...
105368	189849	227677	187593	134949	55395 37611;...
46376	114640	186167	172282	143313	50880 46404];

% % % % normLiveInfectedCellCellRow1 = liveInfectedCellCell(1, :)/max(liveInfectedCellCell(1, :));
% % % % normLiveInfectedCellCellRow2 = liveInfectedCellCell(2, :)/max(liveInfectedCellCell(2, :));
% % % % normLiveInfectedCellCellRow3 = liveInfectedCellCell(3, :)/max(liveInfectedCellCell(3, :));

normLiveInfectedCellCellRow1 = liveInfectedCellCell(1, :); %%%%not normalized!
normLiveInfectedCellCellRow2 = liveInfectedCellCell(2, :);
normLiveInfectedCellCellRow3 = liveInfectedCellCell(3, :);

normLiveInfectedCellCell = [normLiveInfectedCellCellRow1; normLiveInfectedCellCellRow2; normLiveInfectedCellCellRow3];

liveInfectedCellCellMean = mean(normLiveInfectedCellCell);

liveInfectedCellCellStd = std(normLiveInfectedCellCell);



meanIntCorr = 15; %%%number of HIV DNA copies after correction

%%%%calculate d based on cell-free fitted IC50, hill. Note Tx is d for cell
%%%%free infection

dCalc = 1-(1./(1+(bestfitIC50./EfvConcCellCell).^bestfitHill));


for rIndex = 1:100;
    
    r= rIndex/100;
    
    for qIndex = 1:20
        
        q= qIndex/100;

%%%only 6 values - use for fit

%pLiveInfected = (1- (1-r).^(meanIntCorr.*dCalc)).*((1-q).^(meanIntCorr.*dCalc));
pLiveInfected = exp(-(meanIntCorr.*dCalc).*q).*(1-exp(-(meanIntCorr.*dCalc).*r.*(1-q)));
%pLiveInfected =exp(-x*q)*(1-exp(-x*r*(1-q)))
%pLiveInfected = exp(-(meanIntCorr.*dCalc).*q.*r)-exp(-(meanIntCorr.*dCalc)*r);

%%%pLiveInfectedArray{rIndex,qIndex}= pLiveInfected; %%%%stores vector for 6 values in array

pLiveInfectedArray{rIndex,qIndex}= pLiveInfected.*1000000; %%%%stores vector for 6 values in array. 

    end
    
end

%%%%Calculate residuals

%weightForFit = 1./(liveInfectedCellCellStd.^2); %%%1/var

weightForFit = ones(1, numel(liveInfectedCellCellStd)); %%%%even weight

for rIndex = 1:100;
    
    
    
    for qIndex = 1:20
 
calcVect= pLiveInfectedArray{rIndex,qIndex}; 

%%%%calcVectNorm = calcVect./max(calcVect);

calcVectNorm = calcVect; %%%%not normalized


sumResiduals = sum(weightForFit.*sqrt((calcVectNorm-liveInfectedCellCellMean).^2));


sumResidualsMatrix(rIndex, qIndex) = sumResiduals;

    end
    
end

[bestfitRindex, bestfitQindex] = find(sumResidualsMatrix ==min(min(sumResidualsMatrix)));

bestfitR= bestfitRindex/100;

bestfitQ =bestfitQindex/100;

rmsMinResiduals=min(min(sumResidualsMatrix))

%normPliveInfect = pLiveInfected./max(pLiveInfected);

%%%use bestfit param to create smooth fit curve. TxBestfit already
%%%calculated for cell-free

%%%NOTE THIS IS OVER A DRUG RANGE %%%D2= linspace(0, 40); THEREFORE IF MAX pLiveInfectedSmooth AT COLUMN 14, ITS D2(14)

%pLiveInfectedSmooth = (1- (1-bestfitR).^(meanIntCorr.*TxBestfit)).*((1-bestfitQ).^(meanIntCorr.*TxBestfit));
pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ).*(1-exp(-(meanIntCorr.*TxBestfit).*bestfitR.*(1-bestfitQ)));
%pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ.*bestfitR)-exp(-(meanIntCorr.*TxBestfit)*bestfitR);
%normPliveInfect = pLiveInfectedSmooth./max(pLiveInfectedSmooth);

normPliveInfect = pLiveInfectedSmooth.*1000000; %%%%not normalized, instead multiplied by 10^6 to get number infected

%%%%print fitted peak value

indexPeak = find(normPliveInfect==max(normPliveInfect));

EFVfittedPeak = D2(indexPeak)


figure3 = figure,
        
         axes3 = axes('Parent',figure3,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 42])

%%%ylim([0 1.1])
%%%Divide Y by 100000 so as not to have x10^5 on scale
ylim([0 350000./100000])
hold all


X1=EfvConcCellCell;
Y1=liveInfectedCellCellMean;
E1=liveInfectedCellCellStd./sqrt(3);
X2=D2;
Y2=normPliveInfect;

%%%Divide Y by 100000 so as not to have x10^5 on scale
% Create plot
plot(X1,Y1./100000,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1./100000,E1./100000,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 0.5 units - absolute x axis values!!!
Xdata(xleft) = Xdata(xleft) - 0.25;
Xdata(xright) = Xdata(xright) + 0.25;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2./100000,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%print(figure3,'-depsc','cellCellRevWt.eps')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellCellRevWt','meta')

hold on
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%use experimentally determined param 

expR = 0.28

expQ = 0.15;

%pLiveInfectedSmooth = (1- (1-expR).^(meanIntCorr.*TxBestfit)).*((1-expQ).^(meanIntCorr.*TxBestfit));
pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*expQ).*(1-exp(-(meanIntCorr.*TxBestfit).*expR.*(1-expQ)))
%pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*expQ.*expR)-exp(-(meanIntCorr.*TxBestfit)*expR);

%normPliveInfect = pLiveInfectedSmooth./max(pLiveInfectedSmooth);
normPliveInfect = pLiveInfectedSmooth.*1000000; %%%%not normalized, instead multiplied by 10^6 to get number infected

Y2=normPliveInfect;


%%%Divide Y by 100000 so as not to have x10^5 on scale
% Create plot
plot(X2,Y2./100000,...% 'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color', [0.13 0.55 0.13], 'LineStyle', '--');

%print(figure3,'-depsc','cellCellRevWt.eps')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellCellWtNew','meta')

hold off


