close all;

clear all;

%%%%model with WT NL43 in RevCEM

cd('C:\Alex\SAforBackup\REVISION\rev2Backup6jan18\revisionLJsubFeb18\rawFigEps')

colorTable = [0.2980392156862745 0.4470588235294118 0.6901960784313725;...
 0.3333333333333333 0.6588235294117647 0.40784313725490196;...
 0.7686274509803922 0.3058823529411765 0.3215686274509804;...
 0.5058823529411764 0.447058823529411 0.6980392156862745;...
 0.8 0.7254901960784313 0.4549019607843137;...
 0.39215686274509803 0.7098039215686275 0.803921568627451]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_CellFree_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%each row is one experiment
EFVconcCellFree = [0 10 20 40 80 160 320];

liveInfectedCellFree = [180600	173832	110448	71256	37056	7128	1152;...
190080	171000	119424	87600	44592	9576	888;...
221160	171264	126624	71664	44712	8688	1032];

meanCellFree = mean(liveInfectedCellFree);

stdCellFree = std(liveInfectedCellFree);



for index = 1:numel(liveInfectedCellFree(:, 1))
    
    
TxCellFreeRow = liveInfectedCellFree(index, :)./liveInfectedCellFree(index, 1);

TxCellFree(index, :) = TxCellFreeRow;

end

meanTxCellFree = mean(TxCellFree);

%seTxCellFree = std(TxCellFree)./sqrt(3);

stdTx = std(TxCellFree);

%%%first value always 1, take out of std

TxNoFirst = TxCellFree(:, 2:end);

stdTxNoFirst = std(TxNoFirst);

%%fit to get d
D = EFVconcCellFree;
Tx = meanTxCellFree;

for hIndex = 1:50;
    
    for IC50Index = 1:100;
        
        hill = hIndex/10; %%%varies 0.1 to 5
        IC50 = IC50Index; %%%varies 1 to 100
        
        for drugConc = 1:numel(D);
        

dParam = 1-(1/(1+(IC50/D(drugConc))^hill));

dParamVect(drugConc) = dParam;

        end
        
        %%%calculate residuals for h, IC50 pair
        
        

%sumResiduals = sum((Tx-dParamVect).^2./(Tx.^2));%%%residuals normalized by experimental value to give deviations similar weight independent of value size 

resVect = Tx(2:end)-dParamVect(2:end);

sumResiduals = sum(((Tx(2:end)-dParamVect(2:end)).^2).*(1./stdTx(2:end).^2));

resMatrix(hIndex, IC50Index) = sumResiduals;

resArray{hIndex, IC50Index}=resVect;

    end
    
end


%find minimum residuals
minSumResiduals = min(min(resMatrix));

%%% Find which h and IC50 give minimum residuals 

[rowNum, colNum] = find(resMatrix==minSumResiduals);

bestfitHill = rowNum/10

bestfitIC50 = colNum

%  bestfitHill = 1.2;
% bestfitIC50 = 30;

%%%%generate bestfit Tx

%drugConcFit = linspace(min(EFVconcCellFree), max(EFVconcCellFree));

%drugConcFit = EFVconcCellFree;

%%%TxBestfit = 1-(1./(1+(bestfitIC50./(drugConcFit.^bestfitHill))));

D2= linspace(0, 320);

TxBestfit = 1-(1./(1+(bestfitIC50./D2).^bestfitHill));

figure1 = figure,
        
         axes1 = axes('Parent',figure1,'XMinorTick','off',...
    'FontSize',22, 'YScale','log', 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000])
   
   axis('square')
   
xlim([-0.5 325])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 4 units. Absolute x values, so depends on plot
% x-axis!
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);


%cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\revisionLJsubFeb18\rawFigEps')

%print(figure1,'-dpdf','cellFreeRevWtLog.pdf')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeMtLog','meta')

hold off




%%%%linear y scale

figure2 = figure,
        
         axes2 = axes('Parent',figure2,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 325])

ylim([0, 1.1])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 4 units
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%print(figure2,'-dpdf','cellFreeRevWtLin.pdf')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeMtLin','meta')



hold off


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Cell-Cell Rev Mt%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EfvConcCellCell = [0 20 40 80 160 320];

%EfvConcCellCell = [0 20 40 60 80 100 120 160 200 240];

EfvConcCellCell = [0 20 40 60 80 100 120 160];

%EfvConcCellCell = [0 20 40 60 80 100 120 160 240];

% liveInfectedCellCell = [97711	252383	295853	325283	230648	114210;...
% 88043	149400	266805	264774	265401	126203;...
% 97548	209925	226305	255105	143415	76877];

% liveInfectedCellCell = [131520	322773	319902	279677	268658	224935	204366	166520	160308	136307
% 119048	378125	420198	236674	223747	164477	205344	152674	146501	139036
% 103803	351533	382680	333734	270250	267360	216309	178956	174164	178598];

liveInfectedCellCell = [131520	322773	319902	279677	268658	224935	204366	166520;...
119048	378125	420198	236674	223747	164477	205344	152674;...	
103803	351533	382680	333734	270250	267360	216309	178956];

% liveInfectedCellCell = [131520	322773	319902	279677	268658	224935	204366	166520 136307;...
% 119048	378125	420198	236674	223747	164477	205344	152674 139036;...	
% 103803	351533	382680	333734	270250	267360	216309	178956 178598];


% % % normLiveInfectedCellCellRow1 = liveInfectedCellCell(1, :)/max(liveInfectedCellCell(1, :));
% % % normLiveInfectedCellCellRow2 = liveInfectedCellCell(2, :)/max(liveInfectedCellCell(2, :));
% % % normLiveInfectedCellCellRow3 = liveInfectedCellCell(3, :)/max(liveInfectedCellCell(3, :));

normLiveInfectedCellCellRow1 = liveInfectedCellCell(1, :); %%%%not normalized!
normLiveInfectedCellCellRow2 = liveInfectedCellCell(2, :);
normLiveInfectedCellCellRow3 = liveInfectedCellCell(3, :);

normLiveInfectedCellCell = [normLiveInfectedCellCellRow1; normLiveInfectedCellCellRow2; normLiveInfectedCellCellRow3];

liveInfectedCellCellMean = mean(normLiveInfectedCellCell);

liveInfectedCellCellStd = std(normLiveInfectedCellCell);


meanIntCorr = 15; %%%number of HIV DNA copies after correction

%%%%calculate d based on cell-free fitted IC50, hill. Note Tx is d for cell
%%%%free infection

dCalc = 1-(1./(1+(bestfitIC50./EfvConcCellCell).^bestfitHill));


for rIndex = 1:100;
    
    r= rIndex/100;
    
    
    
    for qIndex = 1:20
        
        q= qIndex/100;

%%%only 6 values - use for fit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%pLiveInfected = (1- (1-r).^(meanIntCorr.*dCalc)).*((1-q).^(meanIntCorr.*dCalc));
pLiveInfected = exp(-(meanIntCorr.*dCalc).*q).*(1-exp(-(meanIntCorr.*dCalc).*r.*(1-q)));
%pLiveInfected = exp(-(meanIntCorr.*dCalc).*q.*r)-exp(-(meanIntCorr.*dCalc)*r);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pLiveInfectedArray{rIndex,qIndex}= pLiveInfected.*1000000; %%%%stores vector for 6 values in array. 
%%%Multiplied by 10^6 since that is the input number of cells. Hence output is predicted number of infected cells

    end
    
end

%%%%Calculate residuals

%weightForFit = 1./(liveInfectedCellCellStd.^2); %%%1/var

weightForFit = ones(1, numel(liveInfectedCellCellStd)); %%%%even weight

for rIndex = 1:100;
    
    
    
    for qIndex = 1:20
 
calcVect= pLiveInfectedArray{rIndex,qIndex}; 

%calcVectNorm = calcVect./max(calcVect);

calcVectNorm = calcVect; %%%%not normalized


sumResiduals = sum(weightForFit.*sqrt((calcVectNorm-liveInfectedCellCellMean).^2));

sumResidualsMatrix(rIndex, qIndex) = sumResiduals;

    end
    
end

[bestfitRindex, bestfitQindex] = find(sumResidualsMatrix ==min(min(sumResidualsMatrix)));

bestfitR= bestfitRindex/100;

bestfitQ =bestfitQindex/100;

rmsMinResiduals=min(min(sumResidualsMatrix))



%normPliveInfect = pLiveInfected./max(pLiveInfected);
%  bestfitQ =0.14;
%  bestfitR =0.24;

%%%use bestfit param to create smooth fit curve. TxBestfit already
%%%calculated for cell-free
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%pLiveInfectedSmooth = (1- (1-bestfitR).^(meanIntCorr.*TxBestfit)).*((1-bestfitQ).^(meanIntCorr.*TxBestfit));
pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ).*(1-exp(-(meanIntCorr.*TxBestfit).*bestfitR.*(1-bestfitQ)))
%pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ.*bestfitR)-exp(-(meanIntCorr.*TxBestfit)*bestfitR);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%normPliveInfect = pLiveInfectedSmooth./max(pLiveInfectedSmooth);

normPliveInfect = pLiveInfectedSmooth.*1000000; %%%%not normalized, instead multiplied by 10^6 to get number infected

EFVatPeak = D2(find(pLiveInfectedSmooth==max(pLiveInfectedSmooth)))

figure3 = figure;
        
         axes3 = axes('Parent',figure3,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 170])

%%%Divide Y by 100000 so as not to have x10^5 on scale
ylim([0 405000./100000])
hold all

 
X1=EfvConcCellCell;
Y1=liveInfectedCellCellMean;
E1=liveInfectedCellCellStd./sqrt(3);
X2=D2;
Y2=normPliveInfect;


%%%Divide Y by 100000 so as not to have x10^5 on scale
% Create plot
plot(X1,Y1./100000,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1./100000,E1./100000,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 0.2 units
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2./100000,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%print(figure3,'-depsc','cellCellRevWt.eps')


%%%use experimentally determined param 

expR = 0.28;

expQ = 0.15;

%pLiveInfectedSmooth = (1- (1-expR).^(meanIntCorr.*TxBestfit)).*((1-expQ).^(meanIntCorr.*TxBestfit));
pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*expQ).*(1-exp(-(meanIntCorr.*TxBestfit).*expR.*(1-expQ)));
%pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*expQ.*expR)-exp(-(meanIntCorr.*TxBestfit)*expR);
%%%normPliveInfect = pLiveInfectedSmooth./max(pLiveInfectedSmooth);

normPliveInfect = pLiveInfectedSmooth.*1000000; %%%%not normalized, instead multiplied by 10^6 to get number infected



Y2=normPliveInfect;



% Create plot. Divide Y2 by 100000 so as not to have x10^5 on scale
plot(X2,Y2./100000,...% 'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color', [0.13 0.55 0.13], 'LineStyle', '--');

%print(figure3,'-depsc','cellCellRevWt.eps')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('');
yhandle=ylabel('');

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellCellMt','meta')

hold off








