clear all

close all

%%%purpose: determine num DNA copies based on how many fall into all 4
%%%wells

%%%%correction factor based on ACH-2 detection

corrFactor = 19/72; %%%num int detected/ACH-2 cells used

maxCopies = 30;

%%%%prob that DNA copy will go into a well AND be detected
well1 = [0*corrFactor, 0.25*corrFactor]; %%%boundaries

well2 = [0.251*corrFactor, 0.5*corrFactor]; %%%boundaries

well3 = [0.501*corrFactor, 0.75*corrFactor]; %%%boundaries

well4 = [0.751*corrFactor, 1*corrFactor]; %%%boundaries

meanNumberOfViruses = 1:maxCopies;

numCellsDone = 56;

numIterations =numCellsDone;



%index = 3

for numSimulations = 1:10;
    
    

for iteration = 1:numIterations

for index = meanNumberOfViruses
    
    numViruses = poissrnd(index);
    
% %     stdNorm = sqrt(index);
% %     
% %     meanNorm = index;
% %     
% %     
% %     numViruses = round(stdNorm.*randn(1,1) + meanNorm);
    
    
    
    randVect = rand(1, numViruses);
    
   indexes = find(randVect< max(well1));
   
   if numel(indexes)>0
       

       well1virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well1virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well2));
   
   if numel(indexes)>0
       
      well2virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well2virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well3));
   
   if numel(indexes)>0
       
       well3virus(index) =1;
       
       randVect(indexes)=[];
       
   else
       
       well3virus(index) =0;
       
   end
   
   indexes = find(randVect< max(well4));
   
   if numel(indexes)>0
       
      well4virus(index) =1;
       
       %randVect(indexes)=[];
       
   else
       
       well4virus(index) =0;
       
       
   end
   
   
end


wellMatrix = [well1virus; well2virus; well3virus; well4virus];

sumWells = sum(wellMatrix);

sumWellsMatrix(iteration, :)=  sumWells;

end

for count = 1:maxCopies
    
    column = sumWellsMatrix(:, count);
    
    indexes4 = find(column ==4);
    indexes3 = find(column ==3);
    indexes2 = find(column ==2);
    indexes1 = find(column ==1);
     indexes0 = find(column ==0);
    
    indexes4vector(count) = numel(indexes4);
    indexes3vector(count) = numel(indexes3);
    indexes2vector(count) = numel(indexes2);
    indexes1vector(count) = numel(indexes1);
     indexes0vector(count) = numel(indexes0);
    
end
    
    matrixNumFilledWells = [indexes0vector; indexes1vector; indexes2vector; indexes3vector; indexes4vector];
    
    matrixFreqFilledWells = matrixNumFilledWells./numIterations;
    
   %%%%Actual results:
   
   noDrugCopies = [1	4	2	1	0	2	2	3	2	4	4	4	3	4	2	4	3	3	2	3	3	4	4	4	4	4	3	3	3	3	4	2	0	4	1	1	1	4	4	4	4	3	4	2	2	4	1	1	0	0	2	1	4	1	2	4];
   
   EFVcopies = [0	1	1	0	1	1	3	3	0	4	0	0	0	1	3	0	0	1	3	1	2	3	0	0	0	0	0	0	3	0	3	4	3	4	2	0	2	1	4	4	0	3	0	2	3	3	3	0	1	2	0	3	3	4	2 0];

 noDrugCopiesHist=hist(noDrugCopies, 5);
 
 EFVcopiesHist=hist(EFVcopies, 5);

    
    noDrugCopiesFreq=noDrugCopiesHist/numel(noDrugCopies);
 
 EFVcopiesFreq=EFVcopiesHist/numel(EFVcopies);
 
 
 for columnData = 1:maxCopies;
     
     columnSim = matrixFreqFilledWells(:, columnData);
     
     colNoDrugCopiesFreq = noDrugCopiesFreq';
     
     colEFVCopiesFreq = EFVcopiesFreq';
     
     sumResNoDrug = sum((columnSim-colNoDrugCopiesFreq).^2);
     
     sumResEFV = sum((columnSim-colEFVCopiesFreq).^2);
     
     resVectNoDrug(columnData) = sumResNoDrug;
     
      resVectEFV(columnData) = sumResEFV;
     
 end
 
 indexMinResNoDrug = find(resVectNoDrug ==min(resVectNoDrug));
 
 indexMinResEFV = find(resVectEFV ==min(resVectEFV));
 
 meanNoDrugBestfit = indexMinResNoDrug(1);%%%%note can find two or more minimum values if sum residuals exactly the same
 
 meanEFVBestfit = indexMinResEFV(1);
 
noDrugBestfitVect(numSimulations) = meanNoDrugBestfit;

EFVBestfitVect(numSimulations) = meanEFVBestfit;



end
    
 
meanNoDrugAllSim = mean(noDrugBestfitVect)

stdNoDrugAllSim = std(noDrugBestfitVect)

meanEFVallSim = mean(EFVBestfitVect)

stdEFVallSim = std(EFVBestfitVect)

combinedMeans = [meanNoDrugAllSim, meanEFVallSim];

combinedStd = [stdNoDrugAllSim, stdEFVallSim];

X1 =1:2;
yvector1 = combinedMeans;
E1 = combinedStd;
   
  

% Create figure
figure1 = figure;

% Create axes
axes1 = axes('Parent',figure1,'XTickLabel',{'',''},'XTick',[1 2],...
    'FontSize',28, 'LineWidth',3);
 axis('square')
xlim(axes1,[0.4 2.6]);
ylim(axes1,[0 27]);

box(axes1,'off');
hold(axes1,'all');

% Create bar
bar(yvector1,'FaceColor',[1 1 1],'LineWidth',4);

% Create errorbar
ha= errorbar(X1,yvector1,E1,'LineStyle','none','LineWidth',3,...
    'Color',[0 0 0]);
%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 0.2 units
Xdata(xleft) = Xdata(xleft) - .1;
Xdata(xright) = Xdata(xright) + .1;
set(hb(2),'Xdata',Xdata)

cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\optimumLaurelle\fig5-LNwithL100I')

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'barCorrLNInt','meta')

[h, p] = ttest2(noDrugBestfitVect,EFVBestfitVect)
