close all;

clear all;

%%%%%%%%model with K103N in LN

cd('C:\Alex\SAforBackup\REVISION\rev2Backup6jan18\revisionLJsubFeb18\rawFigEps')

colorTable = [0.2980392156862745 0.4470588235294118 0.6901960784313725;...
 0.3333333333333333 0.6588235294117647 0.40784313725490196;...
 0.7686274509803922 0.3058823529411765 0.3215686274509804;...
 0.5058823529411764 0.447058823529411 0.6980392156862745;...
 0.8 0.7254901960784313 0.4549019607843137;...
 0.39215686274509803 0.7098039215686275 0.803921568627451]

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_CellFree_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%each row is one experiment

EFVconcCellFree = [0 10 20 40 80 160];

liveInfectedCellFree = [28773 16893	19673 9408 4483	1653;...
39182 27593	23903 10690 6007 1687];

meanCellFree = mean(liveInfectedCellFree);

stdCellFree = std(liveInfectedCellFree);



for index = 1:numel(liveInfectedCellFree(:, 1))
    
    
TxCellFreeRow = liveInfectedCellFree(index, :)./liveInfectedCellFree(index, 1);

TxCellFree(index, :) = TxCellFreeRow;

end

meanTxCellFree = mean(TxCellFree);

%seTxCellFree = std(TxCellFree)./sqrt(3);

stdTx = std(TxCellFree);

%%%first value always 1, take out of std

TxNoFirst = TxCellFree(:, 2:end);

stdTxNoFirst = std(TxNoFirst);

%%fit to get d
D = EFVconcCellFree;
Tx = meanTxCellFree;

for hIndex = 1:50;
    
    for IC50Index = 1:100;
        
        hill = hIndex/10; %%%varies 0.1 to 5
        IC50 = IC50Index; %%%varies 1 to 100 for mutant
        
        for drugConc = 1:numel(D);
        

dParam = 1-(1/(1+(IC50/D(drugConc))^hill));

dParamVect(drugConc) = dParam;

        end
        
        %%%calculate residuals for h, IC50 pair
        
        

%sumResiduals = sum((Tx-dParamVect).^2./(Tx.^2));%%%residuals normalized by experimental value to give deviations similar weight independent of value size 

resVect = Tx(2:end)-dParamVect(2:end);

sumResiduals = sum(((Tx(2:end)-dParamVect(2:end)).^2).*(1./stdTx(2:end).^2));

resMatrix(hIndex, IC50Index) = sumResiduals;

resArray{hIndex, IC50Index}=resVect;

    end
    
end


%find minimum residuals
minSumResiduals = min(min(resMatrix));

%%% Find which h and IC50 give minimum residuals 

[rowNum, colNum] = find(resMatrix==minSumResiduals);

bestfitHill = rowNum/10

bestfitIC50 = colNum

%%%%generate bestfit Tx

D2= linspace(0, 320);

TxBestfit = 1-(1./(1+(bestfitIC50./D2).^bestfitHill));

figure1 = figure,
        
         axes1 = axes('Parent',figure1,'XMinorTick','off',...
    'FontSize',22, 'YScale','log', 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000])
   
   axis('square')
   
xlim([-0.5 325])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree)/sqrt(2);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 4 units 
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\revisionLJsubFeb18\rawFigEps')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeLN103Log','meta')

hold off

%%%%linear y scale

figure2 = figure,
        
         axes2 = axes('Parent',figure2,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 325])

ylim([0, 1.1])
hold all

X1=EFVconcCellFree;
Y1=meanTxCellFree;
E1=std(TxCellFree)/sqrt(2);
X2=D2;
Y2=TxBestfit;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'Marker','o',...
    'LineWidth',3,...
    'LineStyle','none',...
    'Color',[0.333333333333333 0.658823529411765 0.407843137254902]);

% Create errorbar
ha=errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 4 units
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

%print(figure2,'-dpdf','cellFreeRevWtLin.pdf')

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'cellFreeLN103Lin','meta')

 


hold off


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Cell-Cell 0251 and 274%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


EfvConcCellCell = [0 40	80	160	320];

liveInfectedCellCell = [13146	16840	14143	29649	16366;...
12223	23126	29957	28783	15662;...
5879	5349	11791	9566	4080];  %%%%last row is 274

normLiveInfectedCellCellRow1 = liveInfectedCellCell(1, :)/max(liveInfectedCellCell(1, :));
normLiveInfectedCellCellRow2 = liveInfectedCellCell(2, :)/max(liveInfectedCellCell(2, :));
normLiveInfectedCellCellRow3 = liveInfectedCellCell(3, :)/max(liveInfectedCellCell(3, :));

normLiveInfectedCellCell = [normLiveInfectedCellCellRow1; normLiveInfectedCellCellRow2; normLiveInfectedCellCellRow3];

liveInfectedCellCellMean = mean(normLiveInfectedCellCell);

liveInfectedCellCellStd = std(normLiveInfectedCellCell);


meanIntCorr = 21; %%%number of HIV DNA copies after correction

%%%%calculate d based on cell-free fitted IC50, hill. Note Tx is d for cell
%%%%free infection

dCalc = 1-(1./(1+(bestfitIC50./EfvConcCellCell).^bestfitHill));


for rIndex = 1:100;
    
    r= rIndex/100;
    
    for qIndex = 1:100
        
        q= qIndex/100;

%%%only 6 values - use for fit
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%pLiveInfected = (1- (1-r).^(meanIntCorr.*dCalc)).*((1-q).^(meanIntCorr.*dCalc));
pLiveInfected = exp(-(meanIntCorr.*dCalc).*q).*(1-exp(-(meanIntCorr.*dCalc).*r.*(1-q)));
%pLiveInfected = exp(-(meanIntCorr.*dCalc).*q.*r)-exp(-(meanIntCorr.*dCalc)*r);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
pLiveInfectedArray{rIndex,qIndex}= pLiveInfected; %%%%stores vector for 6 values in array

    end
    
end

%%%%Calculate residuals

%weightForFit = 1./(liveInfectedCellCellStd.^2); %%%1/var

weightForFit = ones(1, numel(liveInfectedCellCellStd)); %%%%even weight

for rIndex = 1:100;
    
    
    
    for qIndex = 1:100
 
calcVect= pLiveInfectedArray{rIndex,qIndex}; 

calcVectNorm = calcVect./max(calcVect);


%sumResiduals = sum(weightForFit.*(calcVectNorm-liveInfectedCellCellMean).^2);
sumResiduals = sum(weightForFit.*sqrt((calcVectNorm-liveInfectedCellCellMean).^2));


sumResidualsMatrix(rIndex, qIndex) = sumResiduals;

    end
    
end

[bestfitRindex, bestfitQindex] = find(sumResidualsMatrix ==min(min(sumResidualsMatrix)));

figure10 =figure; 

axes10 = axes('Parent',figure10, 'FontSize',14);

%axis square

hold(axes10,'all');

h= pcolor(sumResidualsMatrix);

set(h, 'EdgeColor', 'none');

%xtick = [1,5,10,15, 20];
xtick = [20,40,60,80, 100];
ytick = [20,40,60,80, 100];

set(axes10,'XTick', xtick, 'XTickLabel',{xtick./100}, 'YTick', ytick, 'YTickLabel',{ytick./100});

saveas(gcf,'residualsRandQ','meta')

bestfitR= bestfitRindex/100;

bestfitQ =bestfitQindex/100;

% bestfitR= 0.7;
% 
% bestfitQ =0.12;


%%%use bestfit param to create smooth fit curve. TxBestfit already
%%%calculated for cell-free
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%pLiveInfectedSmooth = (1- (1-bestfitR).^(meanIntCorr.*TxBestfit)).*((1-bestfitQ).^(meanIntCorr.*TxBestfit));
pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ).*(1-exp(-(meanIntCorr.*TxBestfit).*bestfitR.*(1-bestfitQ)));
%pLiveInfectedSmooth = exp(-(meanIntCorr.*TxBestfit).*bestfitQ.*bestfitR)-exp(-(meanIntCorr.*TxBestfit)*bestfitR);

normPliveInfect = pLiveInfectedSmooth./max(pLiveInfectedSmooth);

EFVatPeak = D2(find(pLiveInfectedSmooth==max(pLiveInfectedSmooth)))
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure3 = figure,
        
         axes3 = axes('Parent',figure3,'XMinorTick','off',...
    'FontSize',22, 'LineWidth',3);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 325])

ylim([0 1.1])
hold all


X1=EfvConcCellCell;
Y1=liveInfectedCellCellMean;
E1=liveInfectedCellCellStd./sqrt(3);
X2=D2;
Y2=normPliveInfect;

% Create plot
plot(X1,Y1,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'LineStyle','none',...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

% Create errorbar
ha=errorbar(X1,Y1,E1,'MarkerSize',11,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

%%%%modify error bar caps
hb = get(ha,'children'); 
Xdata = get(hb(2),'Xdata');
temp = 4:3:length(Xdata);
temp(3:3:end) = [];
% xleft and xright contain the indices of the left and right
%  endpoints of the horizontal lines
xleft = temp; xright = temp+1;
% Increase line length by 4 units
Xdata(xleft) = Xdata(xleft) - 2;
Xdata(xright) = Xdata(xright) + 2;
set(hb(2),'Xdata',Xdata)

% Create plot
plot(X2,Y2,...
    'MarkerFaceColor',[0.333333333333333 0.658823529411765 0.407843137254902],...
    'LineWidth',3,...
    'Color',[0 0 0]);

hold on


set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('')
yhandle=ylabel('')

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

saveas(gcf,'LNinfK103Nnew','meta')



hold off


%%%%individual experiments

for count = 1:numel (liveInfectedCellCell(:, 1))
    
    figure3 = figure,
        
         axes3 = axes('Parent',figure3,'XMinorTick','off',...
    'FontSize',30, 'LineWidth',4);%%,....)%%,...'XTick',[0 20 40 60 80 100], 'YTick',[0 20 40 60 80 100 120]
   %%%  'YScale','log', 'XScale','log','XTick',[1 10 100 1000 10000 100000 1000000]), 'YScale','log'
   
   axis('square')
   
xlim([-0.5 325])

ylim([0 1.1])
hold all


X1=EfvConcCellCell;
Y1=liveInfectedCellCell(count, :)./max(liveInfectedCellCell(count, :));


% Create plot
plot2 = plot(X1,Y1,'MarkerSize',20,...
    'MarkerFaceColor',[0.501960813999176 0.501960813999176 0.501960813999176],...
    'Marker','square',...
    'LineStyle','none',...
    'LineWidth',2.5,...
    'LineStyle','none',...
    'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

hold on

% Get xdata from plot
xdata2 = get(plot2, 'xdata');
% Get ydata from plot
ydata2 = get(plot2, 'ydata');
% Make sure data are column vectors
xdata2 = xdata2(:);
ydata2 = ydata2(:);



xplot2 = linspace(0, 320); 

% Find coefficients for shape-preserving interpolant
fitResults2 = pchip(xdata2, ydata2);
% Evaluate piecewise polynomial
yplot2 = ppval(fitResults2, xplot2);
% Plot the fit
fitLine2 = plot(xplot2,yplot2,'DisplayName','shape-preserving',...
    'Parent',axes3,...
    'Tag','shape-preserving',...
     'LineWidth',3.5,...
'LineStyle','--',...
'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);



% % % % Find coefficients for spline interpolant
% % % fitResults2 = spline(xdata2, ydata2);
% % % % Evaluate piecewise polynomial
% % % yplot2 = ppval(fitResults2, xplot2);
% % % % Plot the fit
% % % fitLine2 = plot(xplot2,yplot2,'DisplayName','   spline','Parent',axes3,...
% % %     'Tag','spline',...
% % %     'LineWidth',2,...
% % %     'LineStyle','--',...
% % %     'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

% % Find coefficients for spline interpolant
% fitResults2 = spline(xdata2, ydata2);
% % Evaluate piecewise polynomial
% yplot2 = ppval(fitResults2, xplot2);
% % Plot the fit
% fitLine2 = plot(xplot2,yplot2,'DisplayName','   spline','Parent',axes2,...
%     'Tag','spline',...
%     'LineWidth',3.5,...
%     'LineStyle','--',...
%     'Color',[0.501960813999176 0.501960813999176 0.501960813999176]);

set(gcf,'renderer','painters')

set(gca,'ticklength',0.3*get(gca,'ticklength'))

xhandle=xlabel('');
yhandle=ylabel('');

set(xhandle,'Fontname','Calibri')
set(yhandle,'Fontname','Calibri')

%cd('\\fs01\Lab\PI Sigal Lab\papersInProgress\revisionLJsubFeb18\rawFigEps')

name= (['exp' num2str(count) 'infK103N']);
saveas(gcf,name,'meta')
end



