options(echo=TRUE)
args <- commandArgs(trailingOnly = TRUE)
print(args)
model <- as.integer(args[1])
iter <- as.integer(args[2])
burn <- as.integer(args[3])
thin <- as.integer(args[4])

print(model)
print(iter)
print(burn)
print(thin)

inputfile = "./flu_vac_div.csv"

#data <- load("flu_vac_div.RData")
#summary(data)

outfile = "mcmc_res.txt"

log <- capture.output({data <- read.table(inputfile, header = TRUE, sep = ",", na.strings = "NA", dec = ".", strip.white = TRUE);})

data$week <- as.factor(data$week)
data$county <- as.factor(data$county)
data$LOGN <- log(data$N)

names <- colnames(data)

summary(data)

print('after table')

weeks <- c(2,3,4,40,41,42,43,44,99,100,101,102,103,104,150,151,152,153,154,155,156,198,199,200,201,202,203,204,256,257,258,259,260,261,310,311,312,313,314,315,341,342,343,344,345,346,409,410,411,412,413,414)


data <- data[data$week %in% weeks, ]
print('subset data')

summary(data)


#attach(data)
sink(file = outfile, append = TRUE, split = TRUE)
library("MCMCglmm")
library(arm)  # convenience functions for regression in R


data <- within(data, {
	county <- as.factor(county)
	state <- as.factor(state)
})

data = na.omit(data)

names <- colnames(data)


for (x in names) {
if (x != "county" & x != "week" & x != "flu" & x != "LOGN" & x != "state"){
	print(x)	
	data[,x] <- rescale(data[,x],'full')
	print(summary(data[,x]))
   }
}


summary(data)

#quit()

write.table(data, file="transformed.csv", row.name=FALSE, na="NA",col.names=TRUE, sep=",")

#exit(0)

if(model==1){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + v1 + v2"
}
if(model==2){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + v1 + v2"
}
if(model==3){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2"
}
if(model==4){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2"
}
if(model==5){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + v1 + v2"
}
if(model==6){
	mod = "flu  ~ LOGN +  1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2 + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + v1 + v2"
}
if(model==7){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + Income + airport_diffusion + v1 + v2"
}
if(model==8){
	mod = "flu  ~ LOGN +  1 + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + Income + airport_diffusion + v1 + v2"
}
if(model==9){
	mod = "flu  ~ LOGN +  1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + Income + airport_diffusion + v1 + v2"
}
if(model==10){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + v1 + v2"
}
if(model==11){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2"
}
if(model==12){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + max_HUS_mean*t_avg_mean +
d_max_HUS_0*d_t_avg_0 + d_max_HUS_min_1*d_t_avg_min_1 + d_max_HUS_min_2*d_t_avg_min_2 + d_max_HUS_min_3*d_t_avg_min_3 +
RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2"
}
if(model==13){
	mod = "flu ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0  + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_3 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_2 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Urban + v1 + v2"
}

if(model==14){
	mod = "flu ~ LOGN + 1 + v1 + v2"
}
if(model==15){
	mod = "flu ~ LOGN + 1"
}
if(model==16){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + v1 + v2+ land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==17){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==18){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==19){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==20){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==21){
	mod = "flu  ~ LOGN +  1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2 + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==22){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==23){
	mod = "flu  ~ LOGN +  1 + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==24){
	mod = "flu  ~ LOGN +  1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==25){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==26){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==27){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + max_HUS_mean*t_avg_mean +
d_max_HUS_0*d_t_avg_0 + d_max_HUS_min_1*d_t_avg_min_1 + d_max_HUS_min_2*d_t_avg_min_2 + d_max_HUS_min_3*d_t_avg_min_3 +
RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}
if(model==28){
	mod = "flu ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0  + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_3 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_2 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}

if(model==29){
	mod = "flu ~ LOGN + 1 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4"
}

#----------------------------------------------------
if(model==30){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==31){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==32){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2+ HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==33){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==34){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==35){
	mod = "flu  ~ LOGN +  1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2 + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==36){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + Income + airport_diffusion + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==37){
	mod = "flu  ~ LOGN +  1 + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + Income + airport_diffusion + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==38){
	mod = "flu  ~ LOGN +  1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + Income + airport_diffusion + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==39){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==40){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==41){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + max_HUS_mean*t_avg_mean +
d_max_HUS_0*d_t_avg_0 + d_max_HUS_min_1*d_t_avg_min_1 + d_max_HUS_min_2*d_t_avg_min_2 + d_max_HUS_min_3*d_t_avg_min_3 +
RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==42){
	mod = "flu ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0  + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_3 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_2 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Urban + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}

if(model==43){
	mod = "flu ~ LOGN + 1 + v1 + v2 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==44){
	mod = "flu ~ LOGN + 1 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==45){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + v1 + v2+ land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==46){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==47){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==48){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean +  d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2  + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + AVG_PRESS_mean + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + Wind_avg_mean + d_Wind_avg_min_1 + d_Wind_avg_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==49){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==50){
	mod = "flu  ~ LOGN +  1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + t_avg_mean + d_t_avg_min_1 + d_t_avg_min_2 + RSDS_mean + d_RSDS_min_1 + d_RSDS_min_2 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==51){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_min_1 + d_max_HUS_min_2 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==52){
	mod = "flu  ~ LOGN +  1 + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==53){
	mod = "flu  ~ LOGN +  1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==54){
	mod = "flu  ~ LOGN + 1 +  max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==55){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + d_max_HUS_min_4 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + d_RSDS_min_4 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + d_AVG_PRESS_min_4 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_1 + d_tot_prec_min_2 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_1 + d_Wind_avg_min_2 + d_Wind_avg_min_3 + d_Wind_avg_min_4 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==56){
	mod = "flu  ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_2 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0 + d_t_avg_min_1 + d_t_avg_min_2 + d_t_avg_min_3 + max_HUS_mean*t_avg_mean +
d_max_HUS_0*d_t_avg_0 + d_max_HUS_min_1*d_t_avg_min_1 + d_max_HUS_min_2*d_t_avg_min_2 + d_max_HUS_min_3*d_t_avg_min_3 +
RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + d_RSDS_min_2 + d_RSDS_min_3 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_2 + d_AVG_PRESS_min_3 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Pacific + Insured + Poor + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}
if(model==57){
	mod = "flu ~ LOGN + 1 + max_HUS_mean + d_max_HUS_0 + d_max_HUS_min_1 + d_max_HUS_min_3 + t_avg_mean + d_t_avg_0  + d_t_avg_min_3 + d_t_avg_min_4 + RSDS_mean + d_RSDS_0 + d_RSDS_min_1 + AVG_PRESS_mean + d_AVG_PRESS_0 + d_AVG_PRESS_min_1 + d_AVG_PRESS_min_3 + tot_prec_mean + d_tot_prec_0 + d_tot_prec_min_3 + d_tot_prec_min_4 + Wind_avg_mean + d_Wind_avg_0 + d_Wind_avg_min_2 + Income + airport_diffusion + Am_Ind + Asian + White_Hisp + W_non_Hisp + Black_Hisp + B_non_Hisp + Urban + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}

if(model==58){
	mod = "flu ~ LOGN + 1 + v1 + v2 + land1 + land2 + land3 + land4 + tweet1 + tweet2 + tweet3 + tweet4 + air1 + air2 + air3 + air4 + HA + M1 + M2 + NA. + Cum_vac_per_N_diff_1 + Cum_vac_per_N_diff_2 + Cum_vac_per_N_diff_3 + Cum_vac_per_N_diff_4"
}

if (model > 58 | model < 1){
	
	print("Unknown model!")
}

print(mod)

modd <- as.formula(mod);
mo = model.matrix(model.frame(modd, data = data),data)
nparam <- length(attr(mo,'assign'))
print(nparam)

# offset should be always the first
B = list(mu = matrix(as.list(rep(0, nparam)),nparam),
         V = diag(nparam)*(10))
B$mu[2] = 1
diag(B$V)[2]<-1e-9		  
G=list(G1=list(V=1,nu=0.002))
R=list(V=1,nu=0.002)
prior1 <- list(B = B, R = R, G = G)

print(mod)

out0 = MCMCglmm( modd,
   prior = prior1,
   random = ~county, 
   data = data, 
   singular.ok=TRUE,
   burnin = burn,
   nitt = iter,
   thin = thin,
   family="poisson", 
   DIC=TRUE,
   verbose = TRUE, 
   pr = FALSE,
   saveX = FALSE, 
   saveZ = FALSE)
   
print(summary(out0))

sink('res_parameters_16_29.txt',append=TRUE)

print(mod)
out_string = ''

b = colnames(out0$Sol)

for (name in b){
	
   	Fn <- ecdf(out0$Sol[,name])
	
	if (mean(out0$Sol[,name]) < 0){
		p = 1 - Fn(0)
		} else {
		p = Fn(0)	
		}
		
   		out_string = paste(name,
   		             as.character(mean(out0$Sol[,name])),
   					 as.character(exp(mean(out0$Sol[,name]))),
                     as.character(min(1.,max(p,1./(1.*iter-1.*burn)))),
   					 sep='\t')
		cat(out_string)
		cat('\n')
	
   }
sink()

sink(file='mcmc_res_factors.txt',append=TRUE)
print('-----------------------------------------------------------------')
summary(out0)
sink()

   