#include <boost/program_options/options_description.hpp>
#include <boost/program_options/parsers.hpp>
#include <boost/program_options/variables_map.hpp>
#include <boost/tokenizer.hpp>
#include <boost/token_functions.hpp>
#include <exception>

#include <map>
#include <fstream>
#include <sstream>
#include <iostream>
#include <string>
#include <vector>
#include <stdlib.h>
#include <math.h>
#include <set>

using namespace std;
using namespace boost::program_options;

double TH_=10/200;

map<string,unsigned int> K;
vector <double> tab_(4,1.0);
//------------------------------------

ostream& operator << (ostream &out, vector <bool> &s)
{
  for (unsigned int i=0; i<s.size(); i++)
    out << s[i];
  return out;
}
//------------------------------------

ostream& operator << (ostream &out, vector <double> &s)
{
  for (unsigned int i=0; i<s.size(); i++)
    out << s[i] << " ";
  return out;
}

//------------------------------------
ostream& operator << (ostream &out, set <string> &s)
{
  for (set <string>::iterator itr=s.begin();
       itr!=s.end();
       ++itr)
    out << *itr << " ";
  return out;
}
//------------------------------------

ostream& operator << (ostream &out, map<string,unsigned int> &s)
{
  for(map<string,unsigned int>::iterator itr=s.begin();
      itr!=s.end();
      ++itr)
    out << itr->first << " " << itr->second << endl;
  return out;
}
//------------------------------------

unsigned int getcf(vector<unsigned int> V)
{
  double val=0;
  if(V.empty())
    {
      cout << " EMPTY V" << endl;
      exit(0);
    }
  for(unsigned int i=0;i<V.size();++i)
    val+=pow(2,i)*V[i];
  return val;
};
//------------------------------------

map<string,unsigned int>& segment(map<vector<bool>,set<string> >& H_,
			  set<unsigned int> vkey,
			  set<string>& S1,
			  set<string>& S2,
			  set<string>& S3)
{
  map<vector<bool>,set<string> > H__;
  set<vector<bool> > keys_;
  for(map<vector<bool>,set<string> >::iterator itr=H_.begin();
      itr!=H_.end();
      ++itr)
    {
      bool Flag=true;
      for(set<unsigned int>::iterator itr_=vkey.begin();
	  itr_!=vkey.end();
	  ++itr_)
	if(!itr->first[*itr_])
	  Flag=false;
      if(Flag)
	{
	  S1.insert(itr->second.begin(),
		    itr->second.end());

	  vector <bool> thisnegkey_;
	  for(unsigned int i=0;i<itr->first.size();++i)
	    if(vkey.find(i)==vkey.end())
	      thisnegkey_.push_back(itr->first[i]);

	  keys_.insert(thisnegkey_);
	}
      else
	{
	  vector <bool> thisnegkey_;
	  for(unsigned int i=0;i<itr->first.size();++i)
	    if(vkey.find(i)==vkey.end())
	      thisnegkey_.push_back(itr->first[i]);

	  H__[thisnegkey_].insert(itr->second.begin(),itr->second.end());
	}
    }

  for(map<vector<bool>,set<string> >::iterator itr=H__.begin();
      itr!=H__.end();
      ++itr)
    if(keys_.find(itr->first)!=keys_.end())
      S2.insert(itr->second.begin(),itr->second.end());
    else
      S3.insert(itr->second.begin(),itr->second.end());

  for(set<string>::iterator itr=S1.begin();
      itr!=S1.end();
      ++itr)
    K[*itr]=1;
  for(set<string>::iterator itr=S2.begin();
      itr!=S2.end();
      ++itr)
    K[*itr]=0;
  for(set<string>::iterator itr=S3.begin();
      itr!=S3.end();
      ++itr)
    K[*itr]=2;

  return K;
};
//---------------------------------------------

vector<double>& getContTab(set<string>& S1,
			  set<string>& S2,
			  map<string, map<int, double> >& F,
			  int wk)
{
    for(set<string>::iterator itr=S1.begin();
      itr!=S1.end();
      ++itr)
    if(F[*itr][wk]>TH_)
      tab_[0]++;
    else
      tab_[1]++;

  for(set<string>::iterator itr=S2.begin();
      itr!=S2.end();
      ++itr)
    if(F[*itr][wk]>TH_)
      tab_[2]++;
    else
      tab_[3]++;

  return tab_;
};


//---------------------------------------------
const string VERSION__="version 1 December 2015 [ishanu chattopadhyay]";
const string EMPTY_ARG_MESSAGE="Exiting. Type -h or --help for usage";


//------------------------------------
int main(int argc, char* argv[])
{
  string datafile="flu_.dat";
  unsigned int  NUM=2;
  string sgnfile="DATASTAT";
  vector<bool> SGN;
  set<unsigned int> key_;
  vector<unsigned int> key__;
  bool LIST=false;
  string flufile="flu_.csv";
  int wk=100;
  bool FIG=false;
  string figdata="";

  options_description desc( "Usage: ");
  desc.add_options()
    ("help,h", "print help message.") 
    ("keys,k",value< vector<unsigned int> >()->multitoken(), "Keys")
    ("datafile,f",value<string>(), "datafile")   
    ("figfile,D",value<string>(), "figfile []")   
    ("flufile,F",value<string>(), "flufile")   
    ("week,w",value<int>(), "week")   
    ("threshold,T",value<double>(), "prevalence threshold")   
    ("numpar,n",value<unsigned int>(), "num of factors")   
    ("list,L","List factors and exit")   
    ("version,V", "print version number");

  positional_options_description p;
  variables_map vm;
  if (argc == 1)
    {
      cout << EMPTY_ARG_MESSAGE << endl;
      return 1;
    }
  try
    {
      store(command_line_parser(argc, argv)
	    .options(desc)
	    .run(), vm);
      notify(vm);
    } 
  catch (std::exception &e)
    {
      cout << endl << e.what() 
	   << endl << desc << endl;
    }
  if (vm.count("help"))
    {
      cout << desc << endl;
      return 0;
    }
  if (vm.count("version"))
    {
      cout << VERSION__ << endl;
      return 0;
    }
  if (vm.count("datafile"))
    datafile=vm["datafile"].as<string>();
  if (vm.count("figfile"))
    figdata=vm["figfile"].as<string>();
  if (vm.count("flufile"))
    flufile=vm["flufile"].as<string>();
  if (vm.count("threshold"))
    TH_=vm["threshold"].as<double>();
  if (vm.count("keys"))
    key__=vm["keys"].as<vector<unsigned int> >();
  if (vm.count("numpar"))
    NUM=vm["numpar"].as<unsigned int>();
  if (vm.count("week"))
    wk=vm["week"].as<int>();
  if (vm.count("list"))
    LIST=true;

  for(unsigned int i=0;i<key__.size();++i)
    key_.insert(key__[i]);

  if(figdata!="")
    FIG=true;

  string line;
  vector<string> FACTORS;
  ifstream IN_(sgnfile.c_str());
  while(getline(IN_,line))
    {
      stringstream ss(line);
      string tmp;
      bool bval;
      if(ss>>tmp>>bval)
	{
	  SGN.push_back(bval);
	  FACTORS.push_back(tmp);
	}
    }
  IN_.close();

  map<string, map<int, double> > F;
  ifstream IN__(flufile.c_str());
  while(getline(IN__,line))
    {
      string tmp;
      int wk;
      double num,tot;
      stringstream ss(line);
      while(ss>>tmp>>wk>>num>>tot)
	if(tot>0)
	  F[tmp][wk]=num;
    }
  IN__.close();


  if(LIST)
    {
      for(unsigned int i=0;i<FACTORS.size();++i)
	cout << i << " : " << FACTORS[i] << " " << SGN[i] << endl;
      exit(0);
    }

  map<string,vector<double> >  H;

  unsigned int count=0;
  ifstream IN(datafile.c_str());
  while(getline(IN,line))
    {
      stringstream ss(line);
      string fips;

      if(count++==0)
	continue;

      if(ss>>fips)
	{
	  double val=0;
	  vector<double> val_;
	  while(ss>>val)
	    val_.push_back(val);
	  H[fips]=val_;
	}
    }


  vector <double> avg_(NUM,0.0);
  
  for(map<string,vector<double> >::iterator itr=H.begin();
      itr!=H.end();
      ++itr)
    for(unsigned int i=0;i<NUM;++i)
      avg_[i]+=(itr->second)[i];

  for(unsigned int i=0;i<NUM;++i)
    avg_[i]/=(H.size()+0.0);

  map<string, vector<bool> > SYM_;
  vector<bool> SYM(NUM);

  for(map<string,vector<double> >::iterator itr=H.begin();
      itr!=H.end();
      ++itr)
    {
      for(unsigned int i=0;i<NUM;++i)
	{
	  if(SGN[i])
	    {
	      if(itr->second[i] > avg_[i])
		SYM[i]=true;
	      else
		SYM[i]=false;
	    }
	  else
	    {
	      if(itr->second[i] < avg_[i])
		SYM[i]=false;
	      else
		SYM[i]=true;
	    }
	}
      SYM_[itr->first]=SYM;
    }

  map<vector<bool>,set<string> > HSYM_;

  for(map<string,vector<bool> >::iterator itr=SYM_.begin();
      itr!=SYM_.end();
      ++itr)
    HSYM_[itr->second].insert(itr->first);

  /*
  for(map<string,vector<bool> >::iterator itr=SYM_.begin();
      itr!=SYM_.end();
      ++itr)
    cout << itr->first << " " << itr->second << endl;
  */

  set<string> S1,S2,S3;
  //    cout << 
  if(!FIG)  
    segment(HSYM_,key_,S1,S2,S3);
  else
    {
      ofstream FIG_(figdata.c_str());
      FIG_<<    segment(HSYM_,key_,S1,S2,S3);
      FIG_.close();
    }


  stringstream sss;
  sss << getContTab(S1,S2,F,wk);



  cout << datafile << " ";
  for(unsigned int i=0;i<key__.size();++i)
    cout << key__[i]  << " " << flush;

  cout << " ::: " << sss.str() << " ::: " << flush;

  //std::system(("./fisher_exact_.py "+sss.str()).c_str());

  std::system(("./rscp.R "+sss.str()+ " > tmp__; a=`sed -n -e 5p -e 8p -e 11p tmp__ `; echo $a").c_str());


  //cout << "# " << TH_<< endl;
  
/*
  cout << S1 << endl << endl;
  cout << S2 << endl <<endl;
  cout << S3 << endl <<endl;
  */

  return 0;
}
