plotallIndices = 0;
xspace = 0.1;
yspace = 0.2;
widF = 0.22;
plotAllIndcs = 0;
smoothMed = 0;
histBn = 30;
histBn2 = 15;
smoothBarsLen = 5;
stepSz = 0.05;%1/numel(Sara.allSimpleMemBaseIndices);%0.075;

inLocations = [-1+stepSz : stepSz : 1 ];


%%
figure(20083),clf,title('I N D I C E S','fontsize',18,'backgroundcolor','w'),hold on
set(gca,'xtick',[],'ytick',[],'color','w','xcolor','w','ycolor','w'),box off,


if plotAllIndcs
    mmI = Andre.allSimpleMemBaseIndices;
else
    mmI = Andre.statSimpleMemBaseIndices;
end
posMMI = indices(find(indices>0));
negMMI = indices(find(indices>0));

if plotAllIndcs
    indices = Andre.allSimpleMemBaseIndices;
    indices2 = Sara.allSimpleMemBaseIndices;
    indices = indices(find(~isnan(indices)));
    indices2 = indices2(find(~isnan(indices2)));
    if isempty(indices),indices=0;end;
    if isempty(indices2),indices2=0;end;
    IndCounts = histcounts(indices,inLocations);
    IndCounts2 = histcounts(indices2,inLocations);
else
    indices = Andre.statSimpleMemBaseIndices;
    indices2 = Sara.statSimpleMemBaseIndices;
    indices = indices(find(~isnan(indices)));
    indices2 = indices2(find(~isnan(indices2)));
    if isempty(indices),indices=0;end;
    if isempty(indices2),indices2=0;end;
    IndCounts = histcounts(indices,inLocations);
    IndCounts2 = histcounts(indices2,inLocations);
end
positiveIndices = indices(find(indices>0));
negativeIndices = indices(find(indices<0));
positiveIndices2 = indices2(find(indices2>0));
negativeIndices2 = indices2(find(indices2<0));


%% stats

if isempty(positiveIndices), positiveIndices = 0; end
if isempty(positiveIndices2), positiveIndices2 = 0; end
[hKSAndreSimple,pKSAndreSimple ] = kstest2(indices,indices-mean(indices),'tail','smaller');
[hKSSaraSimple,pKSSaraSimple ] = kstest2(indices2,indices2-mean(indices2),'tail','smaller');

[pAndreIndPre112, hAndreIndPost112] = ranksum(indices,indices-mean(indices),'tail','right','alpha',0.05);
[pSaraIndPre121, hSaraIndPost121] = ranksum(indices2,indices2-mean(indices2),'tail','right','alpha',0.05);


axes('Units','normalized','position',[xspace,0.7,widF,widF/2])%,cla

if smoothMed
    bar(inLocations, [0;smooth(IndCounts,smoothBarsLen)],'b'),hold on
else
    bar(inLocations,[0  IndCounts],'b'),hold on
end

[iVal inLoc] = max(IndCounts);

axis tight
xs = axis; ylim([0 xs(4)+(xs(4)/10)])
line([0 0],[0 xs(4)],'linewidth',2,'color','m')
xlim([-1.1 1.1]),hold on

axxs = axis;
axis tight
xs = axis; ylim([0 xs(4)+(xs(4)/10)])
line([0 0],[0 xs(4)],'linewidth',2,'color','m')
xlim([-1.1 1.1]),hold on
if hKSAndreSimple == 0
    text(axxs(1),axxs(4)*.8,'Not Normal','color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
end

text(axxs(1),axxs(4)*.5,{['p = ' num2str(pKSAndreSimple)]; ' (kstest) '},'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on

[hz,pz] = ztest(indices,0,0,'Tail','right','alpha',0.05);

axes('Units','normalized','position',[xspace,0.705+widF/2,widF,widF/2]),cla%,cla


if smoothMed
    bar(inLocations, smooth([0 IndCounts2],smoothBarsLen),'r'),
else
    bar(inLocations,[0 IndCounts2],'r')
end


axis tight
xs=axis;
axxs = axis; ylim([0 xs(4)+(xs(4)/10)])
if hKSSaraSimple == 0
    text(axxs(1),axxs(4)*.8,'Not Normal','color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
end
text(axxs(1),axxs(4)*.5,{['p = ' num2str(pKSSaraSimple)]; ' (kstest) '},'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
[hz,pz] = ztest(indices2,0,0,'Tail','right','alpha',0.05);
axis tight
xs = axis; ylim([0 xs(4)+(xs(4)/10)])
line([0 0],[0 xs(4)],'linewidth',2,'color','m')
xlim([-1.1 1.1]),hold on



%% title first panel - part 1
axes('Units','normalized','position',[xspace*3.5,0.7,widF,widF/2]),cla%,clabar(inLocations,[0 IndCounts],'b'),hold on

set(gca,'xtick',[],'ytick',[],'color','w'),box off
ylim([0 1])
axxs = axis;

text(0.1,.85,['p = ' num2str(pAndreIndPre112) ' (ranksm) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on

text(.02,.7,['-> medcouple: '  num2str(medcouple(IndCounts'))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','bold','fontname','helvetica'),hold on

text(0.1,0.4,['mean = ' num2str(nanmean(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,0.55,['median = ' num2str(nanmedian(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,.25,['area > 0 = ' num2str(sum(positiveIndices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,.1,['area < 0 = ' num2str(abs(sum(negativeIndices)))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.65,0.3,['h = ' num2str(hAndreIndPost112) ' (ranksm) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
if hAndreIndPost112, set(gca,'xtick',[],'ytick',[],'color','y'),end


axes('Units','normalized','position',[xspace*3.5,0.705+widF/2,widF,widF/2]),cla%,cla
ylim([0 1])
axxs = axis;
set(gca,'xtick',[],'ytick',[],'color','w'),box off

text(0.1,.85,['p = ' num2str(pSaraIndPre121) ' (ranksm) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(.02,.7,['-> medcouple: '  num2str(medcouple(IndCounts2'))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','bold','fontname','helvetica'),hold on

text(0.1,0.4,['mean = ' num2str(nanmean(indices2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,0.55,['median = ' num2str(nanmedian(IndCounts2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,.25,['area > 0 = ' num2str(sum(positiveIndices2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.1,.1,['area < 0 = ' num2str(abs(sum(negativeIndices2)))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
text(0.65,0.3,['h = ' num2str(hSaraIndPost121) ' (ranksm) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
if hSaraIndPost121, set(gca,'xtick',[],'ytick',[],'color','y'),end

%% title first panel - part 2

[p,h,stats] = signrank(indices2,indices2-mean(indices2),'tail','right','alpha',0.05);

[hz,pz] = ztest(indices2,0,0,'Tail','right');

axes('Units','normalized','position',[xspace*6,0.705+widF/2,widF,widF/2]),cla
ylim([0 1])
axxs = axis;
set(gca,'xtick',[],'ytick',[],'color','w','xcolor','m','ycolor','m'),box off
text(0.01,.95,['p = ' num2str((p)) ' ( signrank ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
text(0.01,.8,['h = ' num2str((h)) ' ( signrank ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on

text(0.01,.4,['pz = ' num2str((pz)) ' ( ztest ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
text(0.01,.25,['hz = ' num2str((h)) ' ( ztest ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on

[p,h,stats] = signrank(indices,indices-mean(indices),'tail','right','alpha',0.05);
[hz,pz] = ztest(indices,0,0,'Tail','right');
axes('Units','normalized','position',[xspace*6,0.7,widF,widF/2]),cla%,cla

ylim([0 1])
axxs = axis;
set(gca,'xtick',[],'ytick',[],'color','w','xcolor','m','ycolor','m'),box off
text(0.01,.75,['p = ' num2str((p))   ' ( signrank ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
text(0.01,.6,['h = ' num2str((h))  ' ( signrank ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
text(0.01,.25,['pz = ' num2str((pz)) ' ( ztest ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
text(0.01,.1,['hz = ' num2str((h)) ' ( ztest ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on

%%
if isfield(popDecay.Andre,'SINGLE')
    %%
    if plotAllIndcs
        indices = Andre.allSINGLEMemBaseIndices;
        indices2 = Sara.allSINGLEMemBaseIndices;
        indices = indices(find(~isnan(indices)));
        indices2 = indices2(find(~isnan(indices2)));
        if isempty(indices),indices=0;end;
        if isempty(indices2),indices2=0;end;
        IndCounts = histcounts(indices,inLocations);
        IndCounts2 = histcounts(indices2,inLocations);
    else
        indices = Andre.statSINGLEMemBaseIndices;
        indices2 = Sara.statSINGLEMemBaseIndices;
        indices = indices(find(~isnan(indices)));
        indices2 = indices2(find(~isnan(indices2)));
        if isempty(indices),indices=0;end;
        if isempty(indices2),indices2=0;end;
        IndCounts = histcounts(indices,inLocations);
        IndCounts2 = histcounts(indices2,inLocations);
    end
    
    positiveIndices = indices(find(indices>0));
    negativeIndices = indices(find(indices<0));
    positiveIndices2 = indices2(find(indices2>0));
    negativeIndices2 = indices2(find(indices2<0));
    if plotAllIndcs
        mmI = Andre.allSimpleMemBaseIndices;
    else
        mmI = Andre.statSimpleMemBaseIndices;
    end
    posMMI = indices(find(indices>0));
    negMMI = indices(find(indices>0));
    [hKSAndreSIMPLE,pKSAndreSIMPLE,kSSAndreSIMPLE] = kstest(indices,'Tail','larger');
    [hKSSaraSIMPLE,pKSSaraSIMPLE,kSSSaraSIMPLE] = kstest(indices2,'Tail','larger');
    [pAndreIndPre112, hAndreIndPost112] = ranksum(indices,indices-mean(indices),'tail','right','alpha',0.05);
    [pSaraIndPre121, hSaraIndPost121] = ranksum(indices2,indices2-mean(indices2),'tail','right','alpha',0.05);
    
    
    posMMI = indices(find(indices>0));
    negMMI = indices(find(indices<0));
    
    posMMI2 = indices2(find(indices2>0));
    negMMI2 = indices2(find(indices2<0));
    
    [iVal inLoc] = max(IndCounts);
    
    axes('Units','normalized','position',[xspace,0.4,widF,widF/2]),cla
    if smoothMed
        bar(inLocations,smooth([0 IndCounts],smoothBarsLen),'b'),hold on,axis tight,
    else
        bar(inLocations,[0 IndCounts],'b'),hold on,axis tight,
    end
    
    axxs=axis;
    
    if hKSAndreSIMPLE == 0
        text(axxs(1),axxs(4)*.7,'Not Normal','color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    end
    text(axxs(1),axxs(4)*.45,{['p = ' num2str(pKSAndreSIMPLE)]; ' (kstest) '},'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    
    [hz,pz] = ztest(indices,0,0,'Tail','right','alpha',0.05);
    
    axis tight
    xs = axis; ylim([0 xs(4)+(xs(4)/10)])
    line([0 0],[0 xs(4)],'linewidth',2,'color','m')
    xlim([-1.1 1.1]),hold on
    axes('Units','normalized','position',[xspace,0.405+widF/2,widF,widF/2]),cla
    if smoothMed
        bar(inLocations,smooth([0 IndCounts2],smoothBarsLen),'r'),hold on,axis tight,set(gca,'xtick',[]);
    else
        bar(inLocations,[0 IndCounts2],'r'),hold on,axis tight,set(gca,'xtick',[]);
    end
    
    if smoothMed
        bar(inLocations,smooth([0 IndCounts2],smoothBarsLen),'r'),hold on,axis tight,
    else
        bar(inLocations,[0 IndCounts2],'r'),hold on,axis tight,
    end
    
    title('Indices vs unit counts -General')
    axis tight
    xs=axis;
    axxs = axis; ylim([0 xs(4)+(xs(4)/10)])
    if hKSSaraSIMPLE == 0
        text(axxs(1),axxs(4)*.8,'Not Normal','color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    end
    
    text(axxs(1),axxs(4)*.5,{['p = ' num2str(pKSSaraSIMPLE)]; ' (kstest) '},'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    [hz,pz] = ztest(indices2,0,0,'Tail','right','alpha',0.05);
    
    axis tight
    xs = axis; ylim([0 xs(4)+(xs(4)/10)])
    line([0 0],[0 xs(4)],'linewidth',2,'color','m'),hold on
    
    xlim([-1.1 1.1])
    
    %% title second panel
    axes('Units','normalized','position',[xspace*3.5,0.4,widF,widF/2]),cla%,clabar(inLocations,[0 IndCounts],'b'),hold on
    
    set(gca,'xtick',[],'ytick',[],'color','w'),box off
    ylim([0 1])
    axxs = axis;
    
    text(0.1,.85,['p = ' num2str(pAndreIndPre112) ' (ranksm) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(.02,.7,['-> medcouple: '  num2str(medcouple(IndCounts'))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','bold','fontname','helvetica'),hold on
    
    
    text(.1,.4,['mean = ' num2str(nanmean(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(.1,.55,['median = ' num2str(nanmedian(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(.1,.25,['area > 0 = ' num2str(sum(positiveIndices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(.1,.1,['area < 0 = ' num2str(abs(sum(negativeIndices)))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.65,0.3,['h = ' num2str(hAndreIndPost112) ' (ranksm) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    if hAndreIndPost112, set(gca,'xtick',[],'ytick',[],'color','y'),end
    
    axes('Units','normalized','position',[xspace*3.5,0.405+widF/2,widF,widF/2]),cla
    ylim([0 1])
    axxs = axis;
    set(gca,'xtick',[],'ytick',[],'color','w'),box off
    
    text(0.1,.85,['p = ' num2str(pSaraIndPre121) ' (ranksm) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(.02,.7,['-> medcouple: '  num2str(medcouple(IndCounts2'))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','bold','fontname','helvetica'),hold on
    
    text(0.1,.4,['mean = ' num2str(nanmean(indices2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.55,['median = ' num2str(nanmedian(IndCounts2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.25,['area > 0 = ' num2str(sum(positiveIndices2))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.1,['area < 0 = ' num2str(abs(sum(negativeIndices2)))],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.65,0.3,['h = ' num2str(hSaraIndPost121) ' (ranksm) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    if hSaraIndPost121, set(gca,'xtick',[],'ytick',[],'color','y'),end
    
    [p,h,stats] = signrank(indices2,zeros(1,numel(indices2)),'tail','right','alpha',0.05);
    [hz,pz] = ztest(indices2,0,0,'Tail','right');
    
    axes('Units','normalized','position',[xspace*6,0.405+widF/2,widF,widF/2]),cla
    ylim([0 1])
    axxs = axis;
    set(gca,'xtick',[],'ytick',[],'color','w','xcolor','m','ycolor','m'),box off
    text(0.01,.95,['p = ' num2str((p)) ' (signrank) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    text(0.01,.8,['h = ' num2str((h))  ' (signrank) '],'color',MarkerFaceColorSara,'fontsize',10,'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    text(0.01,.4,['pz = ' num2str((pz)) ' ( ztest ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    text(0.01,.25,['hz = ' num2str((h)) ' ( ztest ) '],'color',MarkerFaceColorSara, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    
    
    
    [p,h,stats] = signrank(indices,indices-mean(indices),'tail','right','alpha',0.05);
    [hz,pz] = ztest(IndCounts,0,0,'Tail','right');
    axes('Units','normalized','position',[xspace*6,0.4,widF,widF/2]),cla%,cla
    
    ylim([0 1])
    axxs = axis;
    set(gca,'xtick',[],'ytick',[],'color','w','xcolor','m','ycolor','m'),box off
    text(0.01,.75,['p = ' num2str((p))  ' ( signrank ) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica' ),hold on
    text(0.01,.6,['h = ' num2str((h))  ' ( signrank ) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica' ),hold on
    text(0.01,.25,['pz = ' num2str((pz)) ' ( ztest ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    text(0.01,.1,['hz = ' num2str((h)) ' ( ztest ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    
    
    
end


%%
if isfield(popDecay.Andre,'DOUBLE')
    %%
    if plotAllIndcs
        indices = Andre.allDOUBLEMemBaseIndices;
        indices = indices(find(~isnan(indices)));
        if isempty(indices),indices=0;end;
        IndCounts = histcounts(indices,inLocations);
    else
        indices = Andre.statDOUBLEMemBaseIndices;
        indices = indices(find(~isnan(indices)));
        if isempty(indices),indices=0;end;
        IndCounts = histcounts(indices,inLocations);
    end
    
    positiveIndices = indices(find(indices>0));
    negativeIndices = indices(find(indices<0));
    if plotAllIndcs
        mmI = Andre.allSimpleMemBaseIndices;
        
    end
    posMMI = indices(find(indices>0));
    negMMI = indices(find(indices>0));
    positiveIndices = indices(find(indices>0));
    negativeIndices = indices(find(indices<0));
    
    [hKSAndreDOUBLE,pKSAndreDOUBLE,kSSAndreDOUBLE] = kstest2(indices,indices-mean(indices),'tail','smaller');
    
    posMMI = indices(find(indices>0));
    negMMI = indices(find(indices<0));
    
    
    [pAndreIndPre112, hAndreIndPost112] = ranksum(indices,indices-mean(indices),'tail','right','alpha',0.05);
    
    axes('Units','normalized','position',[xspace,0.105+widF/2,widF,widF/2]),cla
    
    text(0.05,0.5,'No red monkey in this task','color','r'),set(gca,'xtick',[],'ytick',[]),box on;
    title('Indices vs unit counts -DOUBLE')
    
    axes('Units','normalized','position',[xspace,0.1,widF,widF/2]),cla
    
    
    if smoothMed
        bar(inLocations,smooth([0 IndCounts],smoothBarsLen),'b'),hold on,axis tight,
    else
        bar(inLocations,[0 IndCounts],'b'),hold on,axis tight,
        
    end
    axxs = axis; ylim([0 xs(4)+(xs(4)/10)])
    if hKSAndreDOUBLE  == 0
        text(axxs(1),axxs(4)*.8,'Not Normal','color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    end
    text(axxs(1),axxs(4)*.45,{['p = ' num2str(pKSAndreDOUBLE)]; ' (kstest) '},'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    
    [hz,pz] = ztest(indices,0,0,'Tail','right','alpha',0.05);
    
    axxs=axis;
    
    ylabel('Unit count'),xlabel('Index (Block 3 vs block 1')
    axis tight
    xs = axis; ylim([0 xs(4)+(xs(4)/10)])
    line([0 0],[0 xs(4)],'linewidth',2,'color','m')
    xlim([-1.1 1.1]),hold on
    %% title third panel
    axes('Units','normalized','position',[xspace*3.5,0.1,widF,widF/2]),cla%,clabar(inLocations,[0 IndCounts],'b'),hold on
    axxs = axis;
    ylim([0 1])
    set(gca,'xtick',[],'ytick',[],'color','w'),box off
    
    
    text(0.1,.85,['p = ' num2str(pAndreIndPre112) ' (ranksm) '],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    
    text(.02,.7,['-> medcouple: '  num2str(medcouple(IndCounts'))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','bold','fontname','helvetica'),hold on
    
    text(0.1,.4,['mean = ' num2str(nanmean(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.55,['median = ' num2str(nanmedian(indices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.25,['> 0 = ' num2str(sum(positiveIndices))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    text(0.1,.1,['< 0 = ' num2str(abs(sum(negativeIndices)))],'color',MarkerFaceColorAndre,'fontsize',10,'fontweight','normal','fontname','helvetica'),hold on
    if hAndreIndPost112, set(gca,'xtick',[],'ytick',[],'color','y'),end
    
    %% title third panel - part 2
    [p,h,stats] = signrank(indices,indices-mean(indices),'tail','right','alpha',0.05);
    
    
    axes('Units','normalized','position',[xspace*6,0.105,widF,widF/2]),cla
    
    
    ylim([0 1])
    axxs = axis;
    set(gca,'xtick',[],'ytick',[],'color','w','xcolor','m','ycolor','m'),box off
    text(0.01,.95,['p = ' num2str((p))   ' (signrank) '],'color',MarkerFaceColorAndre,'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    text(0.01,.8,['h = ' num2str((h))   ' (signrank) '],'color',MarkerFaceColorAndre,'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    
    text(0.01,.4,['pz = ' num2str((pz)) ' ( ztest ) '],'color',MarkerFaceColorAndre, 'fontweight','normal','fontname','helvetica','fontsize',10),hold on
    
    
end
stattext = ['tail, ','right, ','alpha, ','0.05)'];
stattext2 = ['tail, ','larger)'];
axes('Units','normalized','position',[xspace*8,0.505,widF,widF*6]),cla%,cla

set(gca,'xtick',[],'ytick',[],'color','w', 'xcolor','w','ycolor','w'),box off

text(-0.01,0,{'For all tests:';'h or hz = 0,'; 'means';...
    'accept NULL';'';...
    'i.e. the medians are';'NOT LARGER THAN 0';'';'Signrank'; 'hypothesis test:';''; 'the median of';...
    'the indices are';'larger than 0.';'against NULL:';'they are not.';'';...
    'Signrank values';'are calculated as:';'';'[p,h,stats] = signrank';...
    '(indices,0,0,';stattext;'';''; 'To test both mean &';'are > 0 ';'ztest values are';'calcualted as:';'';'[hz,pz] = ztest(indices,0,0,';stattext;'';...
    '';'KStest alternative hypothesis'; 'is that the population cdf'; 'of the idices is larger'; 'than the standard normal cdf';
    'KS-test values';'are calculated as:';'';'[h,p,k] = kstest(indices,';stattext2;'' },...
    'fontsize',14,'backgroundcolor',[0.951 0.951 0.951]),hold on


%%
set(gcf,'color','w')