figure(513115),clf,set(gcf,'color','w')
hfig = gcf;
set(gcf,'Name','ALL DOUBLE')
%%
loca = [0.1000    0.5217    0.3500    0.3500
    0.1000    0.0500    0.3500    0.3500
    0.4590    0.5217    0.3500    0.3500
    0.4590    0.0500    0.3500    0.3500];

%% axis limit

if plotrawall
    maxXandY = round(max([Andre.PostMemoryBaseline_ALL_GENERAL_DOUBLE_all;Andre.PostMemoryMEM_ALL_GENERAL_DOUBLE_all;...
        Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE;Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE;Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE]));
    maxXandY2= round(max([Andre.PostMemoryMEM_ALL_GENERAL_DOUBLEForVIS;Andre.PostVIS_ALL_GENERAL_DOUBLE]));
else
    maxXandY = round(max([Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE;Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE]));
    maxXandY2 = round(max([Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLEForVIS;Andre.statPostVIS_ALL_GENERAL_DOUBLE]));
end
if limitAxis
    maxXandY2 = MaxAx2_DOUBLE;
end
if limitAxis
    maxXandY = MaxAx1_DOUBLE;
end


difft = maxXandY;
if (round(difft,-1) - (difft)) < 0
    maxXandY = round(difft,-1)+ 10;
else
    maxXandY = round(difft,-1);
end

difft = maxXandY2;
if (round(difft,-1) - (difft)) < 0
    maxXandY2 = round(difft,-1)+ 10;
else
    maxXandY2 = round(difft,-1);
end

maxXandYDOUBLE = maxXandY;


%% Post saccaddic activity in the baseline (first block) vs interleaved, no stimulus in RF     post vs  pre
% subplot(3,2,3),cla


[ar ac] = size(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE);
if ac > ar, Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE= Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE'; end

[ar ac] = size(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE);
if ac > ar, Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE = Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE'; end
[RHOAndreGENERAL_DOUBLEBaseM,PVALAndreGENERAL_DOUBLEBaseM] = corr(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE,...
    Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,'Type','Spearman');

if ~doNotPlotDecays
    axes('Units','normalized','position',loca(1,:)),cla
else
    if twoRowThreePanels
        subplot(2,2,1)
    else
        subplot(3,1,1)
    end
end

[pAndrePre11, hAndrePost11] = signrank(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE,Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE);
[pAndrePre1, hAndrePost1] = ranksum(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE,Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,'tail','left');

if plotrawall
    plot(Andre.PostMemoryBaseline_ALL_GENERAL_DOUBLE_all,Andre.PostMemoryMEM_ALL_GENERAL_DOUBLE_all,'ob','LineWidth',1,'MarkerSize',circleSize),hold on
end
if plotstats
    if ~isempty(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE)
        if plotInShade
            plot(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE,Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,'om','LineWidth',1,'MarkerFaceColor',MarkerFaceColorAndre,'MarkerSize',circleSize5),hold on
        else
            plot(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE,Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
        end
    end
end
xlim([0,maxXandY+5]),hold on
ylim([0,maxXandY+5]),hold on
axis square,axxs = axis;

set(gca,'YTick',[0:maxXandY/2:maxXandY+1],'YTickLabel',[0:maxXandY/2:maxXandY+1],'XTick',[0:maxXandY/2:maxXandY+1],'XTickLabel',[0:maxXandY/2:maxXandY+1]);%[0.15 0.15 0.15]

pAndre = sprintf('%.10f', pAndrePre1);
pAndre1 = sprintf('%.10f', pAndrePre11);
text(axxs(2)*0.4,axxs(4)/1.1,['p = ' pAndre],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
if plotrawall
    text(axxs(2)*0.4,axxs(4)/1.3,['n = ' num2str(numel(Andre.PostMemoryBaseline_ALL_GENERAL_DOUBLE_all))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
else
    text(axxs(2)*0.4,axxs(4)/1.2,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
end

line([0,maxXandY+5],[0,maxXandY+5],'linewidth',2.5,'color','w'),hold on
line([0,maxXandY+5],[0,maxXandY+5],'linewidth',1.5),hold on

ylabel({'Mixed block postsaccadic (sp/s)'},'fontweight','normal','fontname','helvetica')

xlabel({'Block 1 POSTSACCADIC (sp/s)'},'fontweight','normal','fontname','helvetica')
title({'Block 1 vs Mixed (both no-probes)'},'fontweight','normal','fontname','helvetica')
ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';


%% latencis
if ~doNotPlotDecays
    axes('Units','normalized','position',loca(2,:)),cla
else
    if twoRowThreePanels
        subplot(2,2,4)
    else
        subplot(3,1,3)
    end
end

if isfield(Andre,'statmemLatDOUBLE') & ~isempty(Andre.statmemLatDOUBLE)
    if plotInShade
        plot(Andre.statmemLatDOUBLE,Andre.statVisLatDOUBLE,'om','LineWidth',1,'MarkerFaceColor',MarkerFaceColorAndre,'MarkerSize',circleSize5),hold on
    else
        plot(Andre.statmemLatDOUBLE,Andre.statVisLatDOUBLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
    end
end


minxy = min([Andre.memLatDOUBLE;Andre.visLatDOUBLE]);
maxxy = max([Andre.memLatDOUBLE;Andre.visLatDOUBLE]);


maxxy=maxxy+(5-rem(maxxy,5));
axis tight
axxs = axis;

maxxy = max([150 axxs(2) axxs(4)]);
maxxy=maxxy+(5-rem(maxxy,5));

xlim([-130 maxxy+10]),hold on

ylim([-130 maxxy+10]),hold on


line([0 0],[-130 maxxy],'Marker','.','LineStyle','--','linewidth',1),hold on,
line([-130 maxxy],[0 0],'Marker','.','LineStyle','--','linewidth',1),hold on,

if minxy == 0, minxy =-1; end
set(gca,'YTick',round([-125 0 50 100 maxxy]),'YTickLabel',round([-125 0 50 100 maxxy]),'XTick',round([-125 0 50 100 maxxy]),'XTickLabel',round([-125 0 50 100 maxxy]),'xcolor','k','ycolor','k');%[0.15 0.15 0.15]%[0.15 0.15 0.15]

text(40,maxxy-10,['> 0, n = ' num2str(numel(find(Andre.statVisLatDOUBLE >0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

text(40,maxxy-40,['= 0, n = ' num2str(numel(find(Andre.statVisLatDOUBLE ==0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

text(40,maxxy-70,['< 0, n = ' num2str(numel(find(Andre.statVisLatDOUBLE<0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

axis square
ylabel('Visual latency (ms)')
xlabel('Memory latency (ms)')
title('Visual vs memory latency')
ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';

%% VIS Post saccaddic activity in the memory(interleaved, no stimulus in RF) vs postVIS
% subplot(3,2,4),cla
if ~doNotPlotDecays
    axes('Units','normalized','position',loca(3,:)),cla
else
    if twoRowThreePanels
        subplot(2,2,2)
    else
        subplot(3,1,2)
    end
end

[pAndrePre4, hAndrePost4] = signrank(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,Andre.statPostVIS_ALL_GENERAL_DOUBLE);
[pAndrePre44, hAndrePost44] = ranksum(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE,Andre.statPostVIS_ALL_GENERAL_DOUBLE);
if plotrawall
    plot(Andre.PostMemoryMEM_ALL_GENERAL_DOUBLE_all,Andre.PostVIS_ALL_GENERAL_DOUBLE_all,'ob','LineWidth',1,'MarkerSize',circleSize),hold on
end
if plotstats
    if ~isempty(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLE)
        if plotInShade
            plot(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLEForVIS,Andre.statPostVIS_ALL_GENERAL_DOUBLE,'om','LineWidth',1,'MarkerFaceColor',MarkerFaceColorAndre,'MarkerSize',circleSize5),hold on
        else
            plot(Andre.statPostMemoryMEM_ALL_GENERAL_DOUBLEForVIS,Andre.statPostVIS_ALL_GENERAL_DOUBLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
            
        end
    end
end
xlim([0,maxXandY2+5]),hold on
ylim([0,maxXandY2+5]),hold on
axis square,axxs = axis;
line([0,maxXandY2+5],[0,maxXandY2+5],'linewidth',2.5,'color','w'),hold on
line([0,maxXandY2+5],[0,maxXandY2+5],'linewidth',1.5),hold on,hold on
set(gca,'YTick',[0:maxXandY2/2:maxXandY2+1],'YTickLabel',[0:maxXandY2/2:maxXandY2+1],...
    'XTick',[0:maxXandY2/2:maxXandY2+1],'XTickLabel',[0:maxXandY2/2:maxXandY2+1],'fontweight','normal','fontname','helvetica','xcolor','k','ycolor','k');%[0.15 0.15 0.15]%[0.15 0.15 0.15]

pAndre = sprintf('%.10f', pAndrePre4);
pAndre1 = sprintf('%.10f', pAndrePre44);
if plotrawall
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.PostMemoryBaseline_ALL_GENERAL_DOUBLE_all))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
else
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
end


ylabel({'Visual (sp/s)'},'fontweight','normal','fontname','helvetica')
xlabel({'Memory (sp/s)'},'fontweight','normal','fontname','helvetica')
title({'Memory vs visual (both postsaccadic)'},'fontweight','normal','fontname','helvetica')
ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';

hold on


xlim([0,maxXandY2+5]),hold on
ylim([0,maxXandY2+5]),hold on

%% decay
% subplot(3,2,6),cla
if plotDecay
    if ~doNotPlotDecays
        
        popDecay = evalin('base','popDecay');
        popDecayUP = evalin('base','popDecayUP');
        [neuronCbinned,~] = size(popDecay.Andre.binned_DOUBLE);
        [neuronCbinnedUP,~] = size(popDecay.Andre.binned_DOUBLEUP);
        
        popMD = popDecay.Andre.DOUBLEpopMean;
        [nc, neuronC ] = size(popDecay.Andre.DOUBLE);
        [neuronAndre,~ ] = size(popDecay.Andre.DOUBLE);
        PpopSTD = popDecay.Andre.DOUBLESTD;
        popMD = popDecay.Andre.DOUBLEpopMean;
        
        PpopSTDbase = popDecay.Andre.baseDOUBLESTD;
        popMDbase = popDecay.Andre.baseDOUBLEpopMean;
        
        maxN = max([ popMD]);
        maxB = max([ popMDbase]);
        magRatio = maxB/maxN;
        
        
        
        
        if separateDecays
            popMDUP = popDecayUP.Andre.DOUBLEpopMean;
            [ncUP, neuronCUP ] = size(popDecayUP.Andre.DOUBLE);
            [neuronAndreUP,~ ] = size(popDecayUP.Andre.DOUBLE);
            PpopSTDUP = popDecayUP.Andre.DOUBLESTD;
            popMDUP = popDecayUP.Andre.DOUBLEpopMean;
        end
        
        if plotBinnedDecay
            axes('Units','normalized','position',loca(4,:)),cla
            
            pAndPl2 = popDecay.Andre.binMeans_DOUBLE;
            if ~isempty(pAndPl2)
                
                
                
                pAndPlstd2 = popDecay.Andre.binSTDs_DOUBLE;
                
                [population2,~] = fit((1:10)', pAndPl2(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                
                plot(1:10,pAndPl2,'ob','linewidth',1),hold on
                plot(population2(1:10),'b','linewidth',4),hold on
                text(11.025,.25,[ 'n = ' num2str(neuronCbinned) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
            end
            
            pAndPl2UP = popDecay.Andre.binMeans_DOUBLEUP;
            
            if ~isempty(pAndPl2UP) & plotUP
                pAndPlstd2UP = popDecay.Andre.binSTDs_DOUBLEUP;
                [population2UP,~] = fit((1:10)', pAndPl2UP(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                
                plot(1:10,pAndPlstd2UP,'ob','linewidth',1),hold on
                plot(population2UP(1:10),'--','linewidth',4,'color',[ 0.4 0.4 1]),hold on
                
                text(11.025,-.5,[ 'n(up) = ' num2str(neuronCbinnedUP) ],'color',[ 0.3 .3 1],'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
            end
            
            axx = axis;
            ylim([min(0,axx(3)-.1) axx(4)+.01]),hold on
            
            xlim([0.5 10.5]),hold on
            
            set(gca,'xtick',[1:10],'xticklabel',{'1-10','11-20','21-30','31-40','41-50','51-60','61-70','71-80','81-90','91-100'  }),hold on
            set(gca,'FontSize',10,'XTickLabelRotation',45)
            
            
            ylabel({'Normalized activity (sp/sec)';'(Normalized using the mean of last 10 memory trials)'}),hold on
            xlabel('% total trials'),hold on
            title('population decay Activity'),hold on
            axis square
            
        else
            if plotIndivDecay
                axes('Units','normalized','position',loca(4,:)),
                for d = 1:neuronC
                    cla
                    pAndPl = (popDecay.Andre.DOUBLE(d,:));
                    [population,gof1] = fit((1:fitUpTo)', pAndPl(1:fitUpTo)',fitMeth,'Normalize','on','Robust','Bisquare');
                    plot(pAndPl(1:fitUpTo),'ob'),hold on
                    plot(population(1:fitUpTo),'b','linewidth',3)
                    axx = axis;
                    ylim([0 axx(4)])
                    xlim([1 fitUpTo])
                    title([num2str(d) '/' num2str(neuronC)])
                    
                    waitforbuttonpress,
                    cla
                    
                end
            else
                if plotDecayTruncated
                    lineThickDividor = 3;
                    axes('Units','normalized','position',loca(4,:)),cla
                    if plotlast10trials
                        stdadrdsA  = [std(popMD(1:10))/sqrt(10) std(popMD(end-9:end))/sqrt(10)];
                        
                        stdadrdsC  = [std(popMDUP(1:10))/sqrt(10) std(popMDUP(end-9:end))/sqrt(10)];
                        meanA = mean(popMD(1:10));
                        meanB = mean(popMD(end-9:end));
                        if separateDecays
                            meanI = mean(popMDUP(1:10));
                            meanJ = mean(popMDUP(end-9:end));
                        end
                    else
                        stdadrdsA  = [std(popMD(1:10))/sqrt(10) std(popMD(fitUpTo-9:fitUpTo))/sqrt(10)];
                        
                        stdadrdsC  = [std(popMDUP(1:10))/sqrt(10) std(popMDUP(fitUpTo-9:fitUpTo))/sqrt(10)];
                        
                        meanA = mean(popMD(1:10));
                        meanB = mean(popMD(fitUpTo-9:fitUpTo));
                        
                        
                        if separateDecays
                            meanI = mean(popMDUP(1:10));
                            meanJ = mean(popMDUP(fitUpTo-9:fitUpTo));
                            
                        end
                    end
                    
                    errorbar([meanA meanB ],stdadrdsA,'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                    
                    line([1 2],[meanA meanB ],'color','b','linewidth',neuronAndre/lineThickDividor,'linestyle','-.')
                    
                    
                    xlim([0.5 2.5])
                    if separateDecays
                        errorbar([meanI meanJ ],stdadrdsC,'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                        
                        line([1 2],[meanI meanJ ],'color','b','linewidth',neuronCUP/lineThickDividor,'linestyle','-.')
                    end
                    
                    
                    axis tight
                    set(gca,'xtick',[],'ytick',[])
                    axxs = axis;
                    
                    if axxs(4)<=2 & axxs(4)> 1
                        ylimTop =2;
                    elseif axxs(4)==1
                        ylimTop =1;
                    elseif axxs(4)<=3
                        ylimTop =3;
                    elseif axxs(4)<=4
                        ylimTop =4;
                    elseif axxs(4)<=5
                        ylimTop =5;
                    elseif axxs(4)<=6
                        ylimTop =6;
                    else
                        ylimTop =round(axxs(4));
                    end
                    
                    if axxs(4) > 1
                        set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                    else
                        
                        set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                    end
                    set(gca,'xtick',[1  2],'xticklabel',{'1-10' ,  [num2str(fitUpTo-10) '-' num2str(fitUpTo)]})
                    if  plotlast10trials
                        set(gca,'xtick',[1  2],'xticklabel',{'1-10' , ['' num2str(numel(popMD)-10)  '-' num2str(numel(popMD)+1) '']})
                        
                    end
                    xlim([0.9 2.1])
                    axxs = axis;
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Trial number (Starting from last stimulus trial)')
                    title('population decay Activity')
                    axis square
                    
                    rsqAndre = sprintf('%.10f', popDecay.Andre.DOUBLErsquare);
                    
                    
                    maxYtxt = sprintf('%.10f', axxs(4) );
                    midYtxt = sprintf('%.10f', axxs(4)/2);
                    
                    pvAnd = sprintf('%.4f', Andre.PopDecay.pRS_Double); if sum(str2num(pvAnd)) == 0,pvAnd = 0.0001;end
                    if separateDecays
                        pvAndUP = sprintf('%.4f', Andre.PopDecayUP.pRS_Double); if sum(str2num(pvAndUP)) == 0,pvAndUP = 0.0001;end
                    end
                    
                    text(0.925,meanA+.1,[ 'n = ' num2str(neuronAndre) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    if separateDecays
                        text(0.925,meanI+.12,[ 'n = ' num2str(neuronAndreUP) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        
                        text(1.6025,meanJ+.1,[ 'p < ' num2str(pvAnd) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(1.6025,meanB-.105,[ 'p < ' num2str(pvAndUP) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    end
                else
                    if separateDecays
                        axes('Units','normalized','position',[loca(4,1:2) loca(4,3) loca(4,4)/2]),cla
                    else
                        axes('Units','normalized','position',loca(4,:)),cla
                    end
                    yyaxis left
                    fitUpTo = min(numel(popMD),fitUpTo);
                    
                    plot(popMD(1:fitUpTo),'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                    
                    plot(popDecay.Andre.DOUBLEpopulation(1:fitUpTo), '-.b','LineWidth',2), hold on
                    
                    axis tight
                    axxs = axis;
                    y1axxs4 =  axxs(4);
                    xlim([0 fitUpTo])
                    
                    
                    
                    minxy = min([popMD(1:fitUpTo)]);
                    maxxy = max([popMD(1:fitUpTo)]);
                    
                    rsqAndre = sprintf('%.10f', popDecay.Andre.DOUBLErsquare);
                    
                    maxYtxt = sprintf('%.10f', axxs(4) );
                    midYtxt = sprintf('%.10f', axxs(4)/2);
                    pvAnd = sprintf('%.10f', Andre.PopDecay.pRS_Double);
                    
                    
                    text(2,axxs(4)/4,[ 'p = ' num2str(pvAnd) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    text(2,axxs(4)/12.85,[ 'prsn: ' num2str(Andre.PVALAndreDOUBLEBaseM)],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    
                    text(2,axxs(4)/0.8,[ '(n = ' num2str(neuronAndre)  ' ;      rsquare: ' rsqAndre ')'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    names = coeffnames(popDecay.Andre.DOUBLEpopulation);
                    if strmatch(fitMeth,'exp2')
                        text(2,axxs(4)/6.05,[ ' decay: ' num2str([popDecay.Andre.DOUBLEpopulation.b  popDecay.Andre.DOUBLEpopulation.d]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    elseif ismember('b',names)
                        text(2,axxs(4)/6.05,[ ' decay: ' num2str(popDecay.Andre.DOUBLEpopulation.b) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                    end
                    
                    
                    difft = ceil(axxs(4))-axxs(4);
                    if difft > 0.25
                        ylimTop = axxs(4) + (difft-0.25);
                    else
                        ylimTop = ceil(axxs(4));
                    end
                    
                    if axxs(4) > 1
                        set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                    else
                        
                        set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                    end
                    
                    set(gca,'XTick',[1 fitUpTo/2 fitUpTo],'XTickLabel',[1 fitUpTo/2 fitUpTo],'xcolor','k','ycolor','k');%[0.15 0.15 0.15]
                    
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Trial number (Starting from last stimulus trial)')
                    title('population decay Activity')
                    
                    ylim([0  ylimTop+.15])
                    ytop1 = ylimTop;
                    axxs = axis;
                    y1ylim = axxs(4);
                    
                    set(gca,'XTick',[1 fitUpTo/2 fitUpTo],'XTickLabel',[1 fitUpTo/2 fitUpTo],'xcolor','k','ycolor','k');
                    
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Total number starting from last stimulus trial)')
                    title('population decay Activity')
                    if plotMemVsBase
                        yyaxis right
                        
                        plot(popMDbase(1:fitUpTo),'ob','LineWidth',1,'MarkerSize',circleSize3,'MarkerFaceColor','b'),hold on
                        plot(popDecay.Andre.baseDOUBLEpopulation(1:fitUpTo), '-b','LineWidth',2), hold on
                        axis tight
                        xlim([0 fitUpTo])
                        
                        axxs = axis;
                        minxy = min([popMDbase(1:fitUpTo); popMDbase(1:fitUpTo)]);
                        maxxy = max([popMDbase(1:fitUpTo); popMDbase(1:fitUpTo)]);
                        
                        rsqAndre = sprintf('%.10f', popDecay.Andre.baseDOUBLErsquare);
                        
                        maxYtxt = sprintf('%.10f', axxs(4) );
                        midYtxt = sprintf('%.10f', axxs(4)/2);
                        
                        namesA = coeffnames(popDecay.Andre.baseDOUBLEpopulation);
                        
                        text(30,axxs(4)/1.6,[ '(n = ' num2str(neuronC) ' ; rsquare: ' rsqAndre ')'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        if strmatch(fitMeth,'exp2')
                            text(30,axxs(4)/1.41,[ 'decay: ' num2str([popDecay.Andre.baseDOUBLEpopulation.b  popDecay.Andre.baseDOUBLEpopulation.d]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        else
                            if ismember('b',namesA)
                                text(30,axxs(4)/1.41,[ 'decay: ' num2str([popDecay.Andre.baseDOUBLEpopulation.b ]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            end
                        end
                        
                        
                        difft = ceil(axxs(4))-axxs(4);
                        if difft > 0.5
                            ylimTop = axxs(4) + (difft-0.5);
                        else
                            ylimTop = ceil(axxs(4));
                        end
                        
                        ytop1 = ytop1*magRatio;
                        if axxs(4) > 1
                            set(gca,'ytick',[0 round(ytop1/2)  round(ytop1)],'yticklabel',[0 round(ytop1/2) round(ytop1)]),  hold on
                        else
                            
                            set(gca,'ytick',[0  ytop1],'yticklabel',[axxs(3)  ytop1]),  hold on
                        end
                        difft = (magRatio*y1ylim);
                        if (round(difft,-1) - (magRatio*y1ylim)) < 0
                            ylimTop = round(difft,-1)+ 5;
                        else
                            ylimTop = round(difft,-1);
                        end
                        
                        ylim([0   ytop1+5]),  hold on
                        
                        xlim([0 fitUpTo+1]),  hold on
                        
                        hold on
                    end
                    
                    
                    if DecayGoodOnly & separateDecays
                        fitUpTo = min(numel(popMDUP),fitUpTo);
                        errorbar(popMDUP(1:fitUpTo),PpopSTDUP(1:fitUpTo),'om','LineWidth',1,'MarkerSize',circleSize3),hold on
                        plot(popDecayUP.Andre.DOUBLEpopulation(1:fitUpTo), '-.m','LineWidth',2), hold on
                        
                        
                        rsqAndreUP = sprintf('%.10f', popDecayUP.Andre.DOUBLErsquare);
                        
                        maxYtxt = sprintf('%.10f', axxs(4) );
                        midYtxt = sprintf('%.10f', axxs(4)/2);
                        pvAndUP = sprintf('%.10f', Andre.PopDecayUP.pRS_Double);
                        
                        
                        text(25,axxs(4)/1.25,[ 'p = ' num2str(pvAndUP) ],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(5,axxs(4)/1.35,[ '(n = ' num2str(neuronAndreUP)  ' ;       rsquare: ' rsqAndre ')'],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        if isfield(popDecayUP.Andre.DOUBLEpopulation,'d')
                            text(2,axxs(4)/1.45,[ ' build rate: ' num2str([popDecayUP.Andre.DOUBLEpopulation.b  popDecayUP.Andre.DOUBLEpopulation.d]) ' trials'],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            text(10,axxs(4)/1.55,[ 'prsn: ' num2str(Andre.PVALAndreDOUBLEBaseMUP)],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        else
                            text(2,axxs(4)/1.45,[ ' build rate: ' num2str(popDecayUP.Andre.DOUBLEpopulation.b) ' trials'],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            text(10,axxs(4)/1.55,[ 'prsn: ' num2str(Andre.PVALAndreDOUBLEBaseMUP)],'color','m','fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        end
                        
                        
                        
                        
                        
                        
                        
                        
                        
                        axiss=axis;
                        
                        difft = ceil(axxs(4))-axxs(4);
                        if difft > 0.5
                            ylimTop = axxs(4) + (difft-0.5);
                        else
                            ylimTop = ceil(axxs(4));
                        end
                        
                        if axxs(4) > 1
                            set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                        else
                            
                            set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                        end
                        
                        set(gca,'XTick',[1 fitUpTo/2 fitUpTo],'XTickLabel',[1 fitUpTo/2 fitUpTo],'xcolor','k','ycolor','k');
                        ylim([0  ylimTop+0.1])
                        ylabel('Normalized activity (sp/sec)')
                        xlabel('Total number (Andre.starting from last stimulus trial)')
                        title('population decay Activity')
                        axis square
                        % end
                    end
                end
            end
            ax = gca; ax.LineWidth = 1;
            ax.XColor ='k';ax.YColor ='k';
        end
        axis square
        ax = gca; ax.LineWidth = 1;
        ax.XColor ='k';ax.YColor ='k';
    end
end
%% legend panel
linespaci = 0.001;
axes('Units','normalized','position',loca(1,:)+[0.65 -0.2  -0.2 0]),cla,axis off

text(0,9,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))   '/' num2str(( Andre.StatDOUBLEpopCount)) ' (stat/NoEyePos_with_vis_pop )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on

text(0.1,5,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))  '/' num2str((Andre.ALlDoubleCount))  ' (stat/recorded )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0.1,0,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))  '/' num2str((Andre.ALlDoubleCountNoStat)) ' (stat/above indices )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0.1,-5,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_GENERAL_DOUBLE))   '/' num2str((Andre.ALlDoubleCountSTATMAXTWOWAY))  ' (stat/statMaxTwoWay )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on


ylim([-6 6])
xlim([0 2])
title(' DOUBLE STEP task','fontsize',20)
axis off
