figure(5110015),clf,set(gcf,'color','w')
hfig = gcf;
set(gcf,'Name','ALL SIMPLE')
%%
loca = [   0.1000    0.5217    0.3500    0.3500
    0.1000    0.0500    0.3500    0.3500
    0.4590    0.5217    0.3500    0.3500
    0.4590    0.0500    0.3500    0.3500];


%% axis limit
if limitAxis
    maxXandY2 = MaxAx2_SIMPLE;
end

if plotrawall
    maxXandY = round(max([Andre.PostMemoryBaseline_ALL_SIMPLE_all;Andre.PostMemoryMEM_ALL_SIMPLE_all;Sara.PostMemoryBaseline_ALL_SIMPLE_all;Sara.PostMemoryMEM_ALL_SIMPLE_all;...
        Andre.statPreMemoryBaseline_ALL_SIMPLE;Andre.statPostMemoryBaseline_ALL_SIMPLE;Sara.statPreMemoryBaseline_ALL_SIMPLE;Sara.statPostMemoryBaseline_ALL_SIMPLE]));
    maxXandY2 = round(max([Andre.statPostMemoryMEM_ALL_SIMPLE;Andre.statPostVIS_ALL_SIMPLE;Sara.statPostMemoryMEM_ALL_SIMPLE;Sara.statPostVIS_ALL_SIMPLE]));
else
    maxXandY = round(max([Andre.statPostMemoryBaseline_ALL_SIMPLE;Andre.statPostMemoryMEM_ALL_SIMPLE;...
        Sara.statPostMemoryBaseline_ALL_SIMPLE;Sara.statPostMemoryMEM_ALL_SIMPLE]));
    maxXandY2 = round(max([Andre.statPostMemoryMEM_ALL_SIMPLEForVIS;Andre.statPostVIS_ALL_SIMPLE;Sara.statPostMemoryMEM_ALL_SIMPLEForVIS;Sara.statPostVIS_ALL_SIMPLE]));
end

maxXandYSIMPLE = maxXandY;

difft = maxXandY;
if (round(difft,-1) - (difft)) < 0
    maxXandY = round(difft,-1)+ 5;
else
    maxXandY = round(difft,-1);
end

difft = maxXandY2;
if (round(difft,-1) - (difft)) < 0
    maxXandY2 = round(difft,-1)+ 5;
else
    maxXandY2 = round(difft,-1);
end


%% Post saccaddic activity in the baseline (first block) vs interleaved, no stimulus in RF     post vs  pre
% subplot(3,2,3),cla



if ~doNotPlotDecays
    axes('Units','normalized','position',loca(1,:)),cla
else
    if twoRowThreePanels
        subplot(2,2,1)
    else
        subplot(3,1,1)
    end
end

[ar ac] = size(Andre.statPostMemoryBaseline_ALL_SIMPLE);
if ac > ar, Andre.statPostMemoryBaseline_ALL_SIMPLE= Andre.statPostMemoryBaseline_ALL_SIMPLE'; end

[ar ac] = size(Andre.statPostMemoryMEM_ALL_SIMPLE);
if ac > ar, Andre.statPostMemoryMEM_ALL_SIMPLE= Andre.statPostMemoryMEM_ALL_SIMPLE'; end

[ar ac] = size(Sara.statPostMemoryBaseline_ALL_SIMPLE);
if ac > ar, Sara.statPostMemoryBaseline_ALL_SIMPLE= Sara.statPostMemoryBaseline_ALL_SIMPLE'; end

[ar ac] = size(Sara.statPostMemoryMEM_ALL_SIMPLE);
if ac > ar, Sara.statPostMemoryMEM_ALL_SIMPLE= Sara.statPostMemoryMEM_ALL_SIMPLE'; end

[pAndrePre11, hAndrePost11] = signrank(Andre.statPostMemoryBaseline_ALL_SIMPLE,Andre.statPostMemoryMEM_ALL_SIMPLE);
[pAndrePre1, hAndrePost1] = ranksum(Andre.statPostMemoryBaseline_ALL_SIMPLE,Andre.statPostMemoryMEM_ALL_SIMPLE,'tail','left');

[hAndrePreKS, pAndrePostKS] = kstest([Andre.statPostMemoryBaseline_ALL_SIMPLE;Andre.statPostMemoryMEM_ALL_SIMPLE]);


[RHOAndreSIMPLEBaseM,PVALAndreSIMPLEBaseM] = corr(Andre.statPostMemoryBaseline_ALL_SIMPLE,Andre.statPostMemoryMEM_ALL_SIMPLE,'Type','Spearman');

if ~isempty(Sara.PostMemoryBaseline_ALL_SIMPLE)
    [pSaraPre11, hSaraPost11] = signrank(Sara.statPostMemoryBaseline_ALL_SIMPLE,Sara.statPostMemoryMEM_ALL_SIMPLE);
    [pSaraPre1, hSaraPost1] = ranksum(Sara.statPostMemoryBaseline_ALL_SIMPLE,Sara.statPostMemoryMEM_ALL_SIMPLE,'tail','left');
    [RHOSaraSIMPLEBaseM,PVALSaraSIMPLEBaseM] = corr(Sara.PostMemoryBaseline_ALL_SIMPLE_all,Sara.PostMemoryMEM_ALL_SIMPLE_all,'Type','Spearman');
end

% %all
if plotrawall
    plot(Andre.PostMemoryBaseline_ALL_SIMPLE_all,Andre.PostMemoryMEM_ALL_SIMPLE_all,'ob','LineWidth',1,'MarkerSize',circleSize),hold on
    if plotBeni
        plot(Sara.PostMemoryBaseline_ALL_SIMPLE_all,Sara.PostMemoryMEM_ALL_SIMPLE_all,'^r','LineWidth',1,'MarkerSize',circleSize),hold on
    end
end
if plotstats
    if ~isempty(Andre.statPostMemoryBaseline_ALL_SIMPLE)
        if plotInShade
            plot(Andre.statPostMemoryBaseline_ALL_SIMPLE,Andre.statPostMemoryMEM_ALL_SIMPLE,'om','MarkerFaceColor',MarkerFaceColorAndre,'LineWidth',1,'MarkerSize',circleSize5),hold on
            if plotBeni
                plot(Sara.statPostMemoryBaseline_ALL_SIMPLE,Sara.statPostMemoryMEM_ALL_SIMPLE,'^w','MarkerFaceColor',MarkerFaceColorSara,'LineWidth',1,'MarkerSize',circleSize55),hold on
            end
        else
            plot(Andre.statPostMemoryBaseline_ALL_SIMPLE,Andre.statPostMemoryMEM_ALL_SIMPLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
            if plotBeni
                plot(Sara.statPostMemoryBaseline_ALL_SIMPLE,Sara.statPostMemoryMEM_ALL_SIMPLE,'^r','LineWidth',1,'MarkerSize',circleSize55),hold on
            end
        end
        
    end
end
xlim([0,maxXandY+5]),hold on
ylim([0,maxXandY+5]),hold on
axis square,axxs = axis;

set(gca,'YTick',[0:maxXandY/2:maxXandY+1],'YTickLabel',[0:maxXandY/2:maxXandY+1],'XTick',[0:maxXandY/2:maxXandY+1],'XTickLabel',[0:maxXandY/2:maxXandY+1]);%[0.15 0.15 0.15]


pAndre = sprintf('%.10f', pAndrePre1);
pAndre1 = sprintf('%.10f', pAndrePre11);
pSara = sprintf('%.10f', pSaraPre1);
pSara1 = sprintf('%.10f', pSaraPre11);

text(axxs(2)*0.45,axxs(4)/1.1,['p = ' pAndre],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

text(axxs(2)*0.45,axxs(4)/1.2,['p = ' pSara],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
if plotrawall
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.PostMemoryBaseline_ALL_SIMPLE_all))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
    if plotBeni
        text(axxs(2)*0.4,axxs(4)/3.5,['n = ' num2str(numel(Sara.PostMemoryBaseline_ALL_SIMPLE_all))],'color',MarkerFaceColorSara,'fontsize',13),hold on
    end
else
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
    if plotBeni
        text(axxs(2)*0.4,axxs(4)/3.5,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE))],'color',MarkerFaceColorSara,'fontsize',13),hold on
    end
end
ylabel({'Mixed block postsaccadic (sp/s)'},'fontweight','normal','fontname','helvetica')

xlabel({'Block 1 POSTsaccadic(sp/s)'},'fontweight','normal','fontname','helvetica')
title({'Block 1 vs Mixed (both no-probes)'},'fontweight','normal','fontname','helvetica')
line([0,maxXandY+5],[0,maxXandY+5],'linewidth',2.5,'color','w'),hold on
line([0,maxXandY+5],[0,maxXandY+5],'linewidth',1.5),hold on,hold on

ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';



%% latencies
if ~doNotPlotDecays
    axes('Units','normalized','position',loca(2,:)),cla
else
    if twoRowThreePanels
        subplot(2,2,4)
    else
        subplot(3,1,3)
    end
    
end



if isfield(Andre,'statmemLatSIMPLE') & ~isempty(Andre.statmemLatSIMPLE)
    if plotInShade
        plot(Andre.statmemLatSIMPLE,Andre.statVisLatSIMPLE,'om','LineWidth',1,'MarkerFaceColor',MarkerFaceColorAndre,'MarkerSize',circleSize5),hold on
    else
        plot(Andre.statmemLatSIMPLE,Andre.statVisLatSIMPLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
    end
end
if isfield(Sara,'statmemLatSIMPLE') & ~isempty(Sara.statmemLatSIMPLE) &  plotBeni
    if plotInShade
        plot(Sara.statmemLatSIMPLE,Sara.statVisLatSIMPLE,'^r','LineWidth',1,'MarkerFaceColor',MarkerFaceColorSara,'MarkerSize',circleSize5),hold on
    else
        plot(Sara.statmemLatSIMPLE,Sara.statVisLatSIMPLE,'^r','LineWidth',1,'MarkerSize',circleSize5),hold on
    end
end

minxy = min([Sara.memLatSIMPLE;Sara.visLatSIMPLE;Andre.memLatSIMPLE;Andre.visLatSIMPLE]);
maxxy = max([Sara.memLatSIMPLE;Sara.visLatSIMPLE;Andre.memLatSIMPLE;Andre.visLatSIMPLE]);
axis tight
axxs = axis;


maxxy = max([150 axxs(2) axxs(4)]);
maxxy=maxxy+(5-rem(maxxy,5));


xlim([-130 maxxy+10]),hold on

ylim([-130 maxxy+10]),hold on


line([0 0],[-130 maxxy],'Marker','.','LineStyle','--','linewidth',1),hold on,
line([-130 maxxy],[0 0],'Marker','.','LineStyle','--','linewidth',1),hold on,


if minxy == 0, minxy =-1; end
set(gca,'YTick',round([-125 0 50 100 maxxy]),'YTickLabel',round([-125 0 50 100 maxxy]),'XTick',round([-125 0 50 100 maxxy]),'XTickLabel',round([-125 0 50 100 maxxy]),'xcolor','k','ycolor','k');%[0.15 0.15 0.15]%[0.15 0.15 0.15]

text(-100,maxxy/1.1,['> 0, n = ' num2str(numel(find(Andre.statVisLatSIMPLE>0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
text(40,maxxy/1.1,['> 0, n = ' num2str(numel(find(Sara.statVisLatSIMPLE>0)))],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

text(-100,maxxy/1.4,['= 0, n = ' num2str(numel(find(Andre.statVisLatSIMPLE ==0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
text(40,maxxy/1.4,['= 0, n = ' num2str(numel(find(Sara.statVisLatSIMPLE==0)))],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on

text(-100,maxxy/2,['< 0, n = ' num2str(numel(find(Andre.statVisLatSIMPLE<0)))],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
text(40,maxxy/2,['< 0, n = ' num2str(numel(find(Sara.statVisLatSIMPLE<0)))],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on


axis square
ylabel('Visual latency (ms)')
xlabel('Memory latency (ms)')
title('Visual vs memory latency')
ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';

%% VIS  Post saccaddic activity in the memory(interleaved, no stimulus in RF) vs postVIS
% subplot(3,2,4),cla
if ~doNotPlotDecays
    axes('Units','normalized','position',loca(3,:)),cla
    
else
    
    if twoRowThreePanels
        subplot(2,2,2)
    else
        subplot(3,1,2)
    end
end

[pAndrePre4, hAndrePost4] = signrank(Andre.statPostMemoryMEM_ALL_SIMPLE,Andre.statPostVIS_ALL_SIMPLE);
[pAndrePre44, hAndrePost44] = ranksum(Andre.statPostMemoryMEM_ALL_SIMPLE,Andre.statPostVIS_ALL_SIMPLE);
if ~isempty(Sara.PostMemoryMEM_ALL_SIMPLE)
    [pSaraPre4, hSaraPost4] = signrank(Sara.statPostMemoryMEM_ALL_SIMPLE,Sara.statPostVIS_ALL_SIMPLE);
    [pSaraPre44, hSaraPost44] = ranksum(Sara.statPostMemoryMEM_ALL_SIMPLE,Sara.statPostVIS_ALL_SIMPLE);
end

if plotrawall
    plot(Andre.PostMemoryMEM_ALL_SIMPLE_all,Andre.PostVIS_ALL_SIMPLE_all,'ob','LineWidth',1,'MarkerSize',circleSize),hold on
    if plotBeni
        plot(Sara.PostMemoryMEM_ALL_SIMPLE_all,Sara.PostVIS_ALL_SIMPLE_all,'^r','LineWidth',1,'MarkerSize',circleSize),hold on
    end
end
if plotstats
    if ~isempty(Andre.statPostMemoryMEM_ALL_SIMPLE)
        if plotInShade
            plot(Andre.statPostMemoryMEM_ALL_SIMPLE,Andre.statPostVIS_ALL_SIMPLE,'om','LineWidth',1,'MarkerFaceColor',MarkerFaceColorAndre,'MarkerSize',circleSize5),hold on
            if plotBeni
                plot(Sara.statPostMemoryMEM_ALL_SIMPLE,Sara.statPostVIS_ALL_SIMPLE,'^w','LineWidth',1,'MarkerFaceColor',MarkerFaceColorSara,'MarkerSize',circleSize5),hold on
            end
        else
            plot(Andre.statPostMemoryMEM_ALL_SIMPLEForVIS,Andre.statPostVIS_ALL_SIMPLE,'ob','LineWidth',1,'MarkerSize',circleSize5),hold on
            if plotBeni
                plot(Sara.statPostMemoryMEM_ALL_SIMPLEForVIS,Sara.statPostVIS_ALL_SIMPLE,'^r','LineWidth',1,'MarkerSize',circleSize5),hold on
            end
        end
        
    end
end
xlim([0,maxXandY2+5]),hold on
ylim([0,maxXandY2+5]),hold on
axis square,axxs = axis;

set(gca,'YTick',[0:maxXandY2/2:maxXandY2+1],'YTickLabel',[0:maxXandY2/2:maxXandY2+1],...
    'XTick',[0:maxXandY2/2:maxXandY2+1],'XTickLabel',[0:maxXandY2/2:maxXandY2+1],'fontweight','bold','fontname','helvetica','xcolor','k','ycolor','k');%[0.15 0.15 0.15]%[0.15 0.15 0.15]

pAndre = sprintf('%.10f', pAndrePre4);
pAndre1 = sprintf('%.10f', pAndrePre44);
pSara = sprintf('%.10f', pSaraPre4);
pSara1 = sprintf('%.10f', pSaraPre44);


if plotrawall
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.PostMemoryBaseline_ALL_SIMPLE_all))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
    text(axxs(2)*0.4,axxs(4)/3.5,['n = ' num2str(numel(Sara.PostMemoryBaseline_ALL_SIMPLE_all))],'color',MarkerFaceColorSara,'fontsize',13),hold on
    
else
    text(axxs(2)*0.4,axxs(4)/3,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE))],'color',MarkerFaceColorAndre,'fontsize',13),hold on
    text(axxs(2)*0.4,axxs(4)/3.5,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE))],'color',MarkerFaceColorSara,'fontsize',13),hold on
end

ylabel({'Visual (sp/s)'},'fontweight','normal','fontname','helvetica')
xlabel({'Memory (sp/s)'},'fontweight','normal','fontname','helvetica')
title({'Memory vs visual (both postsaccadic)'},'fontweight','normal','fontname','helvetica')
line([0,maxXandY2+5],[0,maxXandY2+5],'linewidth',2.5,'color','w'),hold on
line([0,maxXandY2+5],[0,maxXandY2+5],'linewidth',1.5),hold on,hold on
ax = gca; ax.LineWidth = 1;
ax.XColor ='k';ax.YColor ='k';

hold on




%% decay
% subplot(3,2,6),cla
if plotDecay
    if ~doNotPlotDecays
        
        popDecay = evalin('base','popDecay');
        popDecayUP = evalin('base','popDecayUP');
        [neuronCbinned,~] = size(popDecay.Andre.binned_simple);
        [neuronCbinned2,~] = size(popDecay.Sara.binned_simple);
        [neuronCbinnedUP,~] = size(popDecay.Andre.binned_simpleUP);
        [neuronCbinned2UP,~] = size(popDecay.Sara.binned_simpleUP);
        
        
        
        [neuronC ,nc, ] = size(popDecay.Andre.SIMPLE);
        [neuronCB ,ncB ] = size(popDecay.Sara.SIMPLE);
        
        [neuronAndre,~ ] = size(popDecay.Andre.SIMPLE);
        [neuronBeni,~ ] = size(popDecay.Sara.SIMPLE);
        
        PpopSTD = popDecay.Andre.SIMPLESTD;
        popMD = popDecay.Andre.SIMPLEpopMean;
        
        PpopSTDBeni = popDecay.Sara.SIMPLESTD;
        popMDBeni =  popDecay.Sara.SIMPLEpopMean;
        meanBeniPopDecSIMPLE = mean(popDecay.Sara.SIMPLE');
        
        
        PpopSTDbase = popDecay.Andre.baseSIMPLESTD;
        popMDbase = popDecay.Andre.baseSIMPLEpopMean;
        
        PpopSTDBenibase = popDecay.Sara.baseSIMPLESTD;
        popMDBenibase =  popDecay.Sara.baseSIMPLEpopMean;
        
        maxN = max([popMDBeni;popMD]);
        maxB = max([popMDBenibase;popMDbase]);
        magRatio = maxB/maxN;
        
        if separateDecays
            popMDUP = popDecayUP.Andre.SIMPLEpopMean;
            [neuronCUP ,ncUP ] = size(popDecayUP.Andre.SIMPLE);
            [neuronCBUP ,ncBUP ] = size(popDecayUP.Sara.SIMPLE);
            
            [neuronAndreUP,~ ] = size(popDecayUP.Andre.SIMPLE);
            [neuronBeniUP,~ ] = size(popDecayUP.Sara.SIMPLE);
            PpopSTDUP = popDecayUP.Andre.SIMPLESTD;
            popMUPD = popDecayUP.Andre.SIMPLEpopMean;
            
            PpopSTDBeniUP = popDecayUP.Sara.SIMPLESTD;
            popMDBeniUP =  popDecayUP.Sara.SIMPLEpopMean;
            meanBeniPopDecSIMPLEUP = mean(popDecay.Sara.SIMPLE');
        end
        fitUpTo = min(numel(popMD),fitUpTo);
        
        if plotBinnedDecay
            axes('Units','normalized','position',loca(4,:)),cla
            pAndPl = popDecay.Sara.binMeans_simple;
            if ~isempty(pAndPl)
                pAndPlstd = popDecay.Sara.binSTDs_simple;
                [population,~] = fit((1:10)', pAndPl(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                
                plot(1:10,pAndPl,'^r','linewidth',1),hold on
                plot(population(1:10),'r','linewidth',4),hold on
                text(7,.1,[ 'n = ' num2str(neuronCbinned2) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                
            end
            pAndPl2 = popDecay.Andre.binMeans_simple;
            if ~isempty(pAndPl2)
                pAndPlstd2 = popDecay.Andre.binSTDs_simple;
                
                [population2,~] = fit((1:10)', pAndPl2(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                
                plot(1:10,pAndPl2,'ob','linewidth',1),hold on
                plot(population2(1:10),'b','linewidth',4),hold on
                text(9,.25,[ 'n = ' num2str(neuronCbinned) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
            end
            %
            pAndPlUPUP = popDecay.Sara.binMeans_simpleUP;
            if ~isempty( pAndPlUPUP )
                pAndPlstdUP = popDecay.Sara.binSTDs_simpleUP;
                [populationUP,~] = fit((1:10)', pAndPlUPUP(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                
                plot(1:10,pAndPlUPUP,'^r','linewidth',1),hold on
                plot(populationUP(1:10),'--','linewidth',4,'color',[1 0.4 0.4]),hold on
                text(11.025,.25,[ 'n(up) = '  num2str(neuronCbinned2UP) ],'color',[1 0.3 .3],'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                
            end
            pAndPl2UP = popDecay.Andre.binMeans_simpleUP;
            
            if ~isempty(pAndPl2UP) & plotUP
                pAndPlstd2UP = popDecay.Andre.binSTDs_simpleUP;
                [population2UP,~] = fit((1:10)', pAndPl2UP(1:10)',fitMeth,'Normalize','on','Robust','Bisquare');
                plot(1:10,pAndPl2UP,'ob','linewidth',1),hold on
                plot(population2UP(1:10),'--','linewidth',4,'color',[ 0.4 0.4 1]),hold on
                text(11.025,-.5,[ 'n(up) = ' num2str(neuronCbinnedUP) ],'color',[0.3 0.3 1],'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                
            end
            
            
            axx = axis;
            ylim([min(0,axx(3)-.1) axx(4)+.01]),hold on
            
            xlim([0.5 10.5]),hold on
            set(gca,'xtick',[1:10],'xticklabel',{'1-10','11-20','21-30','31-40','41-50','51-60','61-70','71-80','81-90','91-100'  }),hold on
            set(gca,'FontSize',10,'XTickLabelRotation',45)
            ylabel({'Normalized activity (sp/sec)';'(Normalized using the mean of last 10 memory trials)'}),hold on
            xlabel('% total trials'),hold on
            title('population decay Activity'),hold on
            axis square
        else
            if plotIndivDecay
                axes('Units','normalized','position',loca(4,:)),
                for d = 1:neuronC
                    cla
                    pAndPl = (popDecay.Andre.SIMPLE(d,:));
                    [population,gof1] = fit((1:fitUpTo)', pAndPl(1:fitUpTo)',fitMeth,'Normalize','on','Robust','Bisquare');
                    
                    plot(pAndPl(1:fitUpTo),'ob'),hold on
                    plot(population(1:fitUpTo),'b','linewidth',3)
                    axx = axis;
                    ylim([0 axx(4)])
                    xlim([1 fitUpTo])
                    title([num2str(d) '/' num2str(neuronC)])
                    
                    waitforbuttonpress,
                    cla
                    
                end
                for d = 1:neuronCB
                    cla
                    pAndPl = (popDecay.Sara.SIMPLE(d,:));
                    [population,gof1] = fit((1:fitUpTo)', pAndPl(1:fitUpTo)',fitMeth,'Normalize','on','Robust','Bisquare');
                    plot(pAndPl(1:fitUpTo),'^r'),hold on
                    plot(population(1:fitUpTo),'r','linewidth',3)
                    axx = axis;
                    ylim([0 axx(4)])
                    xlim([1 fitUpTo])
                    title([num2str(d) '/' num2str(neuronCB)])
                    
                    waitforbuttonpress,
                    cla
                    
                end
            else
                if plotDecayTruncated
                    lineThickDividor = 3;
                    axes('Units','normalized','position',loca(4,:)),cla
                    if plotlast10trials
                        stdadrdsA  = [std(popMD(1:10))/sqrt(10) std(popMD(end-9:end))/sqrt(10)];
                        stdadrdsB  = [std(popMDBeni(1:10))/sqrt(10) std(popMDBeni(end-9:end))/sqrt(10)];
                        
                        stdadrdsC  = [std(popMDUP(1:10))/sqrt(10) std(popMDUP(end-9:end))/sqrt(10)];
                        stdadrdsD  = [std(popMDBeniUP(1:10))/sqrt(10) std(popMDBeniUP(end-9:end))/sqrt(10)];
                        
                        meanA = mean(popMD(1:10));
                        meanB = mean(popMD(end-9:end));
                        meanC = mean(popMDBeni(1:10)) ;
                        meanD = mean(popMDBeni(end-9:end));
                        
                        if separateDecays
                            meanI = mean(popMDUP(1:10));
                            meanJ = mean(popMDUP(end-9:end));
                            meanK = mean(popMDBeniUP(1:10)) ;
                            meanL = mean(popMDBeniUP(end-9:end));
                        end
                    else
                        stdadrdsA  = [std(popMD(1:10))/sqrt(10) std(popMD(fitUpTo-9:fitUpTo))/sqrt(10)];
                        stdadrdsB  = [std(popMDBeni(1:10))/sqrt(10) std(popMDBeni(fitUpTo-9:fitUpTo))/sqrt(10)];
                        
                        stdadrdsC  = [std(popMDUP(1:10))/sqrt(10) std(popMDUP(fitUpTo-9:fitUpTo))/sqrt(10)];
                        stdadrdsD  = [std(popMDBeniUP(1:10))/sqrt(10) std(popMDBeniUP(fitUpTo-9:fitUpTo))/sqrt(10)];
                        
                        meanA = mean(popMD(1:10));
                        meanB = mean(popMD(fitUpTo-9:fitUpTo));
                        meanC = mean(popMDBeni(1:10)) ;
                        meanD = mean(popMDBeni(fitUpTo-9:fitUpTo));
                        
                        if separateDecays
                            meanI = mean(popMDUP(1:10));
                            meanJ = mean(popMDUP(fitUpTo-9:fitUpTo));
                            meanK = mean(popMDBeniUP(1:10)) ;
                            meanL = mean(popMDBeniUP(fitUpTo-9:fitUpTo));
                        end
                    end
                    
                    
                    errorbar([meanA meanB ],stdadrdsA,'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                    errorbar([meanC meanD],stdadrdsB,'^r','LineWidth',1,'MarkerSize',circleSize3),hold on
                    line([1 2],[meanA meanB ],'color','b','linewidth',neuronAndre/lineThickDividor,'linestyle','-.')
                    line([1 2],[meanC meanD],'color','r','linewidth',neuronBeni/lineThickDividor)
                    
                    xlim([0.5 2.5])
                    if separateDecays
                        errorbar([meanI meanJ ],stdadrdsC,'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                        errorbar([meanK meanL ], stdadrdsD,'^r','LineWidth',1,'MarkerSize',circleSize3),hold on
                        line([1 2],[meanI meanJ ],'color','b','linewidth',neuronCUP/lineThickDividor,'linestyle','-.')
                        line([1 2],[meanK meanL],'color','r','linewidth',neuronCBUP/lineThickDividor)
                    end
                    axis tight
                    set(gca,'xtick',[],'ytick',[])
                    axxs = axis;
                    if axxs(4)<=2 & axxs(4)> 1
                        ylimTop =2;
                    elseif axxs(4)==1
                        ylimTop =1;
                    elseif axxs(4)<=3
                        ylimTop =3;
                    elseif axxs(4)<=4
                        ylimTop =4;
                    elseif axxs(4)<=5
                        ylimTop =5;
                    elseif axxs(4)<=6
                        ylimTop =6;
                    else
                        ylimTop =round(axxs(4));
                    end
                    
                    if axxs(4) > 1
                        set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                    else
                        
                        set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                    end
                    set(gca,'xtick',[1  2],'xticklabel',{'1-10' ,  [num2str(fitUpTo-10) '-' num2str(fitUpTo)]})
                    if  plotlast10trials
                        set(gca,'xtick',[1  2],'xticklabel',{'1-10' , ['' num2str(numel(popMD)-10)  '-' num2str(numel(popMD)+1) '']})
                        text(2.2,0,['' num2str(numel(popMDBeni)-10)  '-' num2str(numel(popMDBeni)+1) ''],'color','r')
                    end
                    xlim([0.9 2.1])
                    axxs = axis;
                    ylim([0 axxs(4)+0.1])
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Trial number (Starting from last stimulus trial)')
                    title('population decay Activity')
                    axis square
                    
                    rsqAndre = sprintf('%.10f', popDecay.Andre.SIMPLErsquare);
                    rsqBeni = sprintf('%.10f', popDecay.Sara.SIMPLErsquare);
                    
                    maxYtxt = sprintf('%.10f', axxs(4) );
                    midYtxt = sprintf('%.10f', axxs(4)/2);
                    
                    pvAnd = sprintf('%.4f', Andre.PopDecay.pRS_Simple); if sum(str2num(pvAnd)) == 0,pvAnd = 0.0001;end
                    pvBeni = sprintf('%.4f', Sara.PopDecay.pRS_Simple); if sum(str2num(pvBeni)) == 0,pvBeni = 0.0001;end
                    if separateDecays
                        pvAndUP = sprintf('%.4f', Andre.PopDecayUP.pRS_Simple); if sum(str2num(pvAndUP)) == 0,pvAndUP = 0.0001;end
                        pvBeniUP = sprintf('%.4f', Sara.PopDecayUP.pRS_Simple); if sum(str2num(pvBeniUP)) == 0,pvBeniUP = 0.0001;end
                    end
                    
                    text(1.025,meanA+.1,[ 'n = ' num2str(neuronC) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    text(1.025,meanC-.125,[ 'n = ' num2str(neuronCB) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    
                    if separateDecays
                        text(1.025,meanI+.12,[ 'n = ' num2str(neuronCUP) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(1.025,meanC-.125,[ 'n = ' num2str(neuronCB) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        text(1.025,meanK-.05,[ 'n = ' num2str(neuronCBUP)],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(1.7025,meanJ+.05,[ 'p < ' num2str(pvAnd) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                    end
                    if separateDecays
                        text(1.7025,meanB+.105,[ 'p < ' num2str(pvAndUP) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(1.7025,meanL+.05,[ 'p < ' num2str(pvBeni) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        text(1.7025,meanD-.05,[ 'p < ' num2str(pvBeniUP)],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    end
                    if axxs(4) > 1
                        set(gca,'ytick',[0 1 ],'yticklabel',[0 1 ])
                    else
                        
                        set(gca,'ytick',[0  1],'yticklabel',[0  1])
                    end
                else
                    if  separateDecays
                        axes('Units','normalized','position',[loca(4,1:2) loca(4,3) loca(4,4)/2]),cla
                    else
                        axes('Units','normalized','position',loca(4,:)),cla
                    end
                    
                    yyaxis left
                    
                    plot(popMD(1:fitUpTo),'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                    plot(popMDBeni(1:fitUpTo),'^r','LineWidth',1,'MarkerSize',circleSize3),hold on
                    
                    plot(popDecay.Andre.SIMPLEpopulation(1:fitUpTo), '-.b','LineWidth',2), hold on
                    plot(popDecay.Sara.SIMPLEpopulation(1:fitUpTo), '-.r','LineWidth',2), hold on
                    
                    axis tight
                    axxs = axis;
                    y1axxs4 =  axxs(4);
                    xlim([0 fitUpTo])
                    
                    
                    minxy = min([popMDBeni(1:fitUpTo); popMD(1:fitUpTo)]);
                    maxxy = max([popMDBeni(1:fitUpTo); popMD(1:fitUpTo)]);
                    
                    rsqAndre = sprintf('%.10f', popDecay.Andre.SIMPLErsquare);
                    rsqBeni = sprintf('%.10f', popDecay.Sara.SIMPLErsquare);
                    
                    maxYtxt = sprintf('%.10f', axxs(4) );
                    midYtxt = sprintf('%.10f', axxs(4)/2);
                    
                    
                    pvAnd = sprintf('%.10f', Andre.PopDecay.pRS_Simple);
                    pvBeni = sprintf('%.10f', Sara.PopDecay.pRS_Simple);
                    
                    
                    
                    text(2,axxs(4)/0.8,[ '(n = ' num2str(neuronC) ' ; rsquare: ' rsqAndre ')'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    text(1,axxs(4)/5,[ 'p = ' num2str(pvAnd) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    
                    
                    text(25,axxs(4)/5,[ 'p = ' num2str(pvBeni) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    text(1,axxs(4)/0.85,[ '(n = ' num2str(neuronCB) ' ; rsquare: ' rsqBeni ')'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    
                    
                    namesA = coeffnames(popDecay.Andre.SIMPLEpopulation);
                    namesB = coeffnames(popDecay.Sara.SIMPLEpopulation);
                    if strmatch(fitMeth,'exp2')
                        
                        text(2,axxs(4)/2.5,[ 'decay: ' num2str([popDecay.Andre.SIMPLEpopulation.b  popDecay.Andre.SIMPLEpopulation.d]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        text(2,axxs(4)/3.5,[ 'decay: ' num2str([popDecay.Sara.SIMPLEpopulation.b  popDecay.Sara.SIMPLEpopulation.d]) ' trials'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                    else
                        if ismember('b',namesA)
                            text(2,axxs(4)/2.5,[ 'decay: ' num2str([popDecay.Andre.SIMPLEpopulation.b ]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        end
                        if ismember('b',namesB)
                            text(2,axxs(4)/3.5,[ 'decay: ' num2str([popDecay.Sara.SIMPLEpopulation.b  ]) ' trials'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        end
                    end
                    text(2,axxs(4)/10.2,[ 'prsn: ' num2str(Andre.PVALAndreSIMPLEBaseM)],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    text(25,axxs(4)/10.2,[ 'prsn: ' num2str(Sara.PVALAndreSIMPLEBaseM)],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                    
                    difft = ceil(axxs(4))-axxs(4);
                    if difft > 0.75
                        ylimTop = axxs(4) + (difft-0.75);
                    else
                        ylimTop = ceil(axxs(4));
                    end
                    
                    if axxs(4) > 1
                        set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                    else
                        
                        set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                    end
                    
                    set(gca,'XTick',[1 fitUpTo/2 fitUpTo],'XTickLabel',[1 fitUpTo/2 fitUpTo],'xcolor','k','ycolor','k');%[0.15 0.15 0.15]
                    
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Trial number (Starting from last stimulus trial)')
                    title('population decay Activity')
                    
                    ylim([0  ylimTop+.15])
                    ytop1 = ylimTop;
                    axxs = axis;
                    y1ylim = axxs(4);
                    
                    set(gca,'XTick',[1 fitUpTo/2 fitUpTo],'XTickLabel',[1 fitUpTo/2 fitUpTo],'xcolor','k','ycolor','k');%[0.15 0.15 0.15]%[0.15 0.15 0.15]
                    
                    ylabel('Normalized activity (sp/sec)')
                    xlabel('Total number starting from last stimulus trial)')
                    title('population decay Activity')
                    if plotMemVsBase
                        yyaxis right
                        
                        plot(popMDbase(1:fitUpTo),'ob','LineWidth',1,'MarkerSize',circleSize3,'MarkerFaceColor','b'),hold on
                        plot(popMDBenibase(1:fitUpTo),'^r','LineWidth',1,'MarkerSize',circleSize3,'MarkerFaceColor','r'),hold on
                        
                        plot(popDecay.Andre.baseSIMPLEpopulation(1:fitUpTo), '-b','LineWidth',2), hold on
                        plot(popDecay.Sara.baseSIMPLEpopulation(1:fitUpTo), '-r','LineWidth',2), hold on
                        
                        axxs = axis;
                        xlim([0 fitUpTo])
                        
                        
                        minxy = min([popMDBenibase(1:fitUpTo); popMDbase(1:fitUpTo)]);
                        maxxy = max([popMDBenibase(1:fitUpTo); popMDbase(1:fitUpTo)]);
                        
                        rsqAndre = sprintf('%.10f', popDecay.Andre.baseSIMPLErsquare);
                        rsqBeni = sprintf('%.10f', popDecay.Sara.baseSIMPLErsquare);
                        
                        maxYtxt = sprintf('%.10f', axxs(4) );
                        midYtxt = sprintf('%.10f', axxs(4)/2);
                        
                        namesA = coeffnames(popDecay.Andre.baseSIMPLEpopulation);
                        namesB = coeffnames(popDecay.Sara.baseSIMPLEpopulation);
                        
                        text(30,axxs(4)/1.6,[ '(n = ' num2str(neuronC) ' ; rsquare: ' rsqAndre ')'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        text(30,axxs(4)/1.4,[ '(n = ' num2str(neuronCB) ' ; rsquare: ' rsqBeni ')'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        if strmatch(fitMeth,'exp2')
                            text(30,axxs(4)/1.1,[ 'decay: ' num2str([popDecay.Andre.baseSIMPLEpopulation.b  popDecay.Andre.baseSIMPLEpopulation.d]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            text(30,axxs(4)/1.25,[ 'decay: ' num2str([popDecay.Sara.baseSIMPLEpopulation.b  popDecay.Sara.baseSIMPLEpopulation.d]) ' trials'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        else
                            if ismember('b',namesA)
                                text(30,axxs(4)/1.1,[ 'decay: ' num2str([popDecay.Andre.baseSIMPLEpopulation.b ]) ' trials'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            end
                            if ismember('b',namesB)
                                text(30,axxs(4)/1.25,[ 'decay: ' num2str([popDecay.Sara.baseSIMPLEpopulation.b  ]) ' trials'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                            end
                        end
                        
                        
                        difft = ceil(axxs(4))-axxs(4);
                        if difft > 0.5
                            ylimTop = axxs(4) + (difft-0.5);
                        else
                            ylimTop = ceil(axxs(4));
                        end
                        
                        ytop1 = ytop1*magRatio;
                        
                        
                        if (round(ytop1,-1) - (ytop1)) < 0
                            ytop1 = round(ytop1,-1)+ 5;
                        else
                            ytop1 = round(ytop1,-1);
                        end
                        
                        
                        
                        
                        if axxs(4) > 1
                            set(gca,'ytick',[0 round(ytop1/2)  round(ytop1)],'yticklabel',[0 round(ytop1/2) round(ytop1)]),  hold on
                        else
                            
                            set(gca,'ytick',[0  ytop1],'yticklabel',[axxs(3)  ytop1]),  hold on
                        end
                        
                        difft = (magRatio*y1ylim);
                        if (round(difft,-1) - (magRatio*y1ylim)) < 0
                            ylimTop = round(difft,-1)+ 5;
                        else
                            ylimTop = round(difft,-1);
                        end
                        
                        ylim([0   ytop1+5]),  hold on
                        
                        xlim([0 fitUpTo+1]),  hold on
                        
                        hold on
                    end
                    if DecayGoodOnly & separateDecays
                        fitUpTo = min(numel(popMDUP),fitUpTo);
                        axes('Units','normalized','position',[loca(4,1) loca(4,2)+(loca(4,4)/2) loca(4,3) loca(4,4)/2]),cla
                        errorbar(popMDUP(1:fitUpTo),PpopSTDUP(1:fitUpTo),'ob','LineWidth',1,'MarkerSize',circleSize3),hold on
                        errorbar(popMDBeniUP(1:fitUpTo),PpopSTDBeniUP(1:fitUpTo),'^r','LineWidth',1,'MarkerSize',circleSize3),hold on
                        plot(popDecayUP.Andre.SIMPLEpopulation(1:fitUpTo), '-b','LineWidth',2), hold on
                        plot(popDecayUP.Sara.SIMPLEpopulation(1:fitUpTo), '-.r','LineWidth',2), hold on
                        axis tight
                        axiss=axis;
                        axiss=axis;
                        
                        difft = ceil(axxs(4))-axxs(4);
                        if difft > 0.5
                            ylimTop = axxs(4) + (difft-0.5);
                        else
                            ylimTop = ceil(axxs(4));
                        end
                        if axxs(4) > 1
                            set(gca,'ytick',[0 1 ylimTop],'yticklabel',[0 1 ylimTop])
                        else
                            
                            set(gca,'ytick',[0  ylimTop],'yticklabel',[axxs(3)  ylimTop])
                        end
                        set(gca,'XTick',[ ],'xcolor','k','ycolor','k');
                        xlim([0 fitUpTo])
                        
                        axxs = axis;
                        minxy = min([popMDBeni(1:fitUpTo); popMD(1:fitUpTo)]);
                        maxxy = max([popMDBeni(1:fitUpTo); popMD(1:fitUpTo)]);
                        
                        rsqAndreUP = sprintf('%.10f', popDecayUP.Andre.SIMPLErsquare);
                        rsqBeniUP = sprintf('%.10f', popDecayUP.Sara.SIMPLErsquare);
                        
                        maxYtxtUP = sprintf('%.10f', axxs(4) );
                        midYtxtUP = sprintf('%.10f', axxs(4)/2);
                        
                        pvAndUP = sprintf('%.10f', Andre.PopDecayUP.pRS_Simple);
                        pvBeniUP = sprintf('%.10f', Sara.PopDecayUP.pRS_Simple);
                        
                        text(5,axxs(4)/4.05,[ 'p = ' num2str(pvAndUP) ],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        text(25,axxs(4)/4.05,[ 'p = ' num2str(pvBeniUP) ],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                        
                        text(5,axxs(4),[ '(n = ' num2str(neuronCUP) ' ; rsquare: ' rsqAndreUP ')'],'color',MarkerFaceColorAndre,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        text(5,axxs(4)/2,[ '(n = ' num2str(neuronCBUP) ' ; rsquare: ' rsqBeniUP ')'],'color',MarkerFaceColorSara,'fontsize',12,'fontweight','normal','fontname','helvetica'),hold on
                        
                    end
                    
                end
            end
        end
        axis square
        ax = gca; ax.LineWidth = 1;
        ax.XColor ='k';ax.YColor ='k';
    end
end
%% legend panel
linespaci = 0.001;

axes('Units','normalized','position',loca(1,:)+[0.65 -0.2  -0.2 0]),cla,axis off

plot(0,2,'ob','LineWidth',1,'MarkerSize',circleSize*2),hold on

text(0.1,2,' Monkey A','color',MarkerFaceColorAndre,'fontsize',13),hold on,axis off,

plot(0,1.8,'^r','LineWidth',1,'MarkerSize',circleSize*2),hold on

text(0.1,1.8,' Monkey B','color',MarkerFaceColorSara,'fontsize',13),hold on


text(0,2.8,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE))   '/' num2str(( Andre.StatSIMPLEpopCount)) ' (stat/NoEyePos_with_vis_pop )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0,2.6,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE))  '/' num2str((Sara.StatSIMPLEpopCount))],'color',MarkerFaceColorSara,'fontsize',15),hold on

text(0,1.5,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE))  '/' num2str((Andre.ALlSimpleCount))  ' (stat/recorded )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0,1.3,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE)) '/' num2str((Sara.ALlSimpleCount))],'color',MarkerFaceColorSara,'fontsize',15),hold on

text(0,1,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE)) '/' num2str((Andre.ALlSimpleCountNoStat)) ' (stat/above indices )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0,0.8,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE))  '/' num2str((Sara.ALlSimpleCountNoStat))],'color',MarkerFaceColorSara,'fontsize',15),hold on

text(0,0.5,['n = ' num2str(numel(Andre.statPostMemoryBaseline_ALL_SIMPLE))   '/' num2str((Andre.ALlSimpleCountSTATMAXTWOWAY)) ' (stat/statMaxTwoWay )'],'color',MarkerFaceColorAndre,'fontsize',15),hold on
text(0,0.3,['n = ' num2str(numel(Sara.statPostMemoryBaseline_ALL_SIMPLE))  '/' num2str((Sara.ALlSimpleCountSTATMAXTWOWAY))],'color',MarkerFaceColorSara,'fontsize',15),hold on

ylim([0 2])
xlim([0 2])

title('SIMPLE task','fontsize',20)
axis off
