%% go through example sessions: scatter plot of coh vs. evoked resp @ theta band
load('Figure3B_SourceData.mat')
path('helpers',path) 


%% example 1
figure

% linear regression
X = addones(ER_ex1);
Y = C_ex1;
[B,~,~,~,stats] = regress(Y,X);
r2 = stats(1);
p = stats(3);

% plot
clf, hold on
scatter(X(:,2),Y,'o')
xx = minmax(X(:,2));
yy = B(1) + B(2)*xx;
plot(xx,yy,'-k')
xlabel('Normalized Evoked Response')
ylabel('\theta Coherence')
title('Example Session 1')
text(.45,.5,sprintf('y = %.2f + %.2fx',B(1),B(2)),'FontSize',14)
text(.45,.45,sprintf('r^2 = %.2f',r2),'FontSize',14)
text(.45,.4,sprintf('p < .01'),'FontSize',14)
set(gca,'XTick',.2:.1:.7)

%% example 2
figure

% linear regression
X = addones(ER_ex2);
Y = C_ex2;
[B,~,~,~,stats] = regress(Y,X);
r2 = stats(1);
p = stats(3);

% plot
clf, hold on
scatter(X(:,2),Y,'o')
xx = minmax(X(:,2));
yy = B(1) + B(2)*xx;
plot(xx,yy,'-k')
xlabel('Normalized Evoked Response')
ylabel('\theta Coherence')
title('Example Session 2')
text(.3,.5,sprintf('y = %.2f + %.2fx',B(1),B(2)),'FontSize',14)
text(.3,.45,sprintf('r^2 = %.2f',r2),'FontSize',14)
text(.3,.4,sprintf('p < .01'),'FontSize',14)
set(gca,'XTick',.2:.1:.4)

%% example 3
figure

% linear regression
X = addones(ER_ex3);
Y = C_ex3;
[B,~,~,~,stats] = regress(Y,X);
r2 = stats(1);
p = stats(3);

% plot
clf, hold on
scatter(X(:,2),Y,'o')
xx = minmax(X(:,2));
yy = B(1) + B(2)*xx;
plot(xx,yy,'-k')
xlabel('Normalized Evoked Response')
ylabel('\theta Coherence')
title('Example Session 3')
text(.73,.63,sprintf('y = %.2f + %.2fx',B(1),B(2)),'FontSize',14)
text(.73,.62,sprintf('r^2 = %.2f',r2),'FontSize',14)
text(.73,.61,sprintf('p < .01'),'FontSize',14)
% set(gca,'XTick',.2:.1:.4)
